/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    private final MyVirtualFile myRoot = new MyVirtualFile("", null);
    public static final String PROTOCOL = "mock";

    @NotNull
    public MyVirtualFile findFileByPath(@NotNull String path) {
        path = path.replace(File.separatorChar, '/');
        if (StringUtil.startsWithChar((CharSequence)(path = path.replace('/', ':')), (char)':')) {
            path = path.substring(1);
        }
        MyVirtualFile file2 = this.myRoot;
        for (String component : StringUtil.split((String)path, (String)":")) {
            file2 = file2.getOrCreate(component);
        }
        return file2;
    }

    @NotNull
    public MockVirtualFileSystem file(@NotNull String path, @NotNull String data) {
        MyVirtualFile file2 = this.findFileByPath(path);
        file2.setContent(null, data, false);
        return this;
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return this.findFileByPath(path);
    }

    public class MyVirtualFile
    extends LightVirtualFile {
        @Nullable
        private Map<String, MyVirtualFile> myChildren;
        private final MyVirtualFile myParent;

        MyVirtualFile(@Nullable String name, MyVirtualFile parent) {
            super(name);
            this.myParent = parent;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            return MockVirtualFileSystem.this;
        }

        @NotNull
        public MyVirtualFile getOrCreate(@NotNull String name) {
            MyVirtualFile file2 = this.findChild(name);
            if (file2 == null) {
                if (this.myChildren == null) {
                    this.myChildren = new THashMap();
                }
                file2 = new MyVirtualFile(name, this);
                this.myChildren.put(name, file2);
            }
            return file2;
        }

        public boolean isDirectory() {
            return this.myParent == null || this.myChildren != null && !this.myChildren.isEmpty();
        }

        @NotNull
        public String getPath() {
            MyVirtualFile parent = this.getParent();
            return parent == null ? this.getName() : parent.getPath() + "/" + this.getName();
        }

        public MyVirtualFile getParent() {
            return this.myParent;
        }

        public VirtualFile[] getChildren() {
            if (this.myChildren == null || this.myChildren.isEmpty()) {
                return EMPTY_ARRAY;
            }
            Collection<MyVirtualFile> children2 = this.myChildren.values();
            return (VirtualFile[])children2.toArray(new MyVirtualFile[children2.size()]);
        }

        @Nullable
        public MyVirtualFile findChild(@NotNull @NonNls String name) {
            return this.myChildren == null ? null : this.myChildren.get(name);
        }
    }
}

