/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.impl.ui.NotificationsUtil");
    private static final int TITLE_LIMIT = 1000;
    private static final int CONTENT_LIMIT = 10000;

    @NotNull
    public static String buildHtml(@NotNull Notification notification, @Nullable String style) {
        String title = notification.getTitle();
        String content = notification.getContent();
        if (title.length() > 1000 || content.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title + "\nContent=" + content);
            title = StringUtil.trimLog((String)title, (int)1000);
            content = StringUtil.trimLog((String)content, (int)10000);
        }
        return NotificationsUtil.buildHtml(title, null, content, style, "#" + ColorUtil.toHex((Color)NotificationsUtil.getMessageType(notification).getTitleForeground()), null, null);
    }

    @NotNull
    public static String buildHtml(@NotNull Notification notification, @Nullable String style, boolean isContent, @Nullable Color color, @Nullable String contentStyle) {
        String content;
        String title = !isContent ? notification.getTitle() : "";
        String subtitle = !isContent ? notification.getSubtitle() : null;
        String string = content = isContent ? notification.getContent() : "";
        if (title.length() > 1000 || StringUtil.length((CharSequence)subtitle) > 1000 || content.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title + "\nSubtitle=" + subtitle + "\nContent=" + content);
            title = StringUtil.trimLog((String)title, (int)1000);
            subtitle = StringUtil.trimLog((String)StringUtil.notNullize((String)subtitle), (int)1000);
            content = StringUtil.trimLog((String)content, (int)10000);
        }
        if (isContent) {
            content = StringUtil.replace((String)content, (String)"<p/>", (String)"<br>");
        }
        String colorText = color == null ? null : "#" + ColorUtil.toHex((Color)color);
        return NotificationsUtil.buildHtml(title, subtitle, content, style, isContent ? null : colorText, isContent ? colorText : null, contentStyle);
    }

    @NotNull
    public static String buildHtml(@Nullable String title, @Nullable String subtitle, @Nullable String content, @Nullable String style, @Nullable String titleColor, @Nullable String contentColor, @Nullable String contentStyle) {
        if (StringUtil.isEmpty((String)title) && !StringUtil.isEmpty((String)subtitle)) {
            title = subtitle;
            subtitle = null;
        } else if (!StringUtil.isEmpty((String)title) && !StringUtil.isEmpty((String)subtitle)) {
            title = title + ":";
        }
        StringBuilder result2 = new StringBuilder();
        if (style != null) {
            result2.append("<div style=\"").append(style).append("\">");
        }
        if (!StringUtil.isEmpty((String)title)) {
            result2.append("<b").append(titleColor == null ? ">" : " color=\"" + titleColor + "\">").append(title).append("</b>");
        }
        if (!StringUtil.isEmpty((String)subtitle)) {
            result2.append("&nbsp;").append(titleColor == null ? "" : "<span color=\"" + titleColor + "\">").append(subtitle).append(titleColor == null ? "" : "</span>");
        }
        if (!StringUtil.isEmpty((String)content)) {
            result2.append("<div").append(contentStyle == null ? "" : " style=\"" + contentStyle + "\"").append(contentColor == null ? ">" : " color=\"" + contentColor + "\">").append(content).append("</div>");
        }
        if (style != null) {
            result2.append("</div>");
        }
        return XmlStringUtil.wrapInHtml((CharSequence)result2.toString());
    }

    @Nullable
    public static String getFontStyle() {
        String fontName = NotificationsUtil.getFontName();
        return StringUtil.isEmpty((String)fontName) ? null : "font-family:" + fontName + ";";
    }

    @Nullable
    public static Pair<String, Integer> getFontData() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            return Pair.create((Object)uiSettings.getFontFace(), (Object)uiSettings.getFontSize());
        }
        return UIUtil.getSystemFontData();
    }

    @Nullable
    public static String getFontName() {
        Pair<String, Integer> data = NotificationsUtil.getFontData();
        return data == null ? null : (String)data.first;
    }

    @Nullable
    public static HyperlinkListener wrapListener(final @NotNull Notification notification) {
        NotificationListener listener2 = notification.getListener();
        if (listener2 == null) {
            return null;
        }
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener listener1;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (listener1 = notification.getListener()) != null) {
                    listener1.hyperlinkUpdate(notification, e);
                }
            }
        };
    }

    @NotNull
    public static Icon getIcon(@NotNull Notification notification) {
        Icon icon = notification.getIcon();
        if (icon != null) {
            return icon;
        }
        switch (notification.getType()) {
            case WARNING: {
                return AllIcons.General.BalloonWarning;
            }
            case ERROR: {
                return AllIcons.Ide.FatalError;
            }
        }
        return AllIcons.General.BalloonInformation;
    }

    @NotNull
    public static MessageType getMessageType(@NotNull Notification notification) {
        switch (notification.getType()) {
            case WARNING: {
                return MessageType.WARNING;
            }
            case ERROR: {
                return MessageType.ERROR;
            }
        }
        return MessageType.INFO;
    }
}

