/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class PermanentInstallationID {
    private static final String OLD_USER_ON_MACHINE_ID_KEY = "JetBrains.UserIdOnMachine";
    private static final String INSTALLATION_ID_KEY = "user_id_on_machine";
    private static final String INSTALLATION_ID = PermanentInstallationID.calculateInstallationId();

    @NotNull
    public static String get() {
        return INSTALLATION_ID;
    }

    private static String calculateInstallationId() {
        File dir;
        String appdata;
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        Preferences oldPrefs = Preferences.userRoot();
        String oldValue = appInfo.isVendorJetBrains() ? oldPrefs.get(OLD_USER_ON_MACHINE_ID_KEY, null) : null;
        String companyName = appInfo.getShortCompanyName();
        Preferences prefs = Preferences.userRoot().node(StringUtil.isEmptyOrSpaces((String)companyName) ? "jetbrains" : companyName.toLowerCase(Locale.US));
        String installationId = prefs.get(INSTALLATION_ID_KEY, null);
        if (StringUtil.isEmptyOrSpaces((String)installationId)) {
            installationId = !StringUtil.isEmptyOrSpaces((String)oldValue) ? oldValue : UUID.randomUUID().toString();
            prefs.put(INSTALLATION_ID_KEY, installationId);
        }
        if (!appInfo.isVendorJetBrains()) {
            return installationId;
        }
        if (SystemInfo.isWindows && (appdata = System.getenv("APPDATA")) != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
            File permanentIdFile = new File(dir, "PermanentUserId");
            try {
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    fromFile = PermanentInstallationID.loadFromFile(permanentIdFile).trim();
                }
                if (!fromFile.isEmpty()) {
                    if (!fromFile.equals(installationId)) {
                        installationId = fromFile;
                        prefs.put(INSTALLATION_ID_KEY, installationId);
                    }
                } else {
                    PermanentInstallationID.writeToFile(permanentIdFile, installationId);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!installationId.equals(oldValue)) {
            oldPrefs.put(OLD_USER_ON_MACHINE_ID_KEY, installationId);
        }
        return installationId;
    }

    @NotNull
    private static String loadFromFile(@NotNull File file2) throws IOException {
        try (FileInputStream is = new FileInputStream(file2);){
            byte[] bytes = FileUtilRt.loadBytes((InputStream)is);
            int offset = CharsetToolkit.hasUTF8Bom((byte[])bytes) ? CharsetToolkit.UTF8_BOM.length : 0;
            String string = new String(bytes, offset, bytes.length - offset, CharsetToolkit.UTF8_CHARSET);
            return string;
        }
    }

    private static void writeToFile(@NotNull File file2, @NotNull String text) throws IOException {
        try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file2));){
            stream.write(text.getBytes(CharsetToolkit.UTF8_CHARSET));
        }
    }
}

