/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.TransactionGuardImpl");
    private final Queue<Transaction> myQueue = new LinkedBlockingQueue<Transaction>();
    private final Map<ModalityState, TransactionIdImpl> myModality2Transaction = ContainerUtil.createConcurrentWeakMap();
    private final Map<ModalityState, Boolean> myWriteSafeModalities = ContainerUtil.createConcurrentWeakMap();
    private TransactionIdImpl myCurrentTransaction;
    private boolean myWritingAllowed;
    private boolean myErrorReported;
    private static boolean ourTestingTransactions;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.NON_MODAL, true);
    }

    @NotNull
    private Queue<Transaction> getQueue(@Nullable TransactionIdImpl transaction) {
        while (transaction != null && transaction.myFinished) {
            transaction = transaction.myParent;
        }
        return transaction == null ? this.myQueue : transaction.myQueue;
    }

    private void pollQueueLater() {
        TransactionGuardImpl.invokeLater(() -> {
            Queue<Transaction> queue = this.getQueue(this.myCurrentTransaction);
            Transaction next = queue.peek();
            if (next != null && this.canRunTransactionNow(next, false)) {
                queue.remove();
                this.runSyncTransaction(next);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSyncTransaction(@NotNull Transaction transaction) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Disposer.isDisposed((Disposable)transaction.parentDisposable)) {
            return;
        }
        boolean wasWritingAllowed = this.myWritingAllowed;
        this.myWritingAllowed = true;
        this.myCurrentTransaction = new TransactionIdImpl(this.myCurrentTransaction);
        try {
            transaction.runnable.run();
        }
        finally {
            Queue<Transaction> queue = this.getQueue(this.myCurrentTransaction.myParent);
            queue.addAll(this.myCurrentTransaction.myQueue);
            if (!queue.isEmpty()) {
                this.pollQueueLater();
            }
            this.myWritingAllowed = wasWritingAllowed;
            this.myCurrentTransaction.myFinished = true;
            this.myCurrentTransaction = this.myCurrentTransaction.myParent;
        }
    }

    public void submitTransaction(@NotNull Disposable parentDisposable, @Nullable TransactionId expectedContext, @NotNull Runnable _transaction) {
        TransactionIdImpl expectedId = (TransactionIdImpl)expectedContext;
        Transaction transaction = new Transaction(_transaction, expectedId, parentDisposable);
        Application app = ApplicationManager.getApplication();
        boolean isDispatchThread = app.isDispatchThread();
        Runnable runnable2 = () -> {
            if (this.canRunTransactionNow(transaction, isDispatchThread)) {
                this.runSyncTransaction(transaction);
            } else {
                this.getQueue(expectedId).offer(transaction);
                this.pollQueueLater();
            }
        };
        if (isDispatchThread) {
            runnable2.run();
        } else {
            TransactionGuardImpl.invokeLater(runnable2);
        }
    }

    private boolean canRunTransactionNow(Transaction transaction, boolean sync) {
        if (sync && !this.myWritingAllowed) {
            return false;
        }
        TransactionIdImpl currentId = this.myCurrentTransaction;
        if (currentId == null) {
            return true;
        }
        return transaction.expectedContext != null && currentId.myStartCounter <= transaction.expectedContext.myStartCounter;
    }

    public void submitTransactionAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            Transaction transaction = new Transaction(runnable2, this.getContextTransaction(), (Disposable)app);
            if (!this.canRunTransactionNow(transaction, true)) {
                String message2 = "Cannot run synchronous submitTransactionAndWait from invokeLater. Please use asynchronous submit*Transaction. See TransactionGuard FAQ for details.\nTransaction: " + runnable2;
                if (!this.isWriteSafeModality(ModalityState.current())) {
                    message2 = message2 + "\nUnsafe modality: " + ModalityState.current();
                }
                LOG.error(message2);
            }
            this.runSyncTransaction(transaction);
            return;
        }
        if (app.isReadAccessAllowed()) {
            throw new IllegalStateException("submitTransactionAndWait should not be invoked from a read action");
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        Throwable[] exception = new Throwable[]{null};
        this.submitTransaction(Disposer.newDisposable((String)"never disposed"), this.getContextTransaction(), () -> {
            try {
                runnable2.run();
            }
            catch (Throwable e) {
                exception[0] = e;
            }
            finally {
                semaphore.up();
            }
        });
        semaphore.waitFor();
        if (exception[0] != null) {
            throw new RuntimeException(exception[0]);
        }
    }

    public void performUserActivity(Runnable activity) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AccessToken token = this.startActivity(true);
        try {
            activity.run();
        }
        finally {
            token.finish();
        }
    }

    @NotNull
    public AccessToken startActivity(boolean userActivity) {
        boolean allowWriting;
        this.myErrorReported = false;
        boolean bl = allowWriting = userActivity && this.isWriteSafeModality(ModalityState.current());
        if (this.myWritingAllowed == allowWriting) {
            return AccessToken.EMPTY_ACCESS_TOKEN;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final boolean prev = this.myWritingAllowed;
        this.myWritingAllowed = allowWriting;
        return new AccessToken(){

            public void finish() {
                TransactionGuardImpl.this.myWritingAllowed = prev;
            }
        };
    }

    public boolean isWriteSafeModality(ModalityState state) {
        return Boolean.TRUE.equals(this.myWriteSafeModalities.get(state));
    }

    public void assertWriteActionAllowed() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (TransactionGuardImpl.areAssertionsEnabled() && !this.myWritingAllowed && !this.myErrorReported) {
            String message2 = "Write access is allowed from write-safe contexts only. Please ensure you're using invokeLater/invokeAndWait with a correct modality state (not \"any\"). See TransactionGuard documentation for details.\n  current modality=" + ModalityState.current() + "\n  known modalities=" + this.myWriteSafeModalities;
            LOG.error(message2);
            this.myErrorReported = true;
        }
    }

    private static boolean areAssertionsEnabled() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() && !ourTestingTransactions) {
            return false;
        }
        if (app instanceof ApplicationEx && !((ApplicationEx)app).isLoaded()) {
            return false;
        }
        return Registry.is((String)"ide.require.transaction.for.model.changes", (boolean)false);
    }

    public void submitTransactionLater(@NotNull Disposable parentDisposable, @NotNull Runnable transaction) {
        TransactionIdImpl id = this.getContextTransaction();
        ModalityState startModality = ModalityState.defaultModalityState();
        TransactionGuardImpl.invokeLater(() -> {
            boolean allowWriting = ModalityState.current() == startModality;
            AccessToken token = this.startActivity(allowWriting);
            try {
                this.submitTransaction(parentDisposable, id, transaction);
            }
            finally {
                token.finish();
            }
        });
    }

    private static void invokeLater(Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.any(), Condition.FALSE);
    }

    public TransactionIdImpl getContextTransaction() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return this.myModality2Transaction.get(ModalityState.defaultModalityState());
        }
        return this.myWritingAllowed ? this.myCurrentTransaction : null;
    }

    public void enteredModality(@NotNull ModalityState modality) {
        TransactionIdImpl contextTransaction = this.getContextTransaction();
        if (contextTransaction != null) {
            this.myModality2Transaction.put(modality, contextTransaction);
        }
        this.myWriteSafeModalities.put(modality, this.myWritingAllowed);
    }

    @Nullable
    public TransactionIdImpl getModalityTransaction(@NotNull ModalityState modalityState) {
        return this.myModality2Transaction.get(modalityState);
    }

    @NotNull
    public Runnable wrapLaterInvocation(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (this.isWriteSafeModality(modalityState)) {
            return new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    boolean prev = TransactionGuardImpl.this.myWritingAllowed;
                    TransactionGuardImpl.this.myWritingAllowed = true;
                    try {
                        runnable2.run();
                    }
                    finally {
                        TransactionGuardImpl.this.myWritingAllowed = prev;
                    }
                }

                public String toString() {
                    return runnable2.toString();
                }
            };
        }
        return runnable2;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("currentTransaction", (Object)this.myCurrentTransaction).add("writingAllowed", this.myWritingAllowed).toString();
    }

    public static void setTestingTransactions(boolean testingTransactions) {
        ourTestingTransactions = testingTransactions;
    }

    private static class TransactionIdImpl
    implements TransactionId {
        private static final AtomicLong ourTransactionCounter = new AtomicLong();
        final long myStartCounter = ourTransactionCounter.getAndIncrement();
        final Queue<Transaction> myQueue = new LinkedBlockingQueue<Transaction>();
        boolean myFinished;
        final TransactionIdImpl myParent;

        public TransactionIdImpl(@Nullable TransactionIdImpl parent) {
            this.myParent = parent;
        }

        public String toString() {
            return "Transaction " + this.myStartCounter + (this.myFinished ? "(finished)" : "");
        }
    }

    private static class Transaction {
        @NotNull
        final Runnable runnable;
        @Nullable
        final TransactionIdImpl expectedContext;
        @NotNull
        final Disposable parentDisposable;

        Transaction(@NotNull Runnable runnable2, @Nullable TransactionIdImpl expectedContext, @NotNull Disposable parentDisposable) {
            this.runnable = runnable2;
            this.expectedContext = expectedContext;
            this.parentDisposable = parentDisposable;
        }
    }
}

