/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakHashMap;
import io.netty.util.internal.SystemPropertyUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaterInvocator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.LaterInvocator");
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final Object LOCK = new Object();
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Map<Project, List<Dialog>> projectToModalEntities = new WeakHashMap();
    private static final Map<Project, Stack<ModalityState>> projectToModalEntitiesStack = new WeakHashMap();
    private static final Stack<ModalityState> ourModalityStack = new Stack((Object[])new ModalityState[]{ModalityState.NON_MODAL});
    private static final List<RunnableInfo> ourQueue = new ArrayList<RunnableInfo>();
    private static volatile int ourQueueSkipCount;
    private static final FlushQueue ourFlushQueueRunnable;
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster;
    private static final AtomicBoolean FLUSHER_SCHEDULED;

    private LaterInvocator() {
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener2, @NotNull Disposable parentDisposable) {
        if (!ourModalityStateMulticaster.getListeners().contains(listener2)) {
            ourModalityStateMulticaster.addListener((EventListener)listener2, parentDisposable);
        }
    }

    public static void removeModalityStateListener(@NotNull ModalityStateListener listener2) {
        ourModalityStateMulticaster.removeListener((EventListener)listener2);
    }

    @NotNull
    static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        int index = ourModalEntities.indexOf(window);
        if (index < 0) {
            Window owner = window.getOwner();
            if (owner == null) {
                return (ModalityStateEx)ApplicationManager.getApplication().getNoneModalityState();
            }
            ModalityStateEx ownerState = LaterInvocator.modalityStateForWindow(owner);
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                return ownerState.appendEntity(window);
            }
            return ownerState;
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object entity : ourModalEntities) {
            if (!(entity instanceof Window) && (!(entity instanceof ProgressIndicator) || !((ProgressIndicator)entity).isModal())) continue;
            result2.add(entity);
        }
        return new ModalityStateEx(result2.toArray());
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        return LaterInvocator.invokeLater(runnable2, modalityState, expired);
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        return LaterInvocator.invokeLater(runnable2, modalityState, Conditions.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired) {
        if (expired.value(null)) {
            return ActionCallback.REJECTED;
        }
        ActionCallback callback = new ActionCallback();
        RunnableInfo runnableInfo = new RunnableInfo(runnable2, modalityState, expired, callback);
        Object object = LOCK;
        synchronized (object) {
            ourQueue.add(runnableInfo);
        }
        LaterInvocator.requestFlush();
        return callback;
    }

    static void invokeAndWait(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        LOG.assertTrue(!LaterInvocator.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref exception = Ref.create();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (Throwable e) {
                    exception.set((Object)e);
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "InvokeAndWait[" + runnable2 + "]";
            }
        };
        LaterInvocator.invokeLater(runnable1, modalityState);
        semaphore.waitFor();
        if (!exception.isNull()) {
            Throwable cause = (Throwable)exception.get();
            if (SystemPropertyUtil.getBoolean((String)"invoke.later.wrap.error", (boolean)true)) {
                throw new RuntimeException(cause);
            }
            ExceptionUtil.rethrow((Throwable)cause);
        }
    }

    public static void enterModal(@NotNull Object modalEntity) {
        TransactionGuardImpl guard;
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        ourModalEntities.add(modalEntity);
        ourModalityStack.push((Object)new ModalityStateEx(ArrayUtil.toObjectArray(ourModalEntities)));
        TransactionGuardImpl transactionGuardImpl = guard = IdeaApplication.isLoaded() ? (TransactionGuardImpl)TransactionGuard.getInstance() : null;
        if (guard != null) {
            guard.enteredModality((ModalityState)ourModalityStack.peek());
        }
    }

    public static void enterModal(Project project2, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + dialog2.getName() + " ; for project: " + project2.getName());
        }
        if (project2 == null) {
            LaterInvocator.enterModal(dialog2);
            return;
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        List<Dialog> modalEntitiesList = projectToModalEntities.getOrDefault(project2, ContainerUtil.createLockFreeCopyOnWriteList());
        projectToModalEntities.put(project2, modalEntitiesList);
        modalEntitiesList.add(dialog2);
        Stack<ModalityState> modalEntitiesStack = projectToModalEntitiesStack.getOrDefault(project2, (Stack<ModalityState>)new Stack((Object[])new ModalityState[]{ModalityState.NON_MODAL}));
        projectToModalEntitiesStack.put(project2, modalEntitiesStack);
        modalEntitiesStack.push((Object)new ModalityStateEx(ArrayUtil.toObjectArray(ourModalEntities)));
    }

    public static void leaveModal(Project project2, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + dialog2.getName() + " ; for project: " + project2.getName());
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(dialog2);
        if (index != -1) {
            ourModalEntities.remove(index);
            ourModalityStack.remove(index + 1);
            for (int i = 1; i < ourModalityStack.size(); ++i) {
                ((ModalityStateEx)((Object)ourModalityStack.get(i))).removeModality(dialog2);
            }
        } else if (project2 != null) {
            List<Dialog> dialogs = projectToModalEntities.get(project2);
            int perProjectIndex = dialogs.indexOf(dialog2);
            LOG.assertTrue(perProjectIndex >= 0);
            dialogs.remove(perProjectIndex);
            Stack<ModalityState> states = projectToModalEntitiesStack.get(project2);
            states.remove(perProjectIndex + 1);
            for (int i = 1; i < states.size(); ++i) {
                ((ModalityStateEx)((Object)states.get(i))).removeModality(dialog2);
            }
        }
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(modalEntity);
        LOG.assertTrue(index >= 0);
        ourModalEntities.remove(index);
        ourModalityStack.remove(index + 1);
        for (int i = 1; i < ourModalityStack.size(); ++i) {
            ((ModalityStateEx)((Object)ourModalityStack.get(i))).removeModality(modalEntity);
        }
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    public static void leaveAllModals() {
        while (!ourModalEntities.isEmpty()) {
            LaterInvocator.leaveModal(ourModalEntities.get(ourModalEntities.size() - 1));
        }
        LOG.assertTrue(LaterInvocator.getCurrentModalityState() == ModalityState.NON_MODAL, (Object)LaterInvocator.getCurrentModalityState());
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    public static Object[] getCurrentModalEntitiesForProject(Project project2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null || !ourModalEntities.isEmpty()) {
            return ArrayUtil.toObjectArray(ourModalEntities);
        }
        return ArrayUtil.toObjectArray((Collection)projectToModalEntities.get(project2));
    }

    @NotNull
    public static Object[] getCurrentModalEntities() {
        return LaterInvocator.getCurrentModalEntitiesForProject(null);
    }

    @NotNull
    public static ModalityState getCurrentModalityState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return (ModalityState)ourModalityStack.peek();
    }

    public static boolean isInModalContextForProject(Project project2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread());
        if (ourModalEntities.isEmpty()) {
            return false;
        }
        List<Dialog> modalEntitiesForProject = LaterInvocator.getModalEntitiesForProject(project2);
        return modalEntitiesForProject == null || modalEntitiesForProject.isEmpty();
    }

    private static List<Dialog> getModalEntitiesForProject(Project project2) {
        return projectToModalEntities.get(project2);
    }

    public static boolean isInModalContext() {
        return LaterInvocator.isInModalContextForProject(null);
    }

    private static boolean isDispatchThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    private static void requestFlush() {
        if (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
        }
    }

    public static boolean ensureFlushRequested() {
        if (LaterInvocator.getNextEvent(false) != null) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static RunnableInfo getNextEvent(boolean remove) {
        Object object = LOCK;
        synchronized (object) {
            ModalityState currentModality = LaterInvocator.getCurrentModalityState();
            while (ourQueueSkipCount < ourQueue.size()) {
                RunnableInfo info = ourQueue.get(ourQueueSkipCount);
                if (info.expired.value(null)) {
                    ourQueue.remove(ourQueueSkipCount);
                    info.callback.setDone();
                    continue;
                }
                if (!currentModality.dominates(info.modalityState)) {
                    if (remove) {
                        ourQueue.remove(ourQueueSkipCount);
                    }
                    return info;
                }
                ++ourQueueSkipCount;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RunnableInfo> getLaterInvocatorQueue() {
        Object object = LOCK;
        synchronized (object) {
            return ContainerUtil.newArrayList(ourQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeExpiredItems() {
        Object object = LOCK;
        synchronized (object) {
            boolean removed = false;
            for (int i = ourQueue.size() - 1; i >= 0; --i) {
                RunnableInfo info = ourQueue.get(i);
                if (!info.expired.value(null)) continue;
                ourQueue.remove(i);
                info.callback.setDone();
                removed = true;
            }
            if (removed) {
                ourQueueSkipCount = 0;
            }
        }
    }

    static {
        ourFlushQueueRunnable = new FlushQueue();
        ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
        FLUSHER_SCHEDULED = new AtomicBoolean(false);
    }

    private static class FlushQueue
    implements Runnable {
        private RunnableInfo myLastInfo;

        private FlushQueue() {
        }

        @Override
        public void run() {
            FLUSHER_SCHEDULED.set(false);
            if (this.runNextEvent()) {
                LaterInvocator.requestFlush();
            }
        }

        private boolean runNextEvent() {
            RunnableInfo lastInfo;
            this.myLastInfo = lastInfo = LaterInvocator.getNextEvent(true);
            if (lastInfo != null) {
                try {
                    lastInfo.runnable.run();
                    lastInfo.callback.setDone();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                finally {
                    if (!DEBUG) {
                        this.myLastInfo = null;
                    }
                }
            }
            return lastInfo != null;
        }

        public String toString() {
            return "LaterInvocator.FlushQueue" + (this.myLastInfo == null ? "" : " lastInfo=" + this.myLastInfo);
        }
    }

    private static class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        @NotNull
        private final ActionCallback callback;

        RunnableInfo(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @NotNull ActionCallback callback) {
            this.runnable = runnable2;
            this.modalityState = modalityState;
            this.expired = expired;
            this.callback = callback;
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "] ";
        }
    }
}

