/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.WeakList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UndoRedoStacksHolder {
    private final Key<LinkedList<UndoableGroup>> STACK_IN_DOCUMENT_KEY = Key.create((String)"STACK_IN_DOCUMENT_KEY");
    private final boolean myUndo;
    private final LinkedList<UndoableGroup> myGlobalStack = new LinkedList();
    private final Map<DocumentReference, LinkedList<UndoableGroup>> myDocumentStacks = new HashMap();
    private final List<Document> myDocumentsWithStacks = new WeakList();
    private final List<VirtualFile> myNonlocalVirtualFilesWithStacks = new WeakList();

    public UndoRedoStacksHolder(boolean isUndo) {
        this.myUndo = isUndo;
    }

    @NotNull
    LinkedList<UndoableGroup> getStack(@NotNull DocumentReference r) {
        return r.getFile() != null ? this.doGetStackForFile(r) : this.doGetStackForDocument(r);
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForFile(@NotNull DocumentReference r) {
        LinkedList<UndoableGroup> result2;
        VirtualFile file2 = r.getFile();
        if (!file2.isInLocalFileSystem()) {
            result2 = this.addWeaklyTrackedEmptyStack(file2, this.myNonlocalVirtualFilesWithStacks);
        } else {
            result2 = this.myDocumentStacks.get(r);
            if (result2 == null) {
                result2 = new LinkedList();
                this.myDocumentStacks.put(r, result2);
            }
        }
        return result2;
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForDocument(@NotNull DocumentReference r) {
        return this.addWeaklyTrackedEmptyStack(r.getDocument(), this.myDocumentsWithStacks);
    }

    @NotNull
    private <T extends UserDataHolder> LinkedList<UndoableGroup> addWeaklyTrackedEmptyStack(@NotNull T holder, @NotNull List<T> allHolders) {
        LinkedList result2 = (LinkedList)holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
        if (result2 == null) {
            result2 = new LinkedList();
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, result2);
            allHolders.add(holder);
        }
        return result2;
    }

    boolean canBeUndoneOrRedone(@NotNull Collection<DocumentReference> refs) {
        if (refs.isEmpty()) {
            return !this.myGlobalStack.isEmpty() && this.myGlobalStack.getLast().isValid();
        }
        for (DocumentReference each : refs) {
            if (this.getStack(each).isEmpty() || !this.getStack(each).getLast().isValid()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    UndoableGroup getLastAction(@NotNull Collection<DocumentReference> refs) {
        if (refs.isEmpty()) {
            return this.myGlobalStack.getLast();
        }
        UndoableGroup mostRecentAction = null;
        int mostRecentDocTimestamp = this.myUndo ? -1 : Integer.MAX_VALUE;
        for (DocumentReference each : refs) {
            LinkedList<UndoableGroup> stack = this.getStack(each);
            if (stack.isEmpty()) continue;
            UndoableGroup lastAction = stack.getLast();
            int timestamp = lastAction.getCommandTimestamp();
            if (!(this.myUndo ? timestamp > mostRecentDocTimestamp : timestamp < mostRecentDocTimestamp)) continue;
            mostRecentAction = lastAction;
            mostRecentDocTimestamp = timestamp;
        }
        return mostRecentAction;
    }

    @NotNull
    Set<DocumentReference> collectClashingActions(@NotNull UndoableGroup group) {
        UndoableGroup last;
        THashSet result2 = new THashSet();
        for (DocumentReference each : group.getAffectedDocuments()) {
            UndoableGroup last2 = this.getStack(each).getLast();
            if (last2 == group) continue;
            result2.addAll(last2.getAffectedDocuments());
        }
        if (group.isGlobal() && (last = this.myGlobalStack.getLast()) != group) {
            result2.addAll(last.getAffectedDocuments());
        }
        return result2;
    }

    void addToStacks(@NotNull UndoableGroup group) {
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            this.doAddToStack(each, group, each == this.myGlobalStack ? UndoManagerImpl.getGlobalUndoLimit() : UndoManagerImpl.getDocumentUndoLimit());
        }
    }

    private void doAddToStack(@NotNull LinkedList<UndoableGroup> stack, @NotNull UndoableGroup group, int limit) {
        if (!group.isUndoable() && stack.isEmpty()) {
            return;
        }
        stack.add(group);
        while (stack.size() > limit) {
            this.clearStacksFrom(stack.getFirst());
        }
    }

    void removeFromStacks(@NotNull UndoableGroup group) {
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            assert (each.getLast() == group);
            each.removeLast();
        }
    }

    void clearStacks(boolean clearGlobal, @NotNull Set<DocumentReference> refs) {
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(clearGlobal, refs)) {
            while (!each.isEmpty()) {
                this.clearStacksFrom(each.getLast());
            }
        }
        THashSet stacksToDrop = new THashSet();
        for (Map.Entry<DocumentReference, LinkedList<UndoableGroup>> entry : this.myDocumentStacks.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            stacksToDrop.add(entry.getKey());
        }
        for (DocumentReference documentReference : stacksToDrop) {
            this.myDocumentStacks.remove(documentReference);
        }
        this.cleanWeaklyTrackedEmptyStacks(this.myDocumentsWithStacks);
        this.cleanWeaklyTrackedEmptyStacks(this.myNonlocalVirtualFilesWithStacks);
    }

    private <T extends UserDataHolder> void cleanWeaklyTrackedEmptyStacks(@NotNull List<T> stackHolders) {
        THashSet holdersToDrop = new THashSet();
        for (UserDataHolder holder : stackHolders) {
            List stack = (List)holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
            if (stack == null || !stack.isEmpty()) continue;
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, null);
            holdersToDrop.add(holder);
        }
        stackHolders.removeAll((Collection<?>)holdersToDrop);
    }

    private void clearStacksFrom(@NotNull UndoableGroup from) {
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(from)) {
            int pos = each.indexOf(from);
            if (pos == -1) continue;
            if (pos > 0) {
                int top = each.size() - pos;
                this.clearStacksFrom(each.get(pos - 1));
                assert (each.size() == top && each.indexOf(from) == 0);
            }
            each.removeFirst();
        }
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(@NotNull UndoableGroup group) {
        return this.getAffectedStacks(group.isGlobal(), group.getAffectedDocuments());
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(boolean global, @NotNull Collection<DocumentReference> refs) {
        ArrayList<LinkedList<UndoableGroup>> result2 = new ArrayList<LinkedList<UndoableGroup>>(refs.size() + 1);
        if (global) {
            result2.add(this.myGlobalStack);
        }
        for (DocumentReference each : refs) {
            result2.add(this.getStack(each));
        }
        return result2;
    }

    void clearAllStacksInTests() {
        this.clearStacks(true, this.getAffectedDocuments());
        this.myGlobalStack.clear();
        this.myDocumentStacks.clear();
        this.myDocumentsWithStacks.clear();
        this.myNonlocalVirtualFilesWithStacks.clear();
    }

    void collectAllAffectedDocuments(@NotNull Collection<DocumentReference> result2) {
        for (UndoableGroup each : this.myGlobalStack) {
            result2.addAll(each.getAffectedDocuments());
        }
        this.collectLocalAffectedDocuments(result2);
    }

    private void collectLocalAffectedDocuments(@NotNull Collection<DocumentReference> result2) {
        result2.addAll(this.myDocumentStacks.keySet());
        DocumentReferenceManager documentReferenceManager = DocumentReferenceManager.getInstance();
        for (Document document : this.myDocumentsWithStacks) {
            result2.add(documentReferenceManager.create(document));
        }
        for (VirtualFile virtualFile : this.myNonlocalVirtualFilesWithStacks) {
            result2.add(documentReferenceManager.create(virtualFile));
        }
    }

    @NotNull
    private Set<DocumentReference> getAffectedDocuments() {
        THashSet result2 = new THashSet();
        this.collectAllAffectedDocuments((Collection<DocumentReference>)result2);
        return result2;
    }

    int getLastCommandTimestamp(@NotNull DocumentReference r) {
        LinkedList<UndoableGroup> stack = this.getStack(r);
        if (stack.isEmpty()) {
            return 0;
        }
        return Math.max(stack.getFirst().getCommandTimestamp(), stack.getLast().getCommandTimestamp());
    }

    void invalidateActionsFor(@NotNull DocumentReference ref) {
        for (List list : this.getAffectedStacks(true, Collections.singleton(ref))) {
            for (UndoableGroup eachGroup : list) {
                eachGroup.invalidateActionsFor(ref);
            }
        }
    }
}

