/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.generic;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VirtualFileSetState {
    public static final DataExternalizer<VirtualFileSetState> EXTERNALIZER = new VirtualFileWithDependenciesExternalizer();
    private Map<String, Long> myTimestamps = new HashMap<String, Long>();

    public VirtualFileSetState() {
    }

    public VirtualFileSetState(Collection<? extends VirtualFile> files) {
        for (VirtualFile virtualFile : files) {
            this.addFile(virtualFile);
        }
    }

    public void addFile(@NotNull VirtualFile file2) {
        this.myTimestamps.put(file2.getUrl(), file2.getTimeStamp());
    }

    public boolean isUpToDate(Set<? extends VirtualFile> files) {
        if (files.size() != this.myTimestamps.size()) {
            return false;
        }
        for (VirtualFile virtualFile : files) {
            Long timestamp = this.myTimestamps.get(virtualFile.getUrl());
            if (timestamp != null && timestamp.longValue() == virtualFile.getTimeStamp()) continue;
            return false;
        }
        return true;
    }

    private static class VirtualFileWithDependenciesExternalizer
    implements DataExternalizer<VirtualFileSetState> {
        private VirtualFileWithDependenciesExternalizer() {
        }

        public void save(@NotNull DataOutput out, VirtualFileSetState value2) throws IOException {
            Map dependencies = value2.myTimestamps;
            out.writeInt(dependencies.size());
            for (Map.Entry entry : dependencies.entrySet()) {
                IOUtil.writeUTF((DataOutput)out, (String)((String)entry.getKey()));
                out.writeLong((Long)entry.getValue());
            }
        }

        public VirtualFileSetState read(@NotNull DataInput in) throws IOException {
            VirtualFileSetState state = new VirtualFileSetState();
            int size = in.readInt();
            while (size-- > 0) {
                String url = IOUtil.readUTF((DataInput)in);
                long timestamp = in.readLong();
                state.myTimestamps.put(url, timestamp);
            }
            return state;
        }
    }
}

