/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationStarterBase
extends ApplicationStarterEx {
    private final String myCommandName;
    private final int[] myArgsCount;

    protected ApplicationStarterBase(String commandName, int ... possibleArgumentsCount) {
        this.myCommandName = commandName;
        this.myArgsCount = possibleArgumentsCount;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public boolean isHeadless() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExternalCommandLine(String[] args, @Nullable String currentDirectory) {
        if (!this.checkArguments(args)) {
            Messages.showMessageDialog((String)this.getUsageMessage(), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getInformationIcon());
            return;
        }
        try {
            this.processCommand(args, currentDirectory);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)String.format("Error showing %s: %s", this.getCommandName(), e.getMessage()), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getErrorIcon());
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
    }

    private static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    private boolean checkArguments(String[] args) {
        return Arrays.binarySearch(this.myArgsCount, args.length - 1) != -1 && this.getCommandName().equals(args[0]);
    }

    public abstract String getUsageMessage();

    protected abstract void processCommand(String[] var1, @Nullable String var2) throws Exception;

    public void premain(String[] args) {
        if (!this.checkArguments(args)) {
            System.err.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    public void main(String[] args) {
        try {
            this.processCommand(args, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(2);
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
        System.exit(0);
    }

    public static VirtualFile findOrCreateFile(String path, @Nullable String currentDirectory) throws IOException {
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path));
        if (file2 == null) {
            boolean result2 = new File(path).createNewFile();
            if (result2) {
                return ApplicationStarterBase.findFile(path, currentDirectory);
            }
            throw new FileNotFoundException("Can't create file " + path);
        }
        return file2;
    }

    public static String getText(VirtualFile file2) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file2.getPath());){
            String string = StreamUtil.readText((InputStream)inputStream);
            return string;
        }
    }

    @NotNull
    public static VirtualFile findFile(String path, @Nullable String currentDirectory) throws OperationFailedException {
        VirtualFile file2;
        File ioFile = new File(path);
        if (!ioFile.isAbsolute() && currentDirectory != null) {
            ioFile = new File(currentDirectory, path);
        }
        if ((file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile)) == null) {
            throw new OperationFailedException("Can't find file " + path);
        }
        return file2;
    }

    public boolean canProcessExternalCommandLine() {
        return true;
    }

    public static class OperationFailedException
    extends IOException {
        public OperationFailedException(@NotNull String message2) {
            super(message2);
        }
    }
}

