/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.actions.DiffPanelComboBoxAction;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.impl.processing.HighlightMode;
import org.jetbrains.annotations.NotNull;

public class HighlightModeAction
extends DiffPanelComboBoxAction<HighlightMode> {
    private static final HighlightMode[] ourActionOrder = new HighlightMode[]{HighlightMode.BY_WORD, HighlightMode.BY_LINE, HighlightMode.NO_HIGHLIGHTING};

    public HighlightModeAction() {
        super(ourActionOrder);
        this.addAction(HighlightMode.BY_WORD, (AnAction)new HighlightingModeAction(DiffBundle.message((String)"diff.acton.highlight.mode.action.by.word", (Object[])new Object[0]), HighlightMode.BY_WORD));
        this.addAction(HighlightMode.BY_LINE, (AnAction)new HighlightingModeAction(DiffBundle.message((String)"diff.acton.highlight.mode.action.by.line", (Object[])new Object[0]), HighlightMode.BY_LINE));
        this.addAction(HighlightMode.NO_HIGHLIGHTING, (AnAction)new HighlightingModeAction(DiffBundle.message((String)"diff.acton.highlight.mode.action.no.highlighting", (Object[])new Object[0]), HighlightMode.NO_HIGHLIGHTING));
    }

    @Override
    @NotNull
    protected String getActionName() {
        return DiffBundle.message((String)"diff.acton.highlight.mode.action.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected HighlightMode getCurrentOption(@NotNull DiffPanelEx diffPanel) {
        return diffPanel.getHighlightMode();
    }

    private static class HighlightingModeAction
    extends DiffPanelComboBoxAction.DiffPanelAction {
        private final HighlightMode myHighlightMode;

        public HighlightingModeAction(String text, HighlightMode highlightMode) {
            super(text);
            this.myHighlightMode = highlightMode;
        }

        @Override
        protected void perform(@NotNull DiffPanelEx diffPanel) {
            diffPanel.setHighlightMode(this.myHighlightMode);
        }
    }
}

