/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeFragment;
import com.intellij.openapi.diff.impl.util.ContextLogger;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MergeBuilder {
    @NotNull
    private final ContextLogger LOG;
    @NotNull
    private final ArrayList<MergeFragment> myResult = new ArrayList();
    @NotNull
    private final int[] myProcessed = new int[]{0, 0, 0};
    @NotNull
    private final EqualPair[] myPairs = new EqualPair[2];

    public MergeBuilder(@NotNull ContextLogger log) {
        this.LOG = log;
    }

    public void add(@NotNull TextRange base, @NotNull TextRange version, @NotNull FragmentSide side) {
        int index = side.getIndex();
        int otherIndex = side.otherSide().getIndex();
        EqualPair pair = new EqualPair(base, version, side);
        this.LOG.assertTrue(this.myPairs[index] == null || pair.getBaseStart() - this.myPairs[index].getBaseEnd() >= 0);
        this.LOG.assertTrue(this.myPairs[otherIndex] == null || pair.getBaseStart() >= this.myPairs[otherIndex].getBaseStart());
        this.myPairs[index] = pair;
        if (this.myPairs[otherIndex] != null && this.myPairs[index].getBaseStart() >= this.myPairs[otherIndex].getBaseEnd()) {
            this.myPairs[otherIndex] = null;
        }
        this.process();
    }

    @NotNull
    public List<MergeFragment> finish(int leftLength, int baseLength, int rightLength) {
        if (!MergeBuilder.compare(new int[]{leftLength, rightLength, baseLength}, this.myProcessed)) {
            this.processConflict(leftLength, baseLength, rightLength);
        }
        return this.myResult;
    }

    private void process() {
        while (this.myPairs[0] != null && this.myPairs[1] != null) {
            if (this.myPairs[0].startsFrom(this.myProcessed) && this.myPairs[1].startsFrom(this.myProcessed)) {
                int len = Math.min(this.myPairs[0].getLength(), this.myPairs[1].getLength());
                if (!this.myPairs[0].cutHead(len)) {
                    this.myPairs[0] = null;
                }
                if (!this.myPairs[1].cutHead(len)) {
                    this.myPairs[1] = null;
                }
                this.myProcessed[0] = this.myProcessed[0] + len;
                this.myProcessed[1] = this.myProcessed[1] + len;
                this.myProcessed[2] = this.myProcessed[2] + len;
                continue;
            }
            int nextBase = Math.max(this.myPairs[0].getBaseStart(), this.myPairs[1].getBaseStart());
            int[] nextVersion = new int[]{nextBase - this.myPairs[0].getBaseStart() + this.myPairs[0].getVersionStart(), nextBase - this.myPairs[1].getBaseStart() + this.myPairs[1].getVersionStart()};
            this.processConflict(nextVersion[0], nextBase, nextVersion[1]);
            if (!this.myPairs[0].cutHead(nextBase - this.myPairs[0].getBaseStart())) {
                this.myPairs[0] = null;
            }
            if (this.myPairs[1].cutHead(nextBase - this.myPairs[1].getBaseStart())) continue;
            this.myPairs[1] = null;
        }
    }

    private void processConflict(int nextLeft, int nextBase, int nextRight) {
        this.addConflict(new TextRange(this.myProcessed[0], nextLeft), new TextRange(this.myProcessed[2], nextBase), new TextRange(this.myProcessed[1], nextRight));
        this.myProcessed[0] = nextLeft;
        this.myProcessed[1] = nextRight;
        this.myProcessed[2] = nextBase;
    }

    private void addConflict(@NotNull TextRange left, @NotNull TextRange base, @NotNull TextRange right) {
        this.myResult.add(new MergeFragment(left, base, right));
    }

    private static boolean compare(@NotNull int[] lengths, @NotNull int[] processed2) {
        for (int i2 = 0; i2 < lengths.length; ++i2) {
            if (lengths[i2] == processed2[i2]) continue;
            return false;
        }
        return true;
    }

    private class EqualPair {
        private int myBaseStart;
        private int myVersionStart;
        private int myLength;
        private final FragmentSide mySide;

        public EqualPair(@NotNull TextRange base, @NotNull TextRange version, FragmentSide side) {
            MergeBuilder.this.LOG.assertTrue(base.getLength() == version.getLength());
            MergeBuilder.this.LOG.assertTrue(base.getLength() > 0);
            this.myBaseStart = base.getStartOffset();
            this.myVersionStart = version.getStartOffset();
            this.myLength = base.getLength();
            this.mySide = side;
        }

        public int getBaseStart() {
            return this.myBaseStart;
        }

        public int getVersionStart() {
            return this.myVersionStart;
        }

        public int getLength() {
            return this.myLength;
        }

        public int getBaseEnd() {
            return this.myBaseStart + this.myLength;
        }

        @NotNull
        public FragmentSide getSide() {
            return this.mySide;
        }

        public int getIndex() {
            return this.mySide.getIndex();
        }

        public boolean startsFrom(int[] bound) {
            return this.versionStartsFrom(bound) && this.baseStartFrom(bound);
        }

        public boolean versionStartsFrom(int[] bound) {
            return this.myVersionStart == bound[this.mySide.getIndex()];
        }

        public boolean baseStartFrom(int[] bound) {
            return this.myBaseStart == bound[2];
        }

        public boolean cutHead(int delta) {
            MergeBuilder.this.LOG.assertTrue(this.myLength >= delta);
            MergeBuilder.this.LOG.assertTrue(delta >= 0);
            this.myBaseStart += delta;
            this.myVersionStart += delta;
            this.myLength -= delta;
            return this.myLength > 0;
        }
    }
}

