/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

class SimpleChange
extends Change
implements DiffRangeMarker.RangeInvalidListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.Change");
    private ChangeType myType;
    private final Change.SimpleChangeSide[] mySides;
    private final ChangeList myChangeList;

    SimpleChange(@NotNull ChangeType type2, @NotNull TextRange range1, @NotNull TextRange range2, @NotNull ChangeList changeList) {
        this.mySides = new Change.SimpleChangeSide[]{this.createSide(changeList, range1, FragmentSide.SIDE1), this.createSide(changeList, range2, FragmentSide.SIDE2)};
        this.myType = type2;
        this.myChangeList = changeList;
    }

    @NotNull
    private Change.SimpleChangeSide createSide(@NotNull ChangeList changeList, @NotNull TextRange range1, @NotNull FragmentSide side) {
        return new Change.SimpleChangeSide(side, new DiffRangeMarker(changeList.getDocument(side), range1, this));
    }

    @Override
    protected void changeSide(@NotNull ChangeSide sideToChange, @NotNull DiffRangeMarker newRange) {
        for (int i2 = 0; i2 < this.mySides.length; ++i2) {
            Change.SimpleChangeSide side = this.mySides[i2];
            if (!side.equals(sideToChange)) continue;
            this.mySides[i2] = new Change.SimpleChangeSide(sideToChange, newRange);
            break;
        }
    }

    @Override
    protected void removeFromList() {
        this.myChangeList.remove(this);
    }

    @Override
    @NotNull
    public ChangeSide getChangeSide(@NotNull FragmentSide side) {
        return this.mySides[side.getIndex()];
    }

    @Override
    public ChangeType getType() {
        return this.myType;
    }

    @Override
    public ChangeList getChangeList() {
        return this.myChangeList;
    }

    @Override
    public void onApplied() {
        this.myType = ChangeType.deriveApplied(this.myType);
        for (Change.SimpleChangeSide side : this.mySides) {
            ChangeHighlighterHolder highlighterHolder = side.getHighlighterHolder();
            highlighterHolder.setActions(AnAction.EMPTY_ARRAY);
            highlighterHolder.updateHighlighter(side, this.myType);
        }
        this.myChangeList.apply(this);
    }

    @Override
    public void onRemovedFromList() {
        for (int i2 = 0; i2 < this.mySides.length; ++i2) {
            Change.SimpleChangeSide side = this.mySides[i2];
            side.getRange().removeListener(this);
            side.getHighlighterHolder().removeHighlighters();
            this.mySides[i2] = null;
        }
    }

    @Override
    public boolean isValid() {
        LOG.assertTrue(this.mySides[0] == null == (this.mySides[1] == null));
        return this.mySides[0] != null;
    }

    @Override
    public void onRangeInvalidated() {
        this.myChangeList.remove(this);
    }

    static Change fromRanges(@NotNull TextRange baseRange, @NotNull TextRange versionRange, @NotNull ChangeList changeList) {
        ChangeType type2 = ChangeType.fromRanges(baseRange, versionRange);
        return new SimpleChange(type2, baseRange, versionRange, changeList);
    }
}

