/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.diff.util.TextDiffTypeFactory;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diff.impl.settings.DiffColorDescriptionPanel;
import com.intellij.openapi.diff.impl.settings.DiffPreviewPanel;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiffColorsPageFactory
implements ColorAndFontPanelFactory,
ColorAndFontDescriptorsProvider,
DisplayPrioritySortable {
    public static final String DIFF_GROUP = ApplicationBundle.message((String)"title.diff", (Object[])new Object[0]);

    @Override
    @NotNull
    public NewColorAndFontPanel createPanel(final @NotNull ColorAndFontOptions options) {
        SchemesPanel schemesPanel = new SchemesPanel(options);
        DiffColorDescriptionPanel descriptionPanel = new DiffColorDescriptionPanel(options);
        final OptionsPanelImpl optionsPanel = new OptionsPanelImpl(options, schemesPanel, DIFF_GROUP, descriptionPanel);
        final DiffPreviewPanel previewPanel = new DiffPreviewPanel();
        schemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void schemeChanged(Object source) {
                previewPanel.setColorScheme(options.getSelectedScheme());
                optionsPanel.updateOptionsList();
            }
        });
        return new NewColorAndFontPanel(schemesPanel, optionsPanel, previewPanel, DIFF_GROUP, null, null);
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        Object[] diffTypes = TextDiffTypeFactory.getInstance().getAllDiffTypes();
        List attributes = ContainerUtil.map((Object[])diffTypes, type2 -> new AttributesDescriptor(type2.getName(), type2.getKey()));
        return (AttributesDescriptor[])ArrayUtil.toObjectArray((Collection)attributes, AttributesDescriptor.class);
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String getPanelDisplayName() {
        return DIFF_GROUP;
    }

    @NotNull
    public String getDisplayName() {
        return DIFF_GROUP;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.COMMON_SETTINGS;
    }
}

