/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import org.jetbrains.annotations.NotNull;

public enum DiffMergeEditorSetting {
    WHITESPACES(false){

        @Override
        public void apply(@NotNull Editor editor, boolean state) {
            editor.getSettings().setWhitespacesShown(state);
            editor.getComponent().repaint();
        }
    }
    ,
    LINE_NUMBERS(false){

        @Override
        public void apply(@NotNull Editor editor, boolean state) {
            editor.getSettings().setLineNumbersShown(state);
            editor.getComponent().repaint();
        }
    }
    ,
    INDENT_LINES(false){

        @Override
        public void apply(@NotNull Editor editor, boolean state) {
            editor.getSettings().setIndentGuidesShown(state);
            editor.getComponent().repaint();
        }
    }
    ,
    SOFT_WRAPS(false){

        @Override
        public void apply(@NotNull Editor editor, boolean state) {
            editor.getSettings().setUseSoftWraps(state);
            if (editor instanceof EditorEx) {
                ((EditorEx)editor).reinitSettings();
            }
        }
    };

    private final boolean myDefault;

    private DiffMergeEditorSetting(boolean aDefault) {
        this.myDefault = aDefault;
    }

    public abstract void apply(@NotNull Editor var1, boolean var2);

    public boolean getDefault() {
        return this.myDefault;
    }
}

