/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffTypeFactory;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.impl.settings.DiffPreviewProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.EventListener;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffPreviewPanel
implements PreviewPanel {
    private final JPanel myPanel;
    private final SimpleThreesideDiffViewer myViewer;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public DiffPreviewPanel() {
        this.myViewer = new SimpleThreesideDiffViewer(new SampleContext(), (DiffRequest)new SampleRequest()){

            @Override
            protected boolean forceRediffSynchronously() {
                return true;
            }
        };
        this.myViewer.init();
        for (ThreeSide side : ThreeSide.values()) {
            EditorMouseListener motionListener = new EditorMouseListener(side);
            EditorClickListener clickListener = new EditorClickListener(side);
            EditorEx editor = this.myViewer.getEditor(side);
            editor.addEditorMouseMotionListener((EditorMouseMotionListener)motionListener);
            editor.addEditorMouseListener((com.intellij.openapi.editor.event.EditorMouseListener)clickListener);
            editor.getCaretModel().addCaretListener((CaretListener)clickListener);
        }
        this.myPanel = JBUI.Panels.simplePanel((Component)this.myViewer.getComponent()).withBorder(IdeBorderFactory.createBorder());
    }

    @Override
    public Component getPanel() {
        return this.myPanel;
    }

    @Override
    public void updateView() {
        List<SimpleThreesideDiffChange> changes = this.myViewer.getChanges();
        for (SimpleThreesideDiffChange change : changes) {
            change.reinstallHighlighters();
        }
    }

    public void setColorScheme(EditorColorsScheme highlighterSettings) {
        for (EditorEx editorEx : this.myViewer.getEditors()) {
            editorEx.setColorsScheme(highlighterSettings);
        }
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private void selectChange(@Nullable SimpleThreesideDiffChange change) {
        if (change == null) {
            return;
        }
        TextDiffTypeFactory.TextDiffTypeImpl diffType = (TextDiffTypeFactory.TextDiffTypeImpl)ObjectUtils.tryCast((Object)change.getDiffType(), TextDiffTypeFactory.TextDiffTypeImpl.class);
        if (diffType != null) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(diffType.getKey().getExternalName());
        }
    }

    @Nullable
    private SimpleThreesideDiffChange getChange(ThreeSide side, EditorMouseEvent e) {
        EditorEx editor = this.myViewer.getEditor(side);
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
        int offset = editor.logicalPositionToOffset(logicalPosition);
        int line = editor.getDocument().getLineNumber(offset);
        return this.getChange(side, line);
    }

    @Nullable
    private SimpleThreesideDiffChange getChange(ThreeSide side, int line) {
        for (SimpleThreesideDiffChange change : this.myViewer.getChanges()) {
            int endLine;
            int startLine = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(line, startLine, endLine = change.getEndLine(side))) continue;
            return change;
        }
        return null;
    }

    @Override
    public void blinkSelectedHighlightType(Object selected) {
    }

    @Override
    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @NotNull
    public SimpleThreesideDiffViewer testGetViewer() {
        return this.myViewer;
    }

    private class EditorClickListener
    extends EditorMouseAdapter
    implements CaretListener {
        @NotNull
        private final ThreeSide mySide;

        private EditorClickListener(ThreeSide side) {
            this.mySide = side;
        }

        public void mouseClicked(EditorMouseEvent e) {
            DiffPreviewPanel.this.selectChange(DiffPreviewPanel.this.getChange(this.mySide, e));
        }

        public void caretPositionChanged(CaretEvent e) {
            DiffPreviewPanel.this.selectChange(DiffPreviewPanel.this.getChange(this.mySide, e.getNewPosition().line));
        }

        public void caretAdded(CaretEvent e) {
        }

        public void caretRemoved(CaretEvent e) {
        }
    }

    private class EditorMouseListener
    extends EditorMouseMotionAdapter {
        @NotNull
        private final ThreeSide mySide;

        private EditorMouseListener(ThreeSide side) {
            this.mySide = side;
        }

        public void mouseMoved(EditorMouseEvent e) {
            if (DiffPreviewPanel.this.getChange(this.mySide, e) != null) {
                EditorUtil.setHandCursor(e.getEditor());
            }
        }
    }

    private static class SampleContext
    extends DiffContext {
        public SampleContext() {
            TextDiffSettingsHolder.TextDiffSettings settings = new TextDiffSettingsHolder.TextDiffSettings();
            settings.setHighlightPolicy(HighlightPolicy.BY_WORD);
            settings.setIgnorePolicy(IgnorePolicy.IGNORE_WHITESPACES);
            this.putUserData(TextDiffSettingsHolder.TextDiffSettings.KEY, settings);
        }

        @Nullable
        public Project getProject() {
            return null;
        }

        public boolean isWindowFocused() {
            return false;
        }

        public boolean isFocused() {
            return false;
        }

        public void requestFocus() {
        }
    }

    private static class SampleRequest
    extends ContentDiffRequest {
        private final List<com.intellij.diff.contents.DiffContent> myContents;

        public SampleRequest() {
            DiffContent[] contents = DiffPreviewProvider.getContents();
            this.myContents = ContainerUtil.list((Object[])new com.intellij.diff.contents.DiffContent[]{SampleRequest.convert(contents[0]), SampleRequest.convert(contents[1]), SampleRequest.convert(contents[2])});
        }

        private static com.intellij.diff.contents.DiffContent convert(@NotNull DiffContent content) {
            Document document = content.getDocument();
            FileType fileType = content.getContentType();
            return DiffContentFactory.getInstance().create(null, document, fileType);
        }

        @NotNull
        public List<com.intellij.diff.contents.DiffContent> getContents() {
            return this.myContents;
        }

        @NotNull
        public List<String> getContentTitles() {
            return ContainerUtil.list((Object[])new String[]{null, null, null});
        }

        @Nullable
        public String getTitle() {
            return DiffBundle.message((String)"merge.color.options.dialog.title", (Object[])new Object[0]);
        }
    }
}

