/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretStateTransferableData
implements TextBlockTransferableData {
    private static final Logger LOG = Logger.getInstance(CaretStateTransferableData.class);
    public static final DataFlavor FLAVOR = new DataFlavor(CaretStateTransferableData.class, "Caret state");
    public final int[] startOffsets;
    public final int[] endOffsets;

    public CaretStateTransferableData(@NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        this.startOffsets = startOffsets;
        this.endOffsets = endOffsets;
    }

    @Override
    public DataFlavor getFlavor() {
        return FLAVOR;
    }

    @Override
    public int getOffsetCount() {
        return this.startOffsets.length + this.endOffsets.length;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        System.arraycopy(this.startOffsets, 0, offsets, index, this.startOffsets.length);
        System.arraycopy(this.endOffsets, 0, offsets, index + this.startOffsets.length, this.endOffsets.length);
        return index + this.getOffsetCount();
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        System.arraycopy(offsets, index, this.startOffsets, 0, this.startOffsets.length);
        System.arraycopy(offsets, index + this.startOffsets.length, this.endOffsets, 0, this.endOffsets.length);
        return index + this.getOffsetCount();
    }

    public int getCaretCount() {
        return this.startOffsets.length;
    }

    @Nullable
    public static CaretStateTransferableData getFrom(Transferable t) {
        try {
            return t.isDataFlavorSupported(FLAVOR) ? (CaretStateTransferableData)t.getTransferData(FLAVOR) : null;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static boolean areEquivalent(@Nullable CaretStateTransferableData d1, @Nullable CaretStateTransferableData d2) {
        return (d1 == null || d1.getCaretCount() == 1) && (d2 == null || d2.getCaretCount() == 1) || d1 != null && d2 != null && Arrays.equals(d1.startOffsets, d2.startOffsets) && Arrays.equals(d1.endOffsets, d2.endOffsets);
    }
}

