/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CaretStateTransferableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClipboardTextPerCaretSplitter {
    @NotNull
    public List<String> split(@NotNull String input, @Nullable CaretStateTransferableData caretData, int caretCount) {
        if (caretCount <= 0) {
            throw new IllegalArgumentException("Caret count must be positive");
        }
        if (caretCount == 1) {
            return Collections.singletonList(input);
        }
        ArrayList<String> result2 = new ArrayList<String>(caretCount);
        if (caretData == null) {
            String[] lines = input.split("\n", -1);
            int sourceCaretCount = lines.length == 2 && lines[1].isEmpty() ? 1 : lines.length;
            for (int i2 = 0; i2 < caretCount; ++i2) {
                if (sourceCaretCount == 1) {
                    result2.add(lines[0]);
                    continue;
                }
                result2.add(i2 < lines.length ? lines[i2] : "");
            }
        } else {
            int sourceCaretCount = caretData.startOffsets.length;
            for (int i3 = 0; i3 < caretCount; ++i3) {
                if (sourceCaretCount == 1) {
                    result2.add(input);
                    continue;
                }
                result2.add(i3 < sourceCaretCount ? new String(input.substring(caretData.startOffsets[i3], caretData.endOffsets[i3])) : "");
            }
        }
        return result2;
    }
}

