/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterAction
extends EditorAction {
    public EnterAction() {
        super((EditorActionHandler)new Handler());
        this.setInjectedContext(true);
    }

    public static void insertNewLineAtCaret(Editor editor) {
        int indentLineNum;
        EditorUIUtil.hideCursorInEditor(editor);
        Document document = editor.getDocument();
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        if (!editor.isInsertMode()) {
            int lineCount = document.getLineCount();
            if (caretLine < lineCount) {
                if (caretLine == lineCount - 1) {
                    document.insertString(document.getTextLength(), (CharSequence)"\n");
                }
                LogicalPosition pos = new LogicalPosition(caretLine + 1, 0);
                editor.getCaretModel().moveToLogicalPosition(pos);
                editor.getSelectionModel().removeSelection();
                EditorModificationUtil.scrollToCaret((Editor)editor);
            }
            return;
        }
        EditorModificationUtil.deleteSelectedText((Editor)editor);
        CharSequence text = document.getCharsSequence();
        int lineLength = 0;
        if (document.getLineCount() > 0) {
            for (indentLineNum = caretLine; indentLineNum >= 0 && (lineLength = document.getLineEndOffset(indentLineNum) - document.getLineStartOffset(indentLineNum)) <= 0; --indentLineNum) {
            }
        } else {
            indentLineNum = -1;
        }
        int colNumber = editor.getCaretModel().getLogicalPosition().column;
        StringBuilder buf = new StringBuilder();
        if (indentLineNum >= 0) {
            char c;
            int lineStartOffset = document.getLineStartOffset(indentLineNum);
            for (int i2 = 0; i2 < lineLength && ((c = text.charAt(lineStartOffset + i2)) == ' ' || c == '\t') && i2 < colNumber; ++i2) {
                buf.append(c);
            }
        }
        int caretOffset = editor.getCaretModel().getOffset();
        String s = "\n" + buf;
        document.insertString(caretOffset, (CharSequence)s);
        editor.getCaretModel().moveToOffset(caretOffset + s.length());
        EditorModificationUtil.scrollToCaret((Editor)editor);
        editor.getSelectionModel().removeSelection();
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.command.name", (Object[])new Object[0]));
            EnterAction.insertNewLineAtCaret(editor);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            return !editor.isOneLineMode();
        }
    }
}

