/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoveBomAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)("#" + RemoveBomAction.class));

    public RemoveBomAction() {
        super("Remove BOM");
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        if (files == null) {
            return;
        }
        List<VirtualFile> filesToProcess = RemoveBomAction.getFilesWithBom(files, true);
        for (VirtualFile virtualFile : filesToProcess) {
            byte[] bom = virtualFile.getBOM();
            assert (bom != null);
            if (!(virtualFile instanceof NewVirtualFile)) continue;
            virtualFile.setBOM(null);
            NewVirtualFile file2 = (NewVirtualFile)virtualFile;
            try {
                byte[] bytes = file2.contentsToByteArray();
                byte[] contentWithStrippedBom = new byte[bytes.length - bom.length];
                System.arraycopy(bytes, bom.length, contentWithStrippedBom, 0, contentWithStrippedBom.length);
                WriteAction.run(() -> file2.setBinaryContent(contentWithStrippedBom));
            }
            catch (IOException ex) {
                LOG.warn("Unexpected exception occurred on attempt to remove BOM from file " + file2, (Throwable)ex);
            }
        }
    }

    public void update(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        if (files == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (VirtualFile file2 : files) {
            if (file2.isDirectory()) {
                enabled = true;
                break;
            }
            if (file2.getBOM() == null) continue;
            enabled = true;
            break;
        }
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    private static List<VirtualFile> getFilesWithBom(@NotNull VirtualFile[] roots, boolean all) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            if (!all && !result2.isEmpty()) break;
            RemoveBomAction.getFilesWithBom(root, result2, all);
        }
        return result2;
    }

    private static void getFilesWithBom(@NotNull VirtualFile root, final @NotNull List<VirtualFile> result2, final boolean all) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2.isDirectory()) {
                    if (!all && !result2.isEmpty()) {
                        return false;
                    }
                } else if (file2.getBOM() != null) {
                    result2.add(file2);
                }
                return true;
            }
        });
    }
}

