/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.StringEscapesTokenTypes;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class ToggleCaseAction
extends TextComponentEditorAction {
    public ToggleCaseAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(final Editor editor, @Nullable Caret caret, DataContext dataContext) {
            final Ref toLowerCase = new Ref((Object)Boolean.FALSE);
            Handler.runForCaret(editor, caret, new CaretAction(){

                public void perform(Caret caret) {
                    if (!caret.hasSelection()) {
                        caret.selectWordAtCaret(true);
                    }
                    int selectionStartOffset = caret.getSelectionStart();
                    int selectionEndOffset = caret.getSelectionEnd();
                    String originalText = editor.getDocument().getText(new TextRange(selectionStartOffset, selectionEndOffset));
                    if (!originalText.equals(Handler.toCase(editor, selectionStartOffset, selectionEndOffset, true))) {
                        toLowerCase.set((Object)Boolean.TRUE);
                    }
                }
            });
            Handler.runForCaret(editor, caret, new CaretAction(){

                public void perform(Caret caret) {
                    VisualPosition caretPosition = caret.getVisualPosition();
                    int selectionStartOffset = caret.getSelectionStart();
                    int selectionEndOffset = caret.getSelectionEnd();
                    VisualPosition selectionStartPosition = caret.getSelectionStartPosition();
                    VisualPosition selectionEndPosition = caret.getSelectionEndPosition();
                    caret.removeSelection();
                    editor.getDocument().replaceString(selectionStartOffset, selectionEndOffset, (CharSequence)Handler.toCase(editor, selectionStartOffset, selectionEndOffset, (Boolean)toLowerCase.get()));
                    caret.moveToVisualPosition(caretPosition);
                    caret.setSelection(selectionStartPosition, selectionStartOffset, selectionEndPosition, selectionEndOffset);
                }
            });
        }

        private static void runForCaret(Editor editor, Caret caret, CaretAction action) {
            if (caret == null) {
                editor.getCaretModel().runForEachCaret(action);
            } else {
                action.perform(caret);
            }
        }

        private static String toCase(Editor editor, int startOffset, int endOffset, boolean lower) {
            EditorHighlighter highlighter;
            CharSequence text = editor.getDocument().getImmutableCharSequence();
            if (editor instanceof EditorEx) {
                highlighter = ((EditorEx)editor).getHighlighter();
            } else {
                highlighter = new EmptyEditorHighlighter(null);
                highlighter.setText(text);
            }
            HighlighterIterator iterator = highlighter.createIterator(startOffset);
            StringBuilder builder = new StringBuilder(endOffset - startOffset);
            while (!iterator.atEnd()) {
                int start = Handler.trim(iterator.getStart(), startOffset, endOffset);
                int end = Handler.trim(iterator.getEnd(), startOffset, endOffset);
                CharSequence fragment = text.subSequence(start, end);
                builder.append(iterator.getTokenType() == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN ? fragment : (lower ? fragment.toString().toLowerCase(Locale.getDefault()) : fragment.toString().toUpperCase(Locale.getDefault())));
                if (end == endOffset) break;
                iterator.advance();
            }
            return builder.toString();
        }

        private static int trim(int value2, int lowerLimit, int upperLimit) {
            return Math.min(upperLimit, Math.max(lowerLimit, value2));
        }
    }
}

