/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex;

import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.ex.BidiTextDirection;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentSettings;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EditorSettings", storages={@Storage(value="editor.xml")})
public class EditorSettingsExternalizable
implements PersistentStateComponent<OptionSet> {
    public static final UINumericRange BLINKING_RANGE = new UINumericRange(500, 10, 1500);
    public static final UINumericRange QUICK_DOC_DELAY_RANGE = new UINumericRange(500, 1, 5000);
    private static final String COMPOSITE_PROPERTY_SEPARATOR = ":";
    private final Set<SoftWrapAppliancePlaces> myPlacesToUseSoftWraps = EnumSet.noneOf(SoftWrapAppliancePlaces.class);
    private OptionSet myOptions = new OptionSet();
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private int myBlockIndent;
    private int myAdditionalLinesCount = 10;
    private int myAdditionalColumnsCount = 20;
    private boolean myLineMarkerAreaShown = true;
    @NonNls
    public static final String STRIP_TRAILING_SPACES_NONE = "None";
    @NonNls
    public static final String STRIP_TRAILING_SPACES_CHANGED = "Changed";
    @NonNls
    public static final String STRIP_TRAILING_SPACES_WHOLE = "Whole";
    @NonNls
    public static final String DEFAULT_FONT_NAME = "Courier";

    public static EditorSettingsExternalizable getInstance() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return new EditorSettingsExternalizable();
        }
        return (EditorSettingsExternalizable)ServiceManager.getService(EditorSettingsExternalizable.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    @Nullable
    public OptionSet getState() {
        return this.myOptions;
    }

    public void loadState(OptionSet state) {
        this.myOptions = state;
        this.parseRawSoftWraps();
        ComponentSettings.getInstance().setSmoothScrollingEnabled(this.isSmoothScrolling());
    }

    private void parseRawSoftWraps() {
        String[] placeNames;
        if (StringUtil.isEmpty((String)this.myOptions.USE_SOFT_WRAPS)) {
            return;
        }
        for (String placeName : placeNames = this.myOptions.USE_SOFT_WRAPS.split(COMPOSITE_PROPERTY_SEPARATOR)) {
            try {
                SoftWrapAppliancePlaces place = SoftWrapAppliancePlaces.valueOf(placeName);
                this.myPlacesToUseSoftWraps.add(place);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.storeRawSoftWraps();
    }

    private void storeRawSoftWraps() {
        StringBuilder buffer = new StringBuilder();
        for (SoftWrapAppliancePlaces placeToStore : this.myPlacesToUseSoftWraps) {
            buffer.append((Object)placeToStore).append(COMPOSITE_PROPERTY_SEPARATOR);
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        this.myOptions.USE_SOFT_WRAPS = buffer.toString();
    }

    public OptionSet getOptions() {
        return this.myOptions;
    }

    public boolean isRightMarginShown() {
        return this.myOptions.IS_RIGHT_MARGIN_SHOWN;
    }

    public void setRightMarginShown(boolean val) {
        this.myOptions.IS_RIGHT_MARGIN_SHOWN = val;
    }

    public boolean isLineNumbersShown() {
        return this.myOptions.ARE_LINE_NUMBERS_SHOWN;
    }

    public void setLineNumbersShown(boolean val) {
        this.myOptions.ARE_LINE_NUMBERS_SHOWN = val;
    }

    public boolean areGutterIconsShown() {
        return this.myOptions.ARE_GUTTER_ICONS_SHOWN;
    }

    public void setGutterIconsShown(boolean val) {
        this.myOptions.ARE_GUTTER_ICONS_SHOWN = val;
    }

    public int getAdditionalLinesCount() {
        return this.myAdditionalLinesCount;
    }

    public void setAdditionalLinesCount(int additionalLinesCount) {
        this.myAdditionalLinesCount = additionalLinesCount;
    }

    public int getAdditinalColumnsCount() {
        return this.myAdditionalColumnsCount;
    }

    public void setAdditionalColumnsCount(int value2) {
        this.myAdditionalColumnsCount = value2;
    }

    public boolean isLineMarkerAreaShown() {
        return this.myLineMarkerAreaShown;
    }

    public void setLineMarkerAreaShown(boolean lineMarkerAreaShown) {
        this.myLineMarkerAreaShown = lineMarkerAreaShown;
    }

    public boolean isFoldingOutlineShown() {
        return this.myOptions.IS_FOLDING_OUTLINE_SHOWN;
    }

    public void setFoldingOutlineShown(boolean val) {
        this.myOptions.IS_FOLDING_OUTLINE_SHOWN = val;
    }

    public boolean isBreadcrumbsShown() {
        return this.myOptions.SHOW_BREADCRUMBS;
    }

    public void setBreadcrumbsShown(boolean breadcrumbsShown) {
        this.myOptions.SHOW_BREADCRUMBS = breadcrumbsShown;
    }

    public boolean isBlockCursor() {
        return this.myOptions.IS_BLOCK_CURSOR;
    }

    public void setBlockCursor(boolean val) {
        this.myOptions.IS_BLOCK_CURSOR = val;
    }

    public boolean isCaretRowShown() {
        return true;
    }

    public int getBlockIndent() {
        return this.myBlockIndent;
    }

    public void setBlockIndent(int blockIndent) {
        this.myBlockIndent = blockIndent;
    }

    public boolean isSmartHome() {
        return this.myOptions.SMART_HOME;
    }

    public void setSmartHome(boolean val) {
        this.myOptions.SMART_HOME = val;
    }

    public boolean isUseSoftWraps() {
        return this.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR);
    }

    public boolean isUseSoftWraps(@NotNull SoftWrapAppliancePlaces place) {
        return this.myPlacesToUseSoftWraps.contains((Object)place);
    }

    public void setUseSoftWraps(boolean use2) {
        this.setUseSoftWraps(use2, SoftWrapAppliancePlaces.MAIN_EDITOR);
    }

    public void setUseSoftWraps(boolean use2, @NotNull SoftWrapAppliancePlaces place) {
        boolean update2 = use2 ^ this.myPlacesToUseSoftWraps.contains((Object)place);
        if (!update2) {
            return;
        }
        if (use2) {
            this.myPlacesToUseSoftWraps.add(place);
        } else {
            this.myPlacesToUseSoftWraps.remove((Object)place);
        }
        this.storeRawSoftWraps();
    }

    public boolean isUseCustomSoftWrapIndent() {
        return this.myOptions.USE_CUSTOM_SOFT_WRAP_INDENT;
    }

    public void setUseCustomSoftWrapIndent(boolean use2) {
        this.myOptions.USE_CUSTOM_SOFT_WRAP_INDENT = use2;
    }

    public int getCustomSoftWrapIndent() {
        return this.myOptions.CUSTOM_SOFT_WRAP_INDENT;
    }

    public void setCustomSoftWrapIndent(int indent) {
        this.myOptions.CUSTOM_SOFT_WRAP_INDENT = indent;
    }

    public boolean isVirtualSpace() {
        return this.myOptions.IS_VIRTUAL_SPACE;
    }

    public void setVirtualSpace(boolean val) {
        this.myOptions.IS_VIRTUAL_SPACE = val;
    }

    public boolean isCaretInsideTabs() {
        return this.myOptions.IS_CARET_INSIDE_TABS;
    }

    public void setCaretInsideTabs(boolean val) {
        this.myOptions.IS_CARET_INSIDE_TABS = val;
    }

    public boolean isBlinkCaret() {
        return this.myOptions.IS_CARET_BLINKING;
    }

    public void setBlinkCaret(boolean blinkCaret) {
        this.myOptions.IS_CARET_BLINKING = blinkCaret;
    }

    public int getBlinkPeriod() {
        return BLINKING_RANGE.fit(this.myOptions.CARET_BLINKING_PERIOD);
    }

    public void setBlinkPeriod(int blinkInterval) {
        this.myOptions.CARET_BLINKING_PERIOD = BLINKING_RANGE.fit(blinkInterval);
    }

    public boolean isEnsureNewLineAtEOF() {
        return this.myOptions.IS_ENSURE_NEWLINE_AT_EOF;
    }

    public void setEnsureNewLineAtEOF(boolean ensure) {
        this.myOptions.IS_ENSURE_NEWLINE_AT_EOF = ensure;
    }

    @StripTrailingSpaces
    public String getStripTrailingSpaces() {
        return this.myOptions.STRIP_TRAILING_SPACES;
    }

    public void setStripTrailingSpaces(@StripTrailingSpaces String stripTrailingSpaces) {
        this.myOptions.STRIP_TRAILING_SPACES = stripTrailingSpaces;
    }

    public boolean isShowQuickDocOnMouseOverElement() {
        return this.myOptions.SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT;
    }

    public void setShowQuickDocOnMouseOverElement(boolean show) {
        this.myOptions.SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT = show;
    }

    public int getQuickDocOnMouseOverElementDelayMillis() {
        return QUICK_DOC_DELAY_RANGE.fit(this.myOptions.QUICK_DOC_ON_MOUSE_OVER_DELAY_MS);
    }

    public void setQuickDocOnMouseOverElementDelayMillis(int delay) {
        this.myOptions.QUICK_DOC_ON_MOUSE_OVER_DELAY_MS = QUICK_DOC_DELAY_RANGE.fit(delay);
    }

    public boolean isShowIntentionBulb() {
        return this.myOptions.SHOW_INTENTION_BULB;
    }

    public void setShowIntentionBulb(boolean show) {
        this.myOptions.SHOW_INTENTION_BULB = show;
    }

    public boolean isRefrainFromScrolling() {
        return this.myOptions.REFRAIN_FROM_SCROLLING;
    }

    public void setRefrainFromScrolling(boolean b) {
        this.myOptions.REFRAIN_FROM_SCROLLING = b;
    }

    public boolean isWhitespacesShown() {
        return this.myOptions.IS_WHITESPACES_SHOWN;
    }

    public void setWhitespacesShown(boolean val) {
        this.myOptions.IS_WHITESPACES_SHOWN = val;
    }

    public boolean isLeadingWhitespacesShown() {
        return this.myOptions.IS_LEADING_WHITESPACES_SHOWN;
    }

    public void setLeadingWhitespacesShown(boolean val) {
        this.myOptions.IS_LEADING_WHITESPACES_SHOWN = val;
    }

    public boolean isInnerWhitespacesShown() {
        return this.myOptions.IS_INNER_WHITESPACES_SHOWN;
    }

    public void setInnerWhitespacesShown(boolean val) {
        this.myOptions.IS_INNER_WHITESPACES_SHOWN = val;
    }

    public boolean isTrailingWhitespacesShown() {
        return this.myOptions.IS_TRAILING_WHITESPACES_SHOWN;
    }

    public void setTrailingWhitespacesShown(boolean val) {
        this.myOptions.IS_TRAILING_WHITESPACES_SHOWN = val;
    }

    public boolean isAllSoftWrapsShown() {
        return this.myOptions.IS_ALL_SOFTWRAPS_SHOWN;
    }

    public void setAllSoftwrapsShown(boolean val) {
        this.myOptions.IS_ALL_SOFTWRAPS_SHOWN = val;
    }

    public boolean isIndentGuidesShown() {
        return this.myOptions.IS_INDENT_GUIDES_SHOWN;
    }

    public void setIndentGuidesShown(boolean val) {
        this.myOptions.IS_INDENT_GUIDES_SHOWN = val;
    }

    public boolean isSmoothScrolling() {
        return this.myOptions.IS_ANIMATED_SCROLLING;
    }

    public void setSmoothScrolling(boolean val) {
        this.myOptions.IS_ANIMATED_SCROLLING = val;
    }

    public boolean isCamelWords() {
        return this.myOptions.IS_CAMEL_WORDS;
    }

    public void setCamelWords(boolean val) {
        this.myOptions.IS_CAMEL_WORDS = val;
    }

    public boolean isAdditionalPageAtBottom() {
        return this.myOptions.ADDITIONAL_PAGE_AT_BOTTOM;
    }

    public void setAdditionalPageAtBottom(boolean val) {
        this.myOptions.ADDITIONAL_PAGE_AT_BOTTOM = val;
    }

    public boolean isDndEnabled() {
        return this.myOptions.IS_DND_ENABLED;
    }

    public void setDndEnabled(boolean val) {
        this.myOptions.IS_DND_ENABLED = val;
    }

    public boolean isWheelFontChangeEnabled() {
        return this.myOptions.IS_WHEEL_FONTCHANGE_ENABLED;
    }

    public void setWheelFontChangeEnabled(boolean val) {
        this.myOptions.IS_WHEEL_FONTCHANGE_ENABLED = val;
    }

    public boolean isMouseClickSelectionHonorsCamelWords() {
        return this.myOptions.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS;
    }

    public void setMouseClickSelectionHonorsCamelWords(boolean val) {
        this.myOptions.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS = val;
    }

    public boolean isVariableInplaceRenameEnabled() {
        return this.myOptions.RENAME_VARIABLES_INPLACE;
    }

    public void setVariableInplaceRenameEnabled(boolean val) {
        this.myOptions.RENAME_VARIABLES_INPLACE = val;
    }

    public boolean isPreselectRename() {
        return this.myOptions.PRESELECT_RENAME;
    }

    public void setPreselectRename(boolean val) {
        this.myOptions.PRESELECT_RENAME = val;
    }

    public boolean isShowInlineLocalDialog() {
        return this.myOptions.SHOW_INLINE_DIALOG;
    }

    public void setShowInlineLocalDialog(boolean val) {
        this.myOptions.SHOW_INLINE_DIALOG = val;
    }

    public boolean addCaretsOnDoubleCtrl() {
        return this.myOptions.ADD_CARETS_ON_DOUBLE_CTRL;
    }

    public void setAddCaretsOnDoubleCtrl(boolean val) {
        this.myOptions.ADD_CARETS_ON_DOUBLE_CTRL = val;
    }

    public BidiTextDirection getBidiTextDirection() {
        return this.myOptions.BIDI_TEXT_DIRECTION;
    }

    public void setBidiTextDirection(BidiTextDirection direction) {
        this.myOptions.BIDI_TEXT_DIRECTION = direction;
    }

    public boolean isShowParameterNameHints() {
        return this.myOptions.SHOW_PARAMETER_NAME_HINTS;
    }

    public void setShowParameterNameHints(boolean value2) {
        this.myOptions.SHOW_PARAMETER_NAME_HINTS = value2;
    }

    public boolean isKeepTrailingSpacesOnCaretLine() {
        return this.myOptions.KEEP_TRAILING_SPACE_ON_CARET_LINE;
    }

    public void setKeepTrailingSpacesOnCaretLine(boolean keep) {
        this.myOptions.KEEP_TRAILING_SPACE_ON_CARET_LINE = keep;
    }

    public static @interface StripTrailingSpaces {
    }

    public static final class OptionSet {
        public String LINE_SEPARATOR;
        public String USE_SOFT_WRAPS;
        public boolean USE_CUSTOM_SOFT_WRAP_INDENT = false;
        public int CUSTOM_SOFT_WRAP_INDENT = 0;
        public boolean IS_VIRTUAL_SPACE = false;
        public boolean IS_CARET_INSIDE_TABS;
        @NonNls
        public String STRIP_TRAILING_SPACES = "Changed";
        public boolean IS_ENSURE_NEWLINE_AT_EOF = false;
        public boolean SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT = false;
        public int QUICK_DOC_ON_MOUSE_OVER_DELAY_MS;
        public boolean SHOW_INTENTION_BULB;
        public boolean IS_CARET_BLINKING;
        public int CARET_BLINKING_PERIOD;
        public boolean IS_RIGHT_MARGIN_SHOWN;
        public boolean ARE_LINE_NUMBERS_SHOWN;
        public boolean ARE_GUTTER_ICONS_SHOWN;
        public boolean IS_FOLDING_OUTLINE_SHOWN;
        public boolean SHOW_BREADCRUMBS;
        public boolean SMART_HOME;
        public boolean IS_BLOCK_CURSOR;
        public boolean IS_WHITESPACES_SHOWN;
        public boolean IS_LEADING_WHITESPACES_SHOWN;
        public boolean IS_INNER_WHITESPACES_SHOWN;
        public boolean IS_TRAILING_WHITESPACES_SHOWN;
        public boolean IS_ALL_SOFTWRAPS_SHOWN;
        public boolean IS_INDENT_GUIDES_SHOWN;
        public boolean IS_ANIMATED_SCROLLING;
        public boolean IS_CAMEL_WORDS;
        public boolean ADDITIONAL_PAGE_AT_BOTTOM;
        public boolean IS_DND_ENABLED;
        public boolean IS_WHEEL_FONTCHANGE_ENABLED;
        public boolean IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS;
        public boolean RENAME_VARIABLES_INPLACE;
        public boolean PRESELECT_RENAME;
        public boolean SHOW_INLINE_DIALOG;
        public boolean REFRAIN_FROM_SCROLLING;
        public boolean SHOW_NOTIFICATION_AFTER_REFORMAT_CODE_ACTION;
        public boolean SHOW_NOTIFICATION_AFTER_OPTIMIZE_IMPORTS_ACTION;
        public boolean ADD_CARETS_ON_DOUBLE_CTRL;
        public BidiTextDirection BIDI_TEXT_DIRECTION;
        public boolean SHOW_PARAMETER_NAME_HINTS;
        public int MIN_PARAM_NAME_LENGTH_TO_SHOW;
        public int MIN_PARAMS_TO_SHOW;
        public boolean KEEP_TRAILING_SPACE_ON_CARET_LINE;

        public OptionSet() {
            this.QUICK_DOC_ON_MOUSE_OVER_DELAY_MS = EditorSettingsExternalizable.QUICK_DOC_DELAY_RANGE.initial;
            this.SHOW_INTENTION_BULB = true;
            this.IS_CARET_BLINKING = true;
            this.CARET_BLINKING_PERIOD = EditorSettingsExternalizable.BLINKING_RANGE.initial;
            this.IS_RIGHT_MARGIN_SHOWN = true;
            this.ARE_LINE_NUMBERS_SHOWN = true;
            this.ARE_GUTTER_ICONS_SHOWN = true;
            this.IS_FOLDING_OUTLINE_SHOWN = true;
            this.SHOW_BREADCRUMBS = true;
            this.SMART_HOME = true;
            this.IS_BLOCK_CURSOR = false;
            this.IS_WHITESPACES_SHOWN = false;
            this.IS_LEADING_WHITESPACES_SHOWN = true;
            this.IS_INNER_WHITESPACES_SHOWN = true;
            this.IS_TRAILING_WHITESPACES_SHOWN = true;
            this.IS_ALL_SOFTWRAPS_SHOWN = false;
            this.IS_INDENT_GUIDES_SHOWN = true;
            this.IS_ANIMATED_SCROLLING = true;
            this.IS_CAMEL_WORDS = false;
            this.ADDITIONAL_PAGE_AT_BOTTOM = false;
            this.IS_DND_ENABLED = true;
            this.IS_WHEEL_FONTCHANGE_ENABLED = false;
            this.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS = true;
            this.RENAME_VARIABLES_INPLACE = true;
            this.PRESELECT_RENAME = true;
            this.SHOW_INLINE_DIALOG = true;
            this.REFRAIN_FROM_SCROLLING = false;
            this.SHOW_NOTIFICATION_AFTER_REFORMAT_CODE_ACTION = true;
            this.SHOW_NOTIFICATION_AFTER_OPTIMIZE_IMPORTS_ACTION = true;
            this.ADD_CARETS_ON_DOUBLE_CTRL = true;
            this.BIDI_TEXT_DIRECTION = BidiTextDirection.CONTENT_BASED;
            this.SHOW_PARAMETER_NAME_HINTS = true;
            this.MIN_PARAM_NAME_LENGTH_TO_SHOW = 3;
            this.MIN_PARAMS_TO_SHOW = 2;
            this.KEEP_TRAILING_SPACE_ON_CARET_LINE = true;
        }
    }
}

