/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterFactoryImpl
extends EditorHighlighterFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.highlighter.EditorHighlighterFactoryImpl");

    @NotNull
    public EditorHighlighter createEditorHighlighter(SyntaxHighlighter highlighter, @NotNull EditorColorsScheme colors) {
        if (highlighter == null) {
            highlighter = new PlainSyntaxHighlighter();
        }
        return new LexerEditorHighlighter(highlighter, colors);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull FileType fileType, @NotNull EditorColorsScheme settings, Project project2) {
        if (fileType instanceof LanguageFileType) {
            return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project2, fileType, null, settings);
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project2, null);
        return this.createEditorHighlighter(highlighter, settings);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project2, @NotNull FileType fileType) {
        return this.createEditorHighlighter(fileType, EditorColorsManager.getInstance().getGlobalScheme(), project2);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull VirtualFile vFile, @NotNull EditorColorsScheme settings, @Nullable Project project2) {
        FileType fileType = vFile.getFileType();
        if (fileType instanceof LanguageFileType) {
            LanguageFileType substFileType = EditorHighlighterFactoryImpl.substituteFileType(((LanguageFileType)fileType).getLanguage(), vFile, project2);
            if (substFileType != null) {
                boolean isPlain;
                EditorHighlighterProvider provider2 = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType((FileType)substFileType);
                EditorHighlighter editorHighlighter = provider2.getEditorHighlighter(project2, (FileType)substFileType, vFile, settings);
                boolean bl = isPlain = editorHighlighter.getClass() == LexerEditorHighlighter.class && ((LexerEditorHighlighter)editorHighlighter).isPlain();
                if (!isPlain) {
                    return editorHighlighter;
                }
            }
            try {
                return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project2, fileType, vFile, settings);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project2, (VirtualFile)vFile);
        return this.createEditorHighlighter(highlighter, settings);
    }

    @Nullable
    private static LanguageFileType substituteFileType(Language language, VirtualFile vFile, Project project2) {
        Language substLanguage;
        LanguageFileType fileType = null;
        if (vFile != null && project2 != null && (substLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, vFile, project2)) != language) {
            fileType = substLanguage.getAssociatedFileType();
        }
        return fileType;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project2, @NotNull VirtualFile file2) {
        return this.createEditorHighlighter(file2, EditorColorsManager.getInstance().getGlobalScheme(), project2);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project2, @NotNull String fileName) {
        return this.createEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme(), fileName, project2);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull EditorColorsScheme settings, @NotNull String fileName, @Nullable Project project2) {
        return this.createEditorHighlighter((VirtualFile)new LightVirtualFile(fileName), settings, project2);
    }
}

