/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretModelImpl
implements CaretModel,
PrioritizedDocumentListener,
Disposable,
Dumpable,
InlayModel.Listener {
    private final EditorImpl myEditor;
    private final EventDispatcher<CaretListener> myCaretListeners = EventDispatcher.create(CaretListener.class);
    private TextAttributes myTextAttributes;
    boolean myIsInUpdate;
    final RangeMarkerTree<CaretImpl.PositionMarker> myPositionMarkerTree;
    final RangeMarkerTree<CaretImpl.SelectionMarker> mySelectionMarkerTree;
    private final LinkedList<CaretImpl> myCarets = new LinkedList();
    private CaretImpl myCurrentCaret;
    private boolean myPerformCaretMergingAfterCurrentOperation;
    int myDocumentUpdateCounter;

    public CaretModelImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("columnMode".equals(evt.getPropertyName()) && !CaretModelImpl.this.myEditor.isColumnMode()) {
                    for (CaretImpl caret : CaretModelImpl.this.myCarets) {
                        caret.resetVirtualSelection();
                    }
                }
            }
        }, this);
        this.myPositionMarkerTree = new RangeMarkerTree(this.myEditor.getDocument());
        this.mySelectionMarkerTree = new RangeMarkerTree(this.myEditor.getDocument());
    }

    void initCarets() {
        this.myCarets.add(new CaretImpl(this.myEditor));
    }

    void onBulkDocumentUpdateStarted() {
    }

    void onBulkDocumentUpdateFinished() {
        this.doWithCaretMerging(() -> {});
    }

    public void documentChanged(DocumentEvent e) {
        this.myIsInUpdate = false;
        ++this.myDocumentUpdateCounter;
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.doWithCaretMerging(() -> {});
        }
    }

    public void beforeDocumentChange(DocumentEvent e) {
        this.myIsInUpdate = true;
        if (!this.myEditor.getDocument().isInBulkUpdate() && e.isWholeTextReplaced()) {
            for (CaretImpl caret : this.myCarets) {
                caret.updateCachedStateIfNeeded();
            }
        }
    }

    @Override
    public int getPriority() {
        return 120;
    }

    public void dispose() {
        for (CaretImpl caret : this.myCarets) {
            Disposer.dispose((Disposable)caret);
        }
        this.mySelectionMarkerTree.dispose();
        this.myPositionMarkerTree.dispose();
    }

    public void updateVisualPosition() {
        for (CaretImpl caret : this.myCarets) {
            caret.updateVisualPosition();
        }
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.getCurrentCaret().moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        this.getCurrentCaret().moveToLogicalPosition(pos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        this.getCurrentCaret().moveToVisualPosition(pos);
    }

    public void moveToOffset(int offset) {
        this.getCurrentCaret().moveToOffset(offset);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCurrentCaret().moveToOffset(offset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.getCurrentCaret().isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        return this.getCurrentCaret().getLogicalPosition();
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        return this.getCurrentCaret().getVisualPosition();
    }

    public int getOffset() {
        return this.getCurrentCaret().getOffset();
    }

    public int getVisualLineStart() {
        return this.getCurrentCaret().getVisualLineStart();
    }

    public int getVisualLineEnd() {
        return this.getCurrentCaret().getVisualLineEnd();
    }

    int getWordAtCaretStart() {
        return this.getCurrentCaret().getWordAtCaretStart();
    }

    int getWordAtCaretEnd() {
        return this.getCurrentCaret().getWordAtCaretEnd();
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        this.myCaretListeners.addListener((EventListener)listener2);
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        this.myCaretListeners.removeListener((EventListener)listener2);
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            this.myTextAttributes = new TextAttributes();
            if (this.myEditor.getSettings().isCaretRowShown()) {
                this.myTextAttributes.setBackgroundColor(this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
            }
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    public boolean supportsMultipleCarets() {
        return true;
    }

    @NotNull
    public CaretImpl getCurrentCaret() {
        CaretImpl currentCaret = this.myCurrentCaret;
        return ApplicationManager.getApplication().isDispatchThread() && currentCaret != null ? currentCaret : this.getPrimaryCaret();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CaretImpl getPrimaryCaret() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            return this.myCarets.get(this.myCarets.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretCount() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            return this.myCarets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Caret> getAllCarets() {
        ArrayList<Caret> carets;
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            carets = new ArrayList<Caret>(this.myCarets);
        }
        Collections.sort(carets, CaretPositionComparator.INSTANCE);
        return carets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            for (CaretImpl caret : this.myCarets) {
                if (!caret.getVisualPosition().equals((Object)pos)) continue;
                return caret;
            }
            return null;
        }
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        return this.addCaret(pos, true);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        EditorImpl.assertIsDispatchThread();
        CaretImpl caret = new CaretImpl(this.myEditor);
        caret.moveToVisualPosition(pos, false);
        if (this.addCaret(caret, makePrimary)) {
            return caret;
        }
        Disposer.dispose((Disposable)caret);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCaret(@NotNull CaretImpl caretToAdd, boolean makePrimary) {
        for (CaretImpl caret : this.myCarets) {
            if (!CaretModelImpl.caretsOverlap(caret, caretToAdd)) continue;
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (makePrimary) {
                this.myCarets.addLast(caretToAdd);
            } else {
                this.myCarets.addFirst(caretToAdd);
            }
        }
        this.fireCaretAdded(caretToAdd);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCaret(@NotNull Caret caret) {
        EditorImpl.assertIsDispatchThread();
        if (this.myCarets.size() <= 1 || !(caret instanceof CaretImpl)) {
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (!this.myCarets.remove(caret)) {
                return false;
            }
        }
        this.fireCaretRemoved(caret);
        Disposer.dispose((Disposable)caret);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecondaryCarets() {
        EditorImpl.assertIsDispatchThread();
        ListIterator<CaretImpl> caretIterator = this.myCarets.listIterator(this.myCarets.size() - 1);
        while (caretIterator.hasPrevious()) {
            CaretImpl caret = caretIterator.previous();
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                caretIterator.remove();
            }
            this.fireCaretRemoved(caret);
            Disposer.dispose((Disposable)caret);
        }
    }

    public void runForEachCaret(@NotNull CaretAction action) {
        this.runForEachCaret(action, false);
    }

    public void runForEachCaret(@NotNull CaretAction action, boolean reverseOrder) {
        EditorImpl.assertIsDispatchThread();
        if (this.myCurrentCaret != null) {
            throw new IllegalStateException("Recursive runForEachCaret invocations are not allowed");
        }
        this.doWithCaretMerging(() -> {
            try {
                List<Caret> sortedCarets = this.getAllCarets();
                if (reverseOrder) {
                    Collections.reverse(sortedCarets);
                }
                for (Caret caret : sortedCarets) {
                    this.myCurrentCaret = (CaretImpl)caret;
                    action.perform(caret);
                }
            }
            finally {
                this.myCurrentCaret = null;
            }
        });
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        EditorImpl.assertIsDispatchThread();
        this.doWithCaretMerging(runnable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeOverlappingCaretsAndSelections() {
        if (this.myCarets.size() <= 1) {
            return;
        }
        LinkedList<CaretImpl> carets = new LinkedList<CaretImpl>(this.myCarets);
        Collections.sort(carets, CaretPositionComparator.INSTANCE);
        ListIterator it = carets.listIterator();
        CaretImpl keepPrimary = this.getPrimaryCaret();
        while (it.hasNext()) {
            CaretImpl toRemove;
            CaretImpl toRetain;
            CaretImpl prevCaret = null;
            if (it.hasPrevious()) {
                prevCaret = (CaretImpl)((Object)it.previous());
                it.next();
            }
            CaretImpl currCaret = (CaretImpl)((Object)it.next());
            if (prevCaret == null || !CaretModelImpl.caretsOverlap(currCaret, prevCaret)) continue;
            int newSelectionStart = Math.min(currCaret.getSelectionStart(), prevCaret.getSelectionStart());
            int newSelectionEnd = Math.max(currCaret.getSelectionEnd(), prevCaret.getSelectionEnd());
            if (currCaret.getOffset() >= prevCaret.getSelectionStart() && currCaret.getOffset() <= prevCaret.getSelectionEnd()) {
                toRetain = prevCaret;
                toRemove = currCaret;
                it.remove();
                it.previous();
            } else {
                toRetain = currCaret;
                toRemove = prevCaret;
                it.previous();
                it.previous();
                it.remove();
            }
            if (toRemove == keepPrimary) {
                keepPrimary = toRetain;
            }
            this.removeCaret(toRemove);
            if (newSelectionStart >= newSelectionEnd) continue;
            toRetain.setSelection(newSelectionStart, newSelectionEnd);
        }
        if (keepPrimary != this.getPrimaryCaret()) {
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                this.myCarets.remove((Object)keepPrimary);
                this.myCarets.add(keepPrimary);
            }
        }
    }

    private static boolean caretsOverlap(@NotNull CaretImpl firstCaret, @NotNull CaretImpl secondCaret) {
        if (firstCaret.getVisualPosition().equals((Object)secondCaret.getVisualPosition())) {
            return true;
        }
        int firstStart = firstCaret.getSelectionStart();
        int secondStart = secondCaret.getSelectionStart();
        int firstEnd = firstCaret.getSelectionEnd();
        int secondEnd = secondCaret.getSelectionEnd();
        return firstStart < secondStart && firstEnd > secondStart || firstStart > secondStart && firstStart < secondEnd || firstStart == secondStart && secondEnd != secondStart && firstEnd > firstStart || (CaretModelImpl.hasPureVirtualSelection(firstCaret) || CaretModelImpl.hasPureVirtualSelection(secondCaret)) && (firstStart == secondStart || firstEnd == secondEnd);
    }

    private static boolean hasPureVirtualSelection(CaretImpl firstCaret) {
        return firstCaret.getSelectionStart() == firstCaret.getSelectionEnd() && firstCaret.hasVirtualSelection();
    }

    void doWithCaretMerging(Runnable runnable2) {
        if (this.myPerformCaretMergingAfterCurrentOperation) {
            runnable2.run();
        } else {
            this.myPerformCaretMergingAfterCurrentOperation = true;
            try {
                runnable2.run();
                this.mergeOverlappingCaretsAndSelections();
            }
            finally {
                this.myPerformCaretMergingAfterCurrentOperation = false;
            }
        }
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates) {
        this.setCaretsAndSelections(caretStates, true);
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates, boolean updateSystemSelection) {
        EditorImpl.assertIsDispatchThread();
        if (caretStates.isEmpty()) {
            throw new IllegalArgumentException("At least one caret should exist");
        }
        this.doWithCaretMerging(() -> {
            CaretImpl caret;
            int index = 0;
            int oldCaretCount = this.myCarets.size();
            Iterator caretIterator = this.myCarets.iterator();
            for (CaretState caretState : caretStates) {
                boolean caretAdded;
                if (index++ < oldCaretCount) {
                    caret = (CaretImpl)((Object)((Object)caretIterator.next()));
                    caretAdded = false;
                } else {
                    caret = new CaretImpl(this.myEditor);
                    if (caretState != null && caretState.getCaretPosition() != null) {
                        caret.moveToLogicalPosition(caretState.getCaretPosition(), false, null, false);
                    }
                    LinkedList<CaretImpl> linkedList = this.myCarets;
                    synchronized (linkedList) {
                        this.myCarets.add(caret);
                    }
                    this.fireCaretAdded(caret);
                    caretAdded = true;
                }
                if (caretState != null && caretState.getCaretPosition() != null && !caretAdded) {
                    caret.moveToLogicalPosition(caretState.getCaretPosition());
                }
                if (caretState == null || caretState.getSelectionStart() == null || caretState.getSelectionEnd() == null) continue;
                caret.setSelection(this.myEditor.logicalToVisualPosition(caretState.getSelectionStart()), this.myEditor.logicalPositionToOffset(caretState.getSelectionStart()), this.myEditor.logicalToVisualPosition(caretState.getSelectionEnd()), this.myEditor.logicalPositionToOffset(caretState.getSelectionEnd()), updateSystemSelection);
            }
            int caretsToRemove = this.myCarets.size() - caretStates.size();
            for (int i = 0; i < caretsToRemove; ++i) {
                LinkedList<CaretImpl> linkedList = this.myCarets;
                synchronized (linkedList) {
                    caret = this.myCarets.removeLast();
                }
                this.fireCaretRemoved(caret);
                Disposer.dispose((Disposable)caret);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            ArrayList<CaretState> states = new ArrayList<CaretState>(this.myCarets.size());
            for (CaretImpl caret : this.myCarets) {
                states.add(new CaretState(caret.getLogicalPosition(), caret.getSelectionStartLogicalPosition(), caret.getSelectionEndLogicalPosition()));
            }
            return states;
        }
    }

    void fireCaretPositionChanged(CaretEvent caretEvent) {
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretPositionChanged(caretEvent);
    }

    void fireCaretAdded(@NotNull Caret caret) {
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretAdded(new CaretEvent((Editor)this.myEditor, caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    void fireCaretRemoved(@NotNull Caret caret) {
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretRemoved(new CaretEvent((Editor)this.myEditor, caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    public boolean isIteratingOverCarets() {
        return this.myCurrentCaret != null;
    }

    @NotNull
    public String dumpState() {
        return "[in update: " + this.myIsInUpdate + ", update counter: " + this.myDocumentUpdateCounter + ", perform caret merging: " + this.myPerformCaretMergingAfterCurrentOperation + ", current caret: " + (Object)((Object)this.myCurrentCaret) + ", all carets: " + ContainerUtil.map(this.myCarets, CaretImpl::dumpState) + "]";
    }

    public void onAdded(@NotNull Inlay inlay) {
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        int offset = inlay.getOffset();
        for (CaretImpl caret : this.myCarets) {
            caret.onInlayAdded(offset);
        }
    }

    public void onRemoved(@NotNull Inlay inlay) {
        if (this.myEditor.getDocument().isInEventsHandling() || this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        this.doWithCaretMerging(this::updateVisualPosition);
    }

    public void onUpdated(@NotNull Inlay inlay) {
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        this.updateVisualPosition();
    }

    public void validateState() {
        for (CaretImpl caret : this.myCarets) {
            caret.validateState();
        }
    }

    private static class CaretPositionComparator
    implements Comparator<Caret> {
        private static final CaretPositionComparator INSTANCE = new CaretPositionComparator();

        private CaretPositionComparator() {
        }

        @Override
        public int compare(Caret o1, Caret o2) {
            return VisualPositionComparator.INSTANCE.compare(o1.getVisualPosition(), o2.getVisualPosition());
        }
    }

    private static class VisualPositionComparator
    implements Comparator<VisualPosition> {
        private static final VisualPositionComparator INSTANCE = new VisualPositionComparator();

        private VisualPositionComparator() {
        }

        @Override
        public int compare(VisualPosition o1, VisualPosition o2) {
            if (o1.line != o2.line) {
                return o1.line - o2.line;
            }
            return o1.column - o2.column;
        }
    }
}

