/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.SmartStripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.LockFreeCOWSortedArray;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import gnu.trove.TIntObjectHashMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.DocumentImpl");
    private final LockFreeCOWSortedArray<DocumentListener> myDocumentListeners = new LockFreeCOWSortedArray<DocumentListener>(PrioritizedDocumentListener.COMPARATOR, DocumentListener.ARRAY_FACTORY);
    private final List<DocumentBulkUpdateListener> myBulkDocumentInternalListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers = new RangeMarkerTree(this);
    private final RangeMarkerTree<RangeMarkerEx> myPersistentRangeMarkers = new RangeMarkerTree(this);
    private final List<RangeMarker> myGuardedBlocks = new ArrayList<RangeMarker>();
    private ReadonlyFragmentModificationHandler myReadonlyFragmentModificationHandler;
    private final Object myLineSetLock = new String("line set lock");
    private volatile LineSet myLineSet;
    private volatile ImmutableCharSequence myText;
    private volatile SoftReference<String> myTextString;
    private volatile FrozenDocument myFrozen;
    private boolean myIsReadOnly;
    private volatile boolean isStripTrailingSpacesEnabled = true;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private final List<EditReadOnlyListener> myReadOnlyListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private final boolean myAssertThreading;
    private volatile boolean myDoingBulkUpdate;
    private volatile Throwable myBulkUpdateEnteringTrace;
    private boolean myUpdatingBulkModeStatus;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;
    private volatile int myBufferSize;
    private final CharSequence myMutableCharSequence = new CharSequence(){

        @Override
        public int length() {
            return DocumentImpl.this.myText.length();
        }

        @Override
        public char charAt(int index) {
            return DocumentImpl.this.myText.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return DocumentImpl.this.myText.subSequence(start, end);
        }

        @Override
        @NotNull
        public String toString() {
            return DocumentImpl.this.doGetText();
        }
    };
    private final AtomicInteger sequence = new AtomicInteger();

    public DocumentImpl(@NotNull String text) {
        this(text, false);
    }

    public DocumentImpl(@NotNull CharSequence chars) {
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        this(chars, false, forUseInNonAWTThread);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean acceptSlashR, boolean forUseInNonAWTThread) {
        this.setAcceptSlashR(acceptSlashR);
        this.assertValidSeparators(chars);
        this.myText = CharArrayUtil.createImmutableCharSequence((CharSequence)chars);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    public boolean acceptsSlashR() {
        return this.myAcceptSlashR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                lineSet = this.myLineSet;
                if (lineSet == null) {
                    this.myLineSet = lineSet = LineSet.createLineSet((CharSequence)this.myText);
                }
            }
        }
        return lineSet;
    }

    @NotNull
    public char[] getChars() {
        return CharArrayUtil.fromSequence((CharSequence)this.myText);
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.isStripTrailingSpacesEnabled = isEnabled;
    }

    public boolean stripTrailingSpaces(Project project2) {
        return this.stripTrailingSpaces(project2, false);
    }

    public boolean stripTrailingSpaces(Project project2, boolean inChangedLinesOnly) {
        return this.stripTrailingSpaces(project2, inChangedLinesOnly, true, new int[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    boolean stripTrailingSpaces(@Nullable Project project2, boolean inChangedLinesOnly, boolean skipCaretLines, @NotNull int[] caretOffsets) {
        if (!this.isStripTrailingSpacesEnabled) {
            return true;
        }
        ArrayList<StripTrailingSpacesFilter> filters = new ArrayList<StripTrailingSpacesFilter>();
        for (StripTrailingSpacesFilterFactory stripTrailingSpacesFilterFactory : (StripTrailingSpacesFilterFactory[])StripTrailingSpacesFilterFactory.EXTENSION_POINT.getExtensions()) {
            StripTrailingSpacesFilter filter = stripTrailingSpacesFilterFactory.createFilter(project2, (Document)this);
            if (filter == StripTrailingSpacesFilter.NOT_ALLOWED) {
                return true;
            }
            if (filter == StripTrailingSpacesFilter.POSTPONED) {
                return false;
            }
            filters.add(filter);
        }
        boolean markAsNeedsStrippingLater = false;
        ImmutableCharSequence text = this.myText;
        TIntObjectHashMap caretMarkers = new TIntObjectHashMap(caretOffsets.length);
        try {
            void var9_16;
            if (skipCaretLines) {
                for (int caretOffset : caretOffsets) {
                    if (caretOffset < 0 || caretOffset > this.getTextLength()) continue;
                    int line = this.getLineNumber(caretOffset);
                    ArrayList<RangeMarker> markers = (ArrayList<RangeMarker>)caretMarkers.get(line);
                    if (markers == null) {
                        markers = new ArrayList<RangeMarker>();
                        caretMarkers.put(line, markers);
                    }
                    RangeMarker marker = this.createRangeMarker(caretOffset, caretOffset);
                    markers.add(marker);
                }
            }
            boolean bl = false;
            while (var9_16 < this.getLineCount()) {
                LineSet lineSet = this.getLineSet();
                int maxSpacesToLeave = DocumentImpl.getMaxSpacesToLeave((int)var9_16, filters);
                if ((!inChangedLinesOnly || lineSet.isModified((int)var9_16)) && maxSpacesToLeave >= 0) {
                    char c;
                    int whiteSpaceStart = -1;
                    final int lineEnd = lineSet.getLineEnd((int)var9_16) - lineSet.getSeparatorLength((int)var9_16);
                    int lineStart = lineSet.getLineStart((int)var9_16);
                    int offset = lineEnd - 1;
                    while (offset >= lineStart && ((c = text.charAt(offset)) == ' ' || c == '\t')) {
                        whiteSpaceStart = offset--;
                    }
                    if (whiteSpaceStart != -1) {
                        List markers;
                        if (skipCaretLines && (markers = (List)caretMarkers.get((int)var9_16)) != null) {
                            for (RangeMarker marker : markers) {
                                if (marker.getStartOffset() < 0 || whiteSpaceStart >= marker.getStartOffset()) continue;
                                markAsNeedsStrippingLater = true;
                                break;
                            }
                        } else {
                            int finalStart;
                            if ((finalStart = whiteSpaceStart + maxSpacesToLeave) < lineEnd) {
                                DocumentUtil.writeInRunUndoTransparentAction((Runnable)new DocumentRunnable(this, project2){

                                    public void run() {
                                        DocumentImpl.this.deleteString(finalStart, lineEnd);
                                    }
                                });
                            }
                            text = this.myText;
                        }
                    }
                }
                ++var9_16;
            }
        }
        finally {
            caretMarkers.forEachValue(markerList -> {
                if (markerList != null) {
                    for (RangeMarker marker : markerList) {
                        try {
                            marker.dispose();
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                return true;
            });
        }
        return markAsNeedsStrippingLater;
    }

    private static int getMaxSpacesToLeave(int line, @NotNull List<StripTrailingSpacesFilter> filters) {
        for (StripTrailingSpacesFilter filter : filters) {
            if (filter instanceof SmartStripTrailingSpacesFilter) {
                return ((SmartStripTrailingSpacesFilter)filter).getTrailingSpacesToLeave(line);
            }
            if (filter.isStripSpacesAllowedForLine(line)) continue;
            return -1;
        }
        return 0;
    }

    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler() {
        return this.myReadonlyFragmentModificationHandler;
    }

    void setReadonlyFragmentModificationHandler(ReadonlyFragmentModificationHandler readonlyFragmentModificationHandler) {
        this.myReadonlyFragmentModificationHandler = readonlyFragmentModificationHandler;
    }

    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    private RangeMarkerTree<RangeMarkerEx> treeFor(@NotNull RangeMarkerEx rangeMarker) {
        return rangeMarker instanceof PersistentRangeMarker ? this.myPersistentRangeMarkers : this.myRangeMarkers;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        return this.treeFor(rangeMarker).removeInterval(rangeMarker);
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        this.treeFor(rangeMarker).addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, layer);
    }

    int getRangeMarkersSize() {
        return this.myRangeMarkers.size() + this.myPersistentRangeMarkers.size();
    }

    int getRangeMarkersNodeSize() {
        return this.myRangeMarkers.nodeSize() + this.myPersistentRangeMarkers.nodeSize();
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        LOG.assertTrue(startOffset <= endOffset, (Object)"Should be startOffset <= endOffset");
        RangeMarker block = this.createRangeMarker(startOffset, endOffset, true);
        this.myGuardedBlocks.add(block);
        return block;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        this.myGuardedBlocks.remove(block);
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        return this.myGuardedBlocks;
    }

    public RangeMarker getOffsetGuard(int offset) {
        for (int i = 0; i < this.myGuardedBlocks.size(); ++i) {
            RangeMarker block = this.myGuardedBlocks.get(i);
            if (!DocumentImpl.offsetInRange(offset, block.getStartOffset(), block.getEndOffset())) continue;
            return block;
        }
        return null;
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, end, true, true, block.getStartOffset(), block.getEndOffset(), block.isGreedyToLeft(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    public void startGuardedBlockChecking() {
        ++this.myCheckGuardedBlocks;
    }

    public void stopGuardedBlockChecking() {
        LOG.assertTrue(this.myCheckGuardedBlocks > 0, (Object)"Unpaired start/stopGuardedBlockChecking");
        --this.myCheckGuardedBlocks;
    }

    private static boolean offsetInRange(int offset, int start, int end) {
        return start <= offset && offset < end;
    }

    private static boolean rangesIntersect(int start0, int end0, boolean start0Inclusive, boolean end0Inclusive, int start1, int end1, boolean start1Inclusive, boolean end1Inclusive) {
        if (start0 > start1 || start0 == start1 && !start0Inclusive) {
            if (end1 == start0) {
                return start0Inclusive && end1Inclusive;
            }
            return end1 > start0;
        }
        if (end0 == start1) {
            return start1Inclusive && end0Inclusive;
        }
        return end0 > start1;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        return this.createRangeMarker(startOffset, endOffset, false);
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (0 > startOffset || startOffset > endOffset || endOffset > this.getTextLength()) {
            LOG.error("Incorrect offsets: startOffset=" + startOffset + ", endOffset=" + endOffset + ", text length=" + this.getTextLength());
        }
        return surviveOnExternalChange ? new PersistentRangeMarker(this, startOffset, endOffset, true) : new RangeMarkerImpl(this, startOffset, endOffset, true);
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        this.replaceString(0, this.getTextLength(), chars, newModificationStamp, true);
        this.clearLineModificationFlags();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset);
        }
        if (offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + "; documentLength: " + this.getTextLength() + "; " + s.subSequence(Math.max(0, s.length() - 20), s.length()));
        }
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        if (s.length() == 0) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(offset, offset);
        if (marker != null) {
            this.throwGuardedFragment(marker, offset, "", s);
        }
        ImmutableCharSequence newText = this.myText.insert(offset, s);
        ImmutableCharSequence newString = newText.subtext(offset, offset + s.length());
        this.updateText(newText, offset, "", (CharSequence)newString, false, LocalTimeCounter.currentTime(), offset, 0);
        this.trimToSize();
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.getTextLength() > this.myBufferSize) {
            this.deleteString(0, this.getTextLength() - this.myBufferSize);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        if (startOffset == endOffset) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, this.myText.subSequence(startOffset, endOffset), "");
        }
        ImmutableCharSequence newText = this.myText.delete(startOffset, endOffset);
        ImmutableCharSequence oldString = this.myText.subtext(startOffset, endOffset);
        this.updateText(newText, startOffset, (CharSequence)oldString, "", false, LocalTimeCounter.currentTime(), startOffset, endOffset - startOffset);
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        this.assertBounds(srcStart, srcEnd);
        if (dstOffset == srcEnd) {
            return;
        }
        ProperTextRange srcRange = new ProperTextRange(srcStart, srcEnd);
        assert (!srcRange.containsOffset(dstOffset)) : "Can't perform text move from range [" + srcStart + "; " + srcEnd + ") to offset " + dstOffset;
        String replacement = this.getCharsSequence().subSequence(srcStart, srcEnd).toString();
        this.insertString(dstOffset, replacement);
        int shift = 0;
        if (dstOffset < srcStart) {
            shift = srcEnd - srcStart;
        }
        this.fireMoveText(srcStart + shift, srcEnd + shift, dstOffset);
        this.deleteString(srcStart + shift, srcEnd + shift);
    }

    private void fireMoveText(int start, int end, int newBase) {
        for (DocumentListener listener2 : this.getListeners()) {
            if (!(listener2 instanceof PrioritizedInternalDocumentListener)) continue;
            ((PrioritizedInternalDocumentListener)listener2).moveTextHappened(start, end, newBase);
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), false);
    }

    private void replaceString(int startOffset, int endOffset, @NotNull CharSequence s, long newModificationStamp, boolean wholeTextReplaced) {
        ImmutableCharSequence newText;
        int newEndInString;
        int newStartInString;
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        int initialStartOffset = startOffset;
        int initialOldLength = endOffset - startOffset;
        int newStringLength = s.length();
        ImmutableCharSequence chars = this.myText;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        for (newEndInString = newStringLength; endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1); --newEndInString, --endOffset) {
        }
        if (startOffset == 0 && endOffset == this.getTextLength()) {
            wholeTextReplaced = true;
        }
        CharSequence changedPart = s.subSequence(newStartInString, newEndInString);
        ImmutableCharSequence sToDelete = this.myText.subtext(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, (CharSequence)sToDelete, changedPart);
        }
        if (wholeTextReplaced && s instanceof ImmutableCharSequence) {
            newText = (ImmutableCharSequence)s;
        } else {
            newText = this.myText.delete(startOffset, endOffset).insert(startOffset, changedPart);
            changedPart = newText.subtext(startOffset, startOffset + changedPart.length());
        }
        this.updateText(newText, startOffset, (CharSequence)sToDelete, changedPart, wholeTextReplaced, newModificationStamp, initialStartOffset, initialOldLength);
        this.trimToSize();
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile((Document)this);
            if (file2 != null && file2.isInLocalFileSystem()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
            }
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s) {
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators((CharSequence)s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected document modification from DocumentListener");
        }
    }

    private void throwGuardedFragment(@NotNull RangeMarker guard, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString) {
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException((DocumentEvent)event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    @Override
    public void clearLineModificationFlags() {
        this.myLineSet = this.getLineSet().clearModificationFlags();
        this.myFrozen = null;
    }

    public void clearLineModificationFlags(int startLine, int endLine) {
        this.myLineSet = this.getLineSet().clearModificationFlags(startLine, endLine);
        this.myFrozen = null;
    }

    void clearLineModificationFlagsExcept(@NotNull int[] caretLines) {
        IntArrayList modifiedLines = new IntArrayList(caretLines.length);
        LineSet lineSet = this.getLineSet();
        for (int line : caretLines) {
            if (line < 0 || line >= lineSet.getLineCount() || !lineSet.isModified(line)) continue;
            modifiedLines.add(line);
        }
        lineSet = lineSet.clearModificationFlags();
        for (int i = 0; i < modifiedLines.size(); ++i) {
            lineSet = lineSet.setModified(modifiedLines.get(i));
        }
        this.myLineSet = lineSet;
        this.myFrozen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText(@NotNull ImmutableCharSequence newText, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, boolean wholeTextReplaced, long newModificationStamp, int initialStartOffset, int initialOldLength) {
        this.assertNotNestedModification();
        this.myChangeInProgress = true;
        try {
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, wholeTextReplaced, initialStartOffset, initialOldLength);
            this.beforeChangedUpdate(event);
            this.myTextString = null;
            ImmutableCharSequence prevText = this.myText;
            this.myText = newText;
            this.sequence.incrementAndGet();
            this.changedUpdate(event, newModificationStamp, (CharSequence)prevText);
        }
        finally {
            this.myChangeInProgress = false;
        }
    }

    @Override
    public int getModificationSequence() {
        return this.sequence.get();
    }

    private void beforeChangedUpdate(DocumentEvent event) {
        FileDocumentManager manager;
        VirtualFile file2;
        Application app = ApplicationManager.getApplication();
        if (app != null && (file2 = (manager = FileDocumentManager.getInstance()).getFile((Document)this)) != null && !file2.isValid()) {
            LOG.error("File of this document has been deleted.");
        }
        this.assertInsideCommand();
        this.getLineSet();
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        this.myEventsHandling = true;
    }

    private void assertInsideCommand() {
        if (!this.myAssertThreading) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
            throw new IncorrectOperationException("Must not change document outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changedUpdate(@NotNull DocumentEvent event, long newModificationStamp, @NotNull CharSequence prevText) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            assert (event.getOldFragment().length() == event.getOldLength()) : "event.getOldFragment().length() = " + event.getOldFragment().length() + "; event.getOldLength() = " + event.getOldLength();
            assert (event.getNewFragment().length() == event.getNewLength()) : "event.getNewFragment().length() = " + event.getNewFragment().length() + "; event.getNewLength() = " + event.getNewLength();
            assert (prevText.length() + event.getNewLength() - event.getOldLength() == this.getTextLength()) : "prevText.length() = " + prevText.length() + "; event.getNewLength() = " + event.getNewLength() + "; event.getOldLength() = " + event.getOldLength() + "; getTextLength() = " + this.getTextLength();
            this.myLineSet = this.getLineSet().update(prevText, event.getOffset(), event.getOffset() + event.getOldLength(), event.getNewFragment(), event.isWholeTextReplaced());
            assert (this.getTextLength() == this.myLineSet.getLength()) : "getTextLength() = " + this.getTextLength() + "; myLineSet.getLength() = " + this.myLineSet.getLength();
            this.myFrozen = null;
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener2 : listeners = this.getListeners()) {
                    try {
                        listener2.documentChanged(event);
                    }
                    catch (ProcessCanceledException e) {
                        if (!this.myAssertThreading) {
                            throw e;
                        }
                        LOG.error("ProcessCanceledException must not be thrown from document listeners for real document", new Throwable(e));
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @NotNull
    public String getText() {
        return (String)ApplicationManager.getApplication().runReadAction(() -> this.doGetText());
    }

    @NotNull
    private String doGetText() {
        String s = (String)SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference((Object)s);
        }
        return s;
    }

    @NotNull
    public String getText(@NotNull TextRange range) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> this.myText.subSequence(range.getStartOffset(), range.getEndOffset()).toString());
    }

    public int getTextLength() {
        return this.myText.length();
    }

    @NotNull
    public CharSequence getCharsSequence() {
        return this.myMutableCharSequence;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        return this.myText;
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (ArrayUtil.contains((Object)listener2, (Object[])this.getListeners())) {
            LOG.error("Already registered: " + listener2);
        }
        this.myDocumentListeners.add(listener2);
    }

    public void addDocumentListener(@NotNull DocumentListener listener2, @NotNull Disposable parentDisposable) {
        this.addDocumentListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new DocumentListenerDisposable(this.myDocumentListeners, listener2));
    }

    public void removeDocumentListener(@NotNull DocumentListener listener2) {
        boolean success = this.myDocumentListeners.remove(listener2);
        if (!success) {
            LOG.error("Can't remove document listener (" + listener2 + "). Registered listeners: " + Arrays.toString(this.getListeners()));
        }
    }

    void addInternalBulkModeListener(@NotNull DocumentBulkUpdateListener listener2) {
        this.myBulkDocumentInternalListeners.add(listener2);
    }

    void removeInternalBulkModeListener(@NotNull DocumentBulkUpdateListener listener2) {
        this.myBulkDocumentInternalListeners.remove(listener2);
    }

    public int getLineNumber(int offset) {
        return this.getLineSet().findLineIndex(offset);
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        return this.getLineSet().createIterator();
    }

    public final int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    public final int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    public final int getLineSeparatorLength(int line) {
        int separatorLength = this.getLineSet().getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    public final int getLineCount() {
        int lineCount = this.getLineSet().getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    @NotNull
    private DocumentListener[] getListeners() {
        return this.myDocumentListeners.getArray();
    }

    public void fireReadOnlyModificationAttempt() {
        for (EditReadOnlyListener listener2 : this.myReadOnlyListeners) {
            listener2.readOnlyModificationAttempt(this);
        }
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        this.myReadOnlyListeners.add(listener2);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        this.myReadOnlyListeners.remove(listener2);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    public void setCyclicBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
    }

    public void setText(@NotNull CharSequence text) {
        Runnable runnable2 = () -> this.replaceString(0, this.getTextLength(), text, LocalTimeCounter.currentTime(), true);
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable2.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)this));
        }
        this.clearLineModificationFlags();
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        return this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    @Override
    public final void setInBulkUpdate(boolean value2) {
        if (this.myAssertThreading) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        if (this.myUpdatingBulkModeStatus) {
            throw new IllegalStateException("Detected bulk mode status update from DocumentBulkUpdateListener");
        }
        if (this.myDoingBulkUpdate == value2) {
            return;
        }
        this.myUpdatingBulkModeStatus = true;
        try {
            if (value2) {
                DocumentImpl.getPublisher().updateStarted(this);
                this.notifyInternalListenersOnBulkModeStarted();
                this.myBulkUpdateEnteringTrace = new Throwable();
                this.myDoingBulkUpdate = true;
            } else {
                this.myDoingBulkUpdate = false;
                this.myBulkUpdateEnteringTrace = null;
                this.notifyInternalListenersOnBulkModeFinished();
                DocumentImpl.getPublisher().updateFinished(this);
            }
        }
        finally {
            this.myUpdatingBulkModeStatus = false;
        }
    }

    private void notifyInternalListenersOnBulkModeStarted() {
        for (DocumentBulkUpdateListener listener2 : this.myBulkDocumentInternalListeners) {
            listener2.updateStarted(this);
        }
    }

    private void notifyInternalListenersOnBulkModeFinished() {
        for (DocumentBulkUpdateListener listener2 : this.myBulkDocumentInternalListeners) {
            listener2.updateFinished(this);
        }
    }

    @NotNull
    private static DocumentBulkUpdateListener getPublisher() {
        return DocumentBulkUpdateListenerHolder.ourBulkChangePublisher;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
        return this.processRangeMarkersOverlappingWith(0, this.getTextLength(), processor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor2) {
        TextRangeInterval interval = new TextRangeInterval(start, end);
        MarkupIterator<RangeMarkerEx> iterator = IntervalTreeImpl.mergingOverlappingIterator(this.myRangeMarkers, interval, this.myPersistentRangeMarkers, interval, RangeMarker.BY_START_OFFSET);
        try {
            boolean bl = ContainerUtil.process(iterator, processor2);
            return bl;
        }
        finally {
            iterator.dispose();
        }
    }

    @NotNull
    public String dumpState() {
        StringBuilder result2 = new StringBuilder();
        result2.append(", intervals:\n");
        for (int line = 0; line < this.getLineCount(); ++line) {
            result2.append(line).append(": ").append(this.getLineStartOffset(line)).append("-").append(this.getLineEndOffset(line)).append(", ");
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - 1);
        }
        return result2.toString();
    }

    public String toString() {
        return "DocumentImpl[" + FileDocumentManager.getInstance().getFile((Document)this) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FrozenDocument freeze() {
        FrozenDocument frozen = this.myFrozen;
        if (frozen == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                frozen = this.myFrozen;
                if (frozen == null) {
                    frozen = new FrozenDocument(this.myText, this.myLineSet, this.myModificationStamp, (String)SoftReference.dereference(this.myTextString));
                }
            }
        }
        return frozen;
    }

    public void assertNotInBulkUpdate() {
        if (this.myDoingBulkUpdate) {
            throw new UnexpectedBulkUpdateStateException(this.myBulkUpdateEnteringTrace);
        }
    }

    private static class UnexpectedBulkUpdateStateException
    extends RuntimeException
    implements ExceptionWithAttachments {
        private final Attachment[] myAttachments;

        private UnexpectedBulkUpdateStateException(Throwable enteringTrace) {
            Attachment[] attachmentArray;
            if (enteringTrace == null) {
                attachmentArray = Attachment.EMPTY_ARRAY;
            } else {
                Attachment[] attachmentArray2 = new Attachment[1];
                attachmentArray = attachmentArray2;
                attachmentArray2[0] = new Attachment("enteringTrace.txt", enteringTrace);
            }
            this.myAttachments = attachmentArray;
        }

        @NotNull
        public Attachment[] getAttachments() {
            return this.myAttachments;
        }
    }

    private static class DocumentBulkUpdateListenerHolder {
        private static final DocumentBulkUpdateListener ourBulkChangePublisher = (DocumentBulkUpdateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DocumentBulkUpdateListener.TOPIC);

        private DocumentBulkUpdateListenerHolder() {
        }
    }

    private static class DocumentListenerDisposable
    implements Disposable {
        @NotNull
        private final LockFreeCOWSortedArray<DocumentListener> myList;
        @NotNull
        private final DocumentListener myListener;

        DocumentListenerDisposable(@NotNull LockFreeCOWSortedArray<DocumentListener> list, @NotNull DocumentListener listener2) {
            this.myList = list;
            this.myListener = listener2;
        }

        public void dispose() {
            this.myList.remove(this.myListener);
        }
    }
}

