/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.GutterMarkPreprocessor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingAnchorsOverlayStrategy;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntFunction;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorGutterComponentImpl
extends EditorGutterComponentEx
implements MouseListener,
MouseMotionListener,
DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorGutterComponentImpl");
    private static final int START_ICON_AREA_WIDTH = JBUI.scale((int)17);
    private static final int FREE_PAINTERS_LEFT_AREA_WIDTH = JBUI.scale((int)8);
    private static final int FREE_PAINTERS_RIGHT_AREA_WIDTH = JBUI.scale((int)5);
    private static final int GAP_BETWEEN_ICONS = JBUI.scale((int)3);
    private static final int GAP_BETWEEN_AREAS = JBUI.scale((int)5);
    private static final int GAP_BETWEEN_ANNOTATIONS = JBUI.scale((int)5);
    private static final TooltipGroup GUTTER_TOOLTIP_GROUP = new TooltipGroup("GUTTER_TOOLTIP_GROUP", 0);
    private final EditorImpl myEditor;
    private final FoldingAnchorsOverlayStrategy myAnchorsDisplayStrategy;
    @Nullable
    private TIntObjectHashMap<List<GutterMark>> myLineToGutterRenderers;
    private int myIconsAreaWidth;
    private int myLineNumberAreaWidth;
    private int myAdditionalLineNumberAreaWidth;
    private FoldRegion myActiveFoldRegion;
    private int myTextAnnotationGuttersSize;
    private int myTextAnnotationExtraSize;
    private TIntArrayList myTextAnnotationGutterSizes = new TIntArrayList();
    private ArrayList<TextAnnotationGutterProvider> myTextAnnotationGutters = new ArrayList();
    private final Map<TextAnnotationGutterProvider, EditorGutterAction> myProviderToListener = new HashMap();
    private String myLastGutterToolTip;
    @NotNull
    private TIntFunction myLineNumberConvertor = value2 -> value2;
    @Nullable
    private TIntFunction myAdditionalLineNumberConvertor;
    private boolean myShowDefaultGutterPopup = true;
    @Nullable
    private ActionGroup myCustomGutterPopupGroup;
    private final TIntObjectHashMap<Color> myTextFgColors = new TIntObjectHashMap();
    private boolean myPaintBackground = true;
    private boolean myLeftFreePaintersAreaShown;
    private boolean myRightFreePaintersAreaShown;
    private boolean myForceLeftFreePaintersAreaShown;
    private boolean myForceRightFreePaintersAreaShown;
    private int myLastNonDumbModeIconAreaWidth;
    boolean myDnDInProgress;

    EditorGutterComponentImpl(@NotNull EditorImpl editor) {
        this.myEditor = editor;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.installDnD();
        }
        this.setOpaque(true);
        this.myAnchorsDisplayStrategy = new FoldingAnchorsOverlayStrategy(editor);
        Project project2 = this.myEditor.getProject();
        if (project2 != null) {
            project2.getMessageBus().connect(this.myEditor.getDisposable()).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                }

                public void exitDumbMode() {
                    EditorGutterComponentImpl.this.updateSize();
                }
            });
        }
    }

    private void installDnD() {
        DnDSupport.createBuilder((JComponent)this).setBeanProvider(info -> {
            GutterMark renderer = this.getGutterRenderer(info.getPoint());
            if (renderer instanceof GutterIconRenderer && ((GutterIconRenderer)renderer).getDraggableObject() != null && (info.isCopy() || info.isMove())) {
                this.myDnDInProgress = true;
                return new DnDDragStartBean((Object)renderer);
            }
            return null;
        }).setDropHandler(e -> {
            Transferable transferable;
            Object attachedObject = e.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line = this.convertPointToLineNumber(e.getPoint())) != -1) {
                    draggableObject.copy(line, this.myEditor.getVirtualFile());
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                EditorImpl.handleDrop(this.myEditor, transferable);
            }
            this.myDnDInProgress = false;
        }).setTargetChecker(e -> {
            int line;
            Transferable transferable;
            Object attachedObject = e.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line2;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line2 = this.convertPointToLineNumber(e.getPoint())) != -1) {
                    e.setDropPossible(true);
                    e.setCursor(draggableObject.getCursor(line2));
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && (line = this.convertPointToLineNumber(e.getPoint())) != -1) {
                e.setDropPossible(true);
                this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getLineStartOffset(line));
            }
            return true;
        }).setImageProvider((Function)((NullableFunction)info -> {
            boolean inUserScale = SystemInfo.isWindows ? !UIUtil.isJreHiDPI((Component)this.myEditor.getComponent()) : true;
            BufferedImage image = ImageUtil.toBufferedImage((Image)this.getDragImage(this.getGutterRenderer(info.getPoint())), (boolean)inUserScale);
            return new DnDImage((Image)image, new Point(((Image)image).getWidth(null) / 2, ((Image)image).getHeight(null) / 2));
        })).enableAsNativeTarget().install();
    }

    Image getDragImage(GutterMark renderer) {
        return IconUtil.toImage((Icon)this.scaleIcon(renderer.getIcon()));
    }

    private void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.getFoldingAreaOffset() + this.getFoldingAreaWidth();
        Dimension size = new Dimension(w, this.myEditor.getPreferredHeight());
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.reinitSettings();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.reinitSettings();
    }

    public void reinitSettings() {
        this.updateSize(false, true);
        this.repaint();
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g_) {
        ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
        try {
            Rectangle clip = g_.getClipBounds();
            if (clip.height < 0) {
                return;
            }
            Graphics2D g = (Graphics2D)this.getComponentGraphics(g_);
            AffineTransform old = this.setMirrorTransformIfNeeded(g, 0, this.getWidth());
            EditorUIUtil.setupAntialiasing(g);
            Color backgroundColor = this.getBackground();
            if (this.myEditor.isDisposed()) {
                g.setColor(this.myEditor.getDisposedBackground());
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
                return;
            }
            int startVisualLine = this.myEditor.yToVisibleLine(clip.y);
            int endVisualLine = this.myEditor.yToVisibleLine(clip.y + clip.height);
            int gutterSeparatorX = this.getWhitespaceSeparatorOffset();
            this.paintBackground(g, clip, 0, gutterSeparatorX, backgroundColor);
            this.paintBackground(g, clip, gutterSeparatorX, this.getFoldingAreaWidth(), this.myEditor.getBackgroundColor());
            int firstVisibleOffset = this.myEditor.visualLineStartOffset(startVisualLine);
            int lastVisibleOffset = this.myEditor.visualLineStartOffset(endVisualLine + 1);
            this.paintEditorBackgrounds(g, firstVisibleOffset, lastVisibleOffset);
            Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (!UIUtil.isJreHiDPI((Graphics2D)g)) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            try {
                this.paintAnnotations(g, startVisualLine, endVisualLine);
                this.paintLineMarkers(g, firstVisibleOffset, lastVisibleOffset);
                this.paintFoldingLines(g, clip);
                this.paintFoldingTree(g, clip, firstVisibleOffset, lastVisibleOffset);
                this.paintLineNumbers(g, startVisualLine, endVisualLine);
            }
            finally {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
            }
            if (old != null) {
                g.setTransform(old);
            }
        }
        finally {
            ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
        }
    }

    private void paintEditorBackgrounds(Graphics g, int firstVisibleOffset, int lastVisibleOffset) {
        this.myTextFgColors.clear();
        Color defaultBackgroundColor = this.myEditor.getBackgroundColor();
        Color defaultForegroundColor = this.myEditor.getColorsScheme().getDefaultForeground();
        int startX = this.myEditor.isInDistractionFreeMode() ? 0 : this.getWhitespaceSeparatorOffset();
        IterationState state = new IterationState(this.myEditor, firstVisibleOffset, lastVisibleOffset, null, true, false, true, false);
        while (!state.atEnd()) {
            this.drawEditorBackgroundForRange(g, state.getStartOffset(), state.getEndOffset(), state.getMergedAttributes(), defaultBackgroundColor, defaultForegroundColor, startX);
            state.advance();
        }
    }

    private void drawEditorBackgroundForRange(Graphics g, int startOffset, int endOffset, TextAttributes attributes, Color defaultBackgroundColor, Color defaultForegroundColor, int startX) {
        VisualPosition visualStart = this.myEditor.offsetToVisualPosition(startOffset, true, false);
        VisualPosition visualEnd = this.myEditor.offsetToVisualPosition(endOffset, false, false);
        for (int line = visualStart.getLine(); line <= visualEnd.getLine(); ++line) {
            if (line == visualStart.getLine()) {
                if (visualStart.getColumn() != 0) continue;
                this.drawEditorLineBackgroundRect(g, attributes, line, defaultBackgroundColor, defaultForegroundColor, startX, this.myEditor.visibleLineToY(line));
                continue;
            }
            if (line == visualEnd.getLine() && visualEnd.getColumn() == 0) continue;
            this.drawEditorLineBackgroundRect(g, attributes, line, defaultBackgroundColor, defaultForegroundColor, startX, this.myEditor.visibleLineToY(line));
        }
    }

    private void drawEditorLineBackgroundRect(Graphics g, TextAttributes attributes, int visualLine, Color defaultBackgroundColor, Color defaultForegroundColor, int startX, int startY) {
        Color color = this.myEditor.getBackgroundColor(attributes);
        if (!Comparing.equal((Object)color, (Object)defaultBackgroundColor)) {
            Color fgColor = attributes.getForegroundColor();
            if (!Comparing.equal((Object)fgColor, (Object)defaultForegroundColor)) {
                this.myTextFgColors.put(visualLine, (Object)fgColor);
            }
            g.setColor(color);
            g.fillRect(startX, startY, this.getWidth() - startX, this.myEditor.getLineHeight());
        }
    }

    private void processClose(MouseEvent e) {
        IdeEventQueue queue = IdeEventQueue.getInstance();
        if (this.getGutterRenderer(e) != null) {
            return;
        }
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            queue.blockNextEvents(e);
            this.closeAllAnnotations();
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintAnnotations(Graphics2D g, int startVisualLine, int endVisualLine) {
        int x = this.getAnnotationsAreaOffset();
        int w = this.getAnnotationsAreaWidthEx();
        if (w == 0) {
            return;
        }
        AffineTransform old = this.setMirrorTransformIfNeeded(g, x, w);
        try {
            Color color = this.myEditor.getColorsScheme().getColor(EditorColors.ANNOTATIONS_COLOR);
            g.setColor(color != null ? color : JBColor.blue);
            g.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            for (int i = 0; i < this.myTextAnnotationGutters.size(); ++i) {
                TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(i);
                int lineHeight = this.myEditor.getLineHeight();
                int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line;
                if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine))) {
                    break;
                }
                int annotationSize = this.myTextAnnotationGutterSizes.get(i);
                VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
                while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                    int logLine = visLinesIterator.getStartLogicalLine();
                    int y = visLinesIterator.getY();
                    String s = gutterProvider.getLineText(logLine, (Editor)this.myEditor);
                    EditorFontType style = gutterProvider.getStyle(logLine, (Editor)this.myEditor);
                    Color bg = gutterProvider.getBgColor(logLine, (Editor)this.myEditor);
                    if (bg != null) {
                        g.setColor(bg);
                        g.fillRect(x, y, annotationSize, lineHeight);
                    }
                    g.setColor(this.myEditor.getColorsScheme().getColor(gutterProvider.getColor(logLine, (Editor)this.myEditor)));
                    g.setFont(this.myEditor.getColorsScheme().getFont(style));
                    if (!StringUtil.isEmpty((String)s)) {
                        g.drawString(s, GAP_BETWEEN_ANNOTATIONS / 2 + x, y + this.myEditor.getAscent());
                    }
                    visLinesIterator.advance();
                }
                if (startVisualLine == 0 && endVisualLine == 0) {
                    String s = gutterProvider.getLineText(0, (Editor)this.myEditor);
                    EditorFontType style = gutterProvider.getStyle(0, (Editor)this.myEditor);
                    Color bg = gutterProvider.getBgColor(0, (Editor)this.myEditor);
                    if (bg != null) {
                        g.setColor(bg);
                        g.fillRect(x, 0, annotationSize, lineHeight);
                    }
                    g.setColor(this.myEditor.getColorsScheme().getColor(gutterProvider.getColor(0, (Editor)this.myEditor)));
                    g.setFont(this.myEditor.getColorsScheme().getFont(style));
                    if (!StringUtil.isEmpty((String)s)) {
                        g.drawString(s, GAP_BETWEEN_ANNOTATIONS / 2 + x, this.myEditor.getAscent());
                    }
                }
                x += annotationSize;
            }
        }
        finally {
            if (old != null) {
                g.setTransform(old);
            }
        }
    }

    private void paintFoldingTree(Graphics g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        if (this.isFoldingOutlineShown()) {
            this.doPaintFoldingTree((Graphics2D)g, clip, firstVisibleOffset, lastVisibleOffset);
        }
    }

    private void paintLineMarkers(Graphics2D g, int firstVisibleOffset, int lastVisibleOffset) {
        if (this.isLineMarkersShown()) {
            this.paintGutterRenderers(g, firstVisibleOffset, lastVisibleOffset);
        }
    }

    private void paintBackground(Graphics g, Rectangle clip, int x, int width, Color background) {
        g.setColor(background);
        g.fillRect(x, clip.y, width, clip.height);
        this.paintCaretRowBackground(g, x, width);
    }

    private void paintCaretRowBackground(Graphics g, int x, int width) {
        if (!this.myEditor.getSettings().isCaretRowShown()) {
            return;
        }
        VisualPosition visCaret = this.myEditor.getCaretModel().getVisualPosition();
        Color caretRowColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
        if (caretRowColor != null) {
            g.setColor(caretRowColor);
            Point caretPoint = this.myEditor.visualPositionToXY(visCaret);
            g.fillRect(x, caretPoint.y, width, this.myEditor.getLineHeight());
        }
    }

    private void paintLineNumbers(Graphics2D g, int startVisualLine, int endVisualLine) {
        if (this.isLineNumbersShown()) {
            int offset = this.getLineNumberAreaOffset() + this.myLineNumberAreaWidth;
            this.doPaintLineNumbers(g, startVisualLine, endVisualLine, offset, this.myLineNumberConvertor);
            if (this.myAdditionalLineNumberConvertor != null) {
                this.doPaintLineNumbers(g, startVisualLine, endVisualLine, offset + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth), this.myAdditionalLineNumberConvertor);
            }
        }
    }

    @Override
    public Color getBackground() {
        if (this.myEditor.isInDistractionFreeMode() || !this.myPaintBackground) {
            return this.myEditor.getBackgroundColor();
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        return color != null ? color : EditorColors.GUTTER_BACKGROUND.getDefaultColor();
    }

    private Font getFontForLineNumbers() {
        Font editorFont = this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
        float editorFontSize = editorFont.getSize2D();
        return editorFont.deriveFont(Math.max(1.0f, editorFontSize - 1.0f));
    }

    private int calcLineNumbersAreaWidth(int maxLineNumber) {
        return this.getFontMetrics(this.getFontForLineNumbers()).stringWidth(Integer.toString(maxLineNumber + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaintLineNumbers(Graphics2D g, int startVisualLine, int endVisualLine, int offset, @NotNull TIntFunction convertor) {
        int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line;
        if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine))) {
            return;
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR);
        g.setColor(color != null ? color : JBColor.blue);
        Font font = this.getFontForLineNumbers();
        g.setFont(font);
        AffineTransform old = this.setMirrorTransformIfNeeded(g, this.getLineNumberAreaOffset(), this.getLineNumberAreaWidth());
        try {
            VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
            while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                int logLine;
                LogicalPosition logicalPosition = this.myEditor.visualToLogicalPosition(new VisualPosition(visLinesIterator.getVisualLine(), 0));
                if (EditorUtil.getSoftWrapCountAfterLineStart(this.myEditor, logicalPosition) <= 0 && (logLine = convertor.execute(visLinesIterator.getStartLogicalLine())) >= 0) {
                    int startY = visLinesIterator.getY();
                    if (this.myEditor.isInDistractionFreeMode()) {
                        Color fgColor = (Color)this.myTextFgColors.get(visLinesIterator.getVisualLine());
                        g.setColor(fgColor != null ? fgColor : (color != null ? color : JBColor.blue));
                    }
                    String s = String.valueOf(logLine + 1);
                    int textOffset = this.isMirrored() ? offset - this.getLineNumberAreaWidth() - 1 : offset - g.getFontMetrics().stringWidth(s);
                    g.drawString(s, textOffset, startY + this.myEditor.getAscent());
                }
                visLinesIterator.advance();
            }
        }
        finally {
            if (old != null) {
                g.setTransform(old);
            }
        }
    }

    private int endLineNumber() {
        return Math.max(0, this.myEditor.getDocument().getLineCount() - 1);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (this.myEditor.isDisposed()) {
            return null;
        }
        if (EditorGutter.KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    private void processRangeHighlighters(int startOffset, int endOffset, @NotNull RangeHighlighterProcessor processor2) {
        DocumentEx document = this.myEditor.getDocument();
        MarkupIterator<RangeHighlighterEx> docHighlighters = this.myEditor.getFilteredDocumentMarkupModel().overlappingIterator(startOffset, endOffset);
        MarkupIterator<RangeHighlighterEx> editorHighlighters = this.myEditor.getMarkupModel().overlappingIterator(startOffset, endOffset);
        try {
            RangeHighlighterEx lastDocHighlighter = null;
            RangeHighlighterEx lastEditorHighlighter = null;
            while (true) {
                int endLineIndex;
                int startLineIndex;
                RangeHighlighterEx lowerHighlighter;
                if (lastDocHighlighter == null && docHighlighters.hasNext()) {
                    lastDocHighlighter = (RangeHighlighterEx)docHighlighters.next();
                    if (!lastDocHighlighter.isValid() || lastDocHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                    if (lastDocHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                }
                if (lastEditorHighlighter == null && editorHighlighters.hasNext()) {
                    lastEditorHighlighter = (RangeHighlighterEx)editorHighlighters.next();
                    if (!lastEditorHighlighter.isValid() || lastEditorHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                    if (lastEditorHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                }
                if (lastDocHighlighter == null && lastEditorHighlighter == null) {
                    return;
                }
                if (EditorGutterComponentImpl.less(lastDocHighlighter, lastEditorHighlighter)) {
                    lowerHighlighter = lastDocHighlighter;
                    lastDocHighlighter = null;
                } else {
                    lowerHighlighter = lastEditorHighlighter;
                    lastEditorHighlighter = null;
                }
                if (!lowerHighlighter.isValid() || !EditorGutterComponentImpl.isValidLine(document, startLineIndex = lowerHighlighter.getDocument().getLineNumber(startOffset)) || !EditorGutterComponentImpl.isValidLine(document, endLineIndex = lowerHighlighter.getDocument().getLineNumber(endOffset))) continue;
                processor2.process(lowerHighlighter);
            }
        }
        finally {
            docHighlighters.dispose();
            editorHighlighters.dispose();
        }
    }

    private static boolean isValidLine(@NotNull Document document, int line) {
        if (line < 0) {
            return false;
        }
        int lineCount = document.getLineCount();
        return lineCount == 0 ? line == 0 : line < lineCount;
    }

    private static boolean less(RangeHighlighter h1, RangeHighlighter h2) {
        return h1 != null && (h2 == null || h1.getStartOffset() < h2.getStartOffset());
    }

    @Override
    public void revalidateMarkup() {
        this.updateSize();
    }

    void updateSizeOnShowNotify() {
        this.updateSize(false, true);
    }

    public void updateSize() {
        this.updateSize(false, false);
    }

    void updateSize(boolean onLayout, boolean canShrink) {
        int prevHash = this.sizeHash();
        if (!onLayout) {
            this.clearLineToGutterRenderersCache();
            this.calcLineNumberAreaWidth();
            this.calcLineMarkerAreaWidth(canShrink);
            this.calcAnnotationsSize();
        }
        this.calcAnnotationExtraSize();
        if (prevHash != this.sizeHash()) {
            this.fireResized();
        }
        this.repaint();
    }

    private int sizeHash() {
        int result2 = this.getLineMarkerAreaWidth();
        result2 = 31 * result2 + this.myTextAnnotationGuttersSize;
        result2 = 31 * result2 + this.myTextAnnotationExtraSize;
        result2 = 31 * result2 + this.getLineNumberAreaWidth();
        return result2;
    }

    private void calcAnnotationsSize() {
        this.myTextAnnotationGuttersSize = 0;
        FontMetrics fontMetrics = this.myEditor.getFontMetrics(0);
        int lineCount = Math.max(this.myEditor.getDocument().getLineCount(), 1);
        for (int j = 0; j < this.myTextAnnotationGutters.size(); ++j) {
            TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(j);
            int gutterSize = 0;
            for (int i = 0; i < lineCount; ++i) {
                String lineText = gutterProvider.getLineText(i, (Editor)this.myEditor);
                if (StringUtil.isEmpty((String)lineText)) continue;
                gutterSize = Math.max(gutterSize, fontMetrics.stringWidth(lineText));
            }
            if (gutterSize > 0) {
                gutterSize += GAP_BETWEEN_ANNOTATIONS;
            }
            this.myTextAnnotationGutterSizes.set(j, gutterSize);
            this.myTextAnnotationGuttersSize += gutterSize;
        }
    }

    private void calcAnnotationExtraSize() {
        int width;
        this.myTextAnnotationExtraSize = 0;
        if (!this.myEditor.isInDistractionFreeMode() || this.isMirrored()) {
            return;
        }
        Window frame = SwingUtilities.getWindowAncestor(this.myEditor.getComponent());
        if (frame == null) {
            return;
        }
        EditorSettings settings = this.myEditor.getSettings();
        int rightMargin = settings.getRightMargin(this.myEditor.getProject());
        if (rightMargin <= 0) {
            return;
        }
        JComponent editorComponent = this.myEditor.getComponent();
        RelativePoint point = new RelativePoint((Component)editorComponent, new Point(0, 0));
        Point editorLocationInWindow = point.getPoint((Component)frame);
        int editorLocationX = (int)editorLocationInWindow.getX();
        int rightMarginX = rightMargin * EditorUtil.getSpaceWidth(0, this.myEditor) + editorLocationX;
        if (rightMarginX < (width = editorLocationX + editorComponent.getWidth()) && editorLocationX < width - rightMarginX) {
            int centeredSize = (width - rightMarginX - editorLocationX) / 2 - (this.getLineMarkerAreaWidth() + this.getLineNumberAreaWidth() + this.getFoldingAreaWidth() + 2 * GAP_BETWEEN_AREAS);
            this.myTextAnnotationExtraSize = Math.max(0, centeredSize - this.myTextAnnotationGuttersSize);
        }
    }

    void clearLineToGutterRenderersCache() {
        this.myLineToGutterRenderers = null;
    }

    private void buildGutterRenderersCache() {
        this.myLineToGutterRenderers = new TIntObjectHashMap();
        this.processRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), highlighter -> {
            GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
            if (renderer == null) {
                return;
            }
            if (!this.isHighlighterVisible(highlighter)) {
                return;
            }
            int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset(this.myEditor, highlighter.getStartOffset());
            int line = this.myEditor.getDocument().getLineNumber(lineStartOffset);
            List renderers = (List)this.myLineToGutterRenderers.get(line);
            if (renderers == null) {
                renderers = new SmartList();
                this.myLineToGutterRenderers.put(line, (Object)renderers);
            }
            renderers.add(renderer);
        });
        this.myLineToGutterRenderers.transformValues(value2 -> {
            List newValue = value2;
            for (GutterMarkPreprocessor preprocessor : (GutterMarkPreprocessor[])GutterMarkPreprocessor.EP_NAME.getExtensions()) {
                newValue = preprocessor.processMarkers((List)value2);
            }
            if (newValue.size() >= 5) {
                newValue = newValue.subList(0, 4);
            }
            return newValue;
        });
    }

    private void calcLineMarkerAreaWidth(boolean canShrink) {
        this.myLeftFreePaintersAreaShown = this.myForceLeftFreePaintersAreaShown;
        this.myRightFreePaintersAreaShown = this.myForceRightFreePaintersAreaShown;
        this.processRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), highlighter -> {
            LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
            if (lineMarkerRenderer != null) {
                LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(lineMarkerRenderer);
                if (position == LineMarkerRendererEx.Position.LEFT && this.isLineMarkerVisible(highlighter)) {
                    this.myLeftFreePaintersAreaShown = true;
                }
                if (position == LineMarkerRendererEx.Position.RIGHT && this.isLineMarkerVisible(highlighter)) {
                    this.myRightFreePaintersAreaShown = true;
                }
            }
        });
        if (!this.areIconsShown()) {
            this.myIconsAreaWidth = 0;
            this.myLastNonDumbModeIconAreaWidth = 0;
            return;
        }
        int minWidth = (int)((float)START_ICON_AREA_WIDTH * this.myEditor.getScale());
        this.myIconsAreaWidth = canShrink ? minWidth : Math.max(this.myIconsAreaWidth, minWidth);
        this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
            int width = 1;
            for (int i = 0; i < renderers.size(); ++i) {
                GutterMark renderer = (GutterMark)renderers.get(i);
                if (!this.checkDumbAware(renderer)) continue;
                width += this.scaleIcon(renderer.getIcon()).getIconWidth();
                if (i <= 0) continue;
                width += GAP_BETWEEN_ICONS;
            }
            if (this.myIconsAreaWidth < width) {
                this.myIconsAreaWidth = width + 1;
            }
            return true;
        }));
        if (this.isDumbMode()) {
            this.myIconsAreaWidth = Math.max(this.myIconsAreaWidth, this.myLastNonDumbModeIconAreaWidth);
        } else {
            this.myLastNonDumbModeIconAreaWidth = this.myIconsAreaWidth;
        }
    }

    @Nullable
    private List<GutterMark> getGutterRenderers(int line) {
        if (this.myLineToGutterRenderers == null) {
            this.buildGutterRenderersCache();
        }
        return (List)this.myLineToGutterRenderers.get(line);
    }

    private void processGutterRenderers(@NotNull TIntObjectProcedure<List<GutterMark>> processor2) {
        if (this.myLineToGutterRenderers == null) {
            this.buildGutterRenderersCache();
        }
        this.myLineToGutterRenderers.forEachEntry(processor2);
    }

    private boolean isHighlighterVisible(RangeHighlighter highlighter) {
        int startOffset = highlighter instanceof RangeHighlighterEx ? ((RangeHighlighterEx)highlighter).getAffectedAreaStartOffset() : highlighter.getStartOffset();
        int endOffset = highlighter instanceof RangeHighlighterEx ? ((RangeHighlighterEx)highlighter).getAffectedAreaEndOffset() : highlighter.getEndOffset();
        FoldRegion foldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        return foldRegion == null || foldRegion.getEndOffset() < endOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintGutterRenderers(Graphics2D g, int firstVisibleOffset, int lastVisibleOffset) {
        Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            ArrayList highlighters = new ArrayList();
            this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter -> {
                LineMarkerRenderer renderer = highlighter.getLineMarkerRenderer();
                if (renderer != null) {
                    highlighters.add(highlighter);
                }
            });
            ContainerUtil.sort(highlighters, Comparator.comparingInt(RangeHighlighter::getLayer));
            for (RangeHighlighter highlighter2 : highlighters) {
                this.paintLineMarkerRenderer(highlighter2, g);
            }
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
        int firstVisibleLine = this.myEditor.getDocument().getLineNumber(firstVisibleOffset);
        int lastVisibleLine = this.myEditor.getDocument().getLineNumber(lastVisibleOffset);
        this.paintIcons(firstVisibleLine, lastVisibleLine, g);
    }

    private void paintIcons(int firstVisibleLine, int lastVisibleLine, Graphics2D g) {
        for (int line = firstVisibleLine; line <= lastVisibleLine; ++line) {
            List<GutterMark> renderers = this.getGutterRenderers(line);
            if (renderers == null) continue;
            this.paintIconRow(line, renderers, g);
        }
    }

    private void paintIconRow(int line, List<GutterMark> row, Graphics2D g) {
        this.processIconsRow(line, row, (x, y, renderer) -> {
            Icon icon = this.scaleIcon(renderer.getIcon());
            AffineTransform old = this.setMirrorTransformIfNeeded(g, x, icon.getIconWidth());
            try {
                icon.paintIcon(this, g, x, y);
            }
            finally {
                if (old != null) {
                    g.setTransform(old);
                }
            }
        });
    }

    private void paintLineMarkerRenderer(RangeHighlighter highlighter, Graphics g) {
        Rectangle rectangle;
        LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
        if (lineMarkerRenderer != null && (rectangle = this.getLineRendererRectangle(highlighter)) != null) {
            lineMarkerRenderer.paint((Editor)this.myEditor, g, rectangle);
        }
    }

    private boolean isLineMarkerVisible(RangeHighlighter highlighter) {
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        FoldRegion startFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        FoldRegion endFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(endOffset);
        return startFoldRegion == null || endFoldRegion == null || !startFoldRegion.equals(endFoldRegion);
    }

    @Nullable
    private Rectangle getLineRendererRectangle(RangeHighlighter highlighter) {
        int x;
        int w;
        if (!this.isLineMarkerVisible(highlighter)) {
            return null;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        int startY = this.myEditor.visibleLineToY(this.myEditor.offsetToVisualLine(startOffset));
        int endY = this.myEditor.visibleLineToY(this.myEditor.offsetToVisualLine(endOffset));
        DocumentEx document = this.myEditor.getDocument();
        if (document.getLineStartOffset(document.getLineNumber(endOffset)) != endOffset) {
            endY += this.myEditor.getLineHeight();
        }
        LineMarkerRenderer renderer = (LineMarkerRenderer)ObjectUtils.assertNotNull((Object)highlighter.getLineMarkerRenderer());
        LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(renderer);
        switch (position) {
            case LEFT: {
                w = this.getLeftFreePaintersAreaWidth();
                x = this.getLeftFreePaintersAreaOffset();
                break;
            }
            case RIGHT: {
                w = this.getRightFreePaintersAreaWidth();
                x = this.getLineMarkerFreePaintersAreaOffset();
                break;
            }
            case CUSTOM: {
                w = this.getWidth();
                x = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(position.name());
            }
        }
        int height = endY - startY;
        return new Rectangle(x, startY, w, height);
    }

    private Icon scaleIcon(Icon icon) {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && icon instanceof ScalableIcon && Math.abs(1.0f - (scale = this.myEditor.getScale())) > 0.1f) {
            if (icon instanceof JBUI.JBUIScaleTrackable) {
                ((JBUI.JBUIScaleTrackable)icon).updateJBUIScale(this.getGraphicsConfiguration());
            }
            return ((ScalableIcon)icon).scale(scale);
        }
        return icon;
    }

    private void processIconsRow(int line, @NotNull List<GutterMark> row, @NotNull LineGutterIconRendererProcessor processor2) {
        Icon icon;
        if (!this.areIconsShown()) {
            return;
        }
        int middleCount = 0;
        int middleSize = 0;
        int x = this.getIconAreaOffset() + 2;
        int y = this.myEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
        for (GutterMark gutterMark : row) {
            if (!this.checkDumbAware(gutterMark)) continue;
            GutterIconRenderer.Alignment alignment = ((GutterIconRenderer)gutterMark).getAlignment();
            icon = this.scaleIcon(gutterMark.getIcon());
            if (alignment == GutterIconRenderer.Alignment.LEFT) {
                processor2.process(x, y + this.getTextAlignmentShift(icon), gutterMark);
                x += icon.getIconWidth() + GAP_BETWEEN_ICONS;
                continue;
            }
            if (alignment != GutterIconRenderer.Alignment.CENTER) continue;
            ++middleCount;
            middleSize += icon.getIconWidth() + GAP_BETWEEN_ICONS;
        }
        int leftSize = x - this.getIconAreaOffset();
        x = this.getIconAreaOffset() + this.myIconsAreaWidth;
        for (GutterMark r : row) {
            if (!this.checkDumbAware(r) || ((GutterIconRenderer)r).getAlignment() != GutterIconRenderer.Alignment.RIGHT) continue;
            icon = this.scaleIcon(r.getIcon());
            processor2.process(x -= icon.getIconWidth(), y + this.getTextAlignmentShift(icon), r);
            x -= GAP_BETWEEN_ICONS;
        }
        int n = this.myIconsAreaWidth + this.getIconAreaOffset() - x + 1;
        if (middleCount > 0) {
            x = this.getIconAreaOffset() + leftSize + (this.myIconsAreaWidth - leftSize - n - (middleSize -= GAP_BETWEEN_ICONS)) / 2;
            for (GutterMark r : row) {
                if (!this.checkDumbAware(r) || ((GutterIconRenderer)r).getAlignment() != GutterIconRenderer.Alignment.CENTER) continue;
                Icon icon2 = this.scaleIcon(r.getIcon());
                processor2.process(x, y + this.getTextAlignmentShift(icon2), r);
                x += icon2.getIconWidth() + GAP_BETWEEN_ICONS;
            }
        }
    }

    private int getTextAlignmentShift(Icon icon) {
        int centerRelative = (this.myEditor.getLineHeight() - icon.getIconHeight()) / 2;
        int baselineRelative = this.myEditor.getAscent() - icon.getIconHeight();
        return Math.max(centerRelative, baselineRelative);
    }

    private Color getOutlineColor(boolean isActive) {
        ColorKey key2 = isActive ? EditorColors.SELECTED_TEARLINE_COLOR : EditorColors.TEARLINE_COLOR;
        Color color = this.myEditor.getColorsScheme().getColor(key2);
        return color != null ? color : JBColor.black;
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider2) {
        this.myTextAnnotationGutters.add(provider2);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider2, @NotNull EditorGutterAction action) {
        this.myTextAnnotationGutters.add(provider2);
        this.myProviderToListener.put(provider2, action);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    private void doPaintFoldingTree(Graphics2D g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        int anchorX = this.getFoldingAreaOffset();
        int width = this.getFoldingAnchorWidth();
        Collection<DisplayedFoldingAnchor> anchorsToDisplay = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(firstVisibleOffset, lastVisibleOffset, this.myActiveFoldRegion);
        for (DisplayedFoldingAnchor anchor : anchorsToDisplay) {
            this.drawFoldingAnchor(width, clip, g, anchorX, anchor.visualLine, anchor.type, anchor.foldRegion == this.myActiveFoldRegion);
        }
    }

    private void paintFoldingLines(Graphics2D g, Rectangle clip) {
        if (!this.isFoldingOutlineShown()) {
            return;
        }
        if (this.myPaintBackground) {
            g.setColor(this.getOutlineColor(false));
            int x = this.getWhitespaceSeparatorOffset();
            UIUtil.drawLine((Graphics)g, (int)x, (int)clip.y, (int)x, (int)(clip.y + clip.height));
        }
        int anchorX = this.getFoldingAreaOffset();
        int width = this.getFoldingAnchorWidth();
        if (this.myActiveFoldRegion != null && this.myActiveFoldRegion.isExpanded() && this.myActiveFoldRegion.isValid()) {
            int foldStart = this.myEditor.offsetToVisualLine(this.myActiveFoldRegion.getStartOffset());
            int foldEnd = this.myEditor.offsetToVisualLine(this.getEndOffset(this.myActiveFoldRegion));
            int startY = this.getLineCenterY(foldStart);
            int endY = this.getLineCenterY(foldEnd);
            if (startY <= clip.y + clip.height && endY + 1 + this.myEditor.getDescent() >= clip.y) {
                g.setColor(this.getOutlineColor(true));
                int lineX = anchorX + width / 2;
                UIUtil.drawLine((Graphics)g, (int)lineX, (int)startY, (int)lineX, (int)endY);
            }
        }
    }

    @Override
    public int getWhitespaceSeparatorOffset() {
        return this.getFoldingAreaOffset() + this.getFoldingAnchorWidth() / 2;
    }

    void setActiveFoldRegion(FoldRegion activeFoldRegion) {
        if (this.myActiveFoldRegion != activeFoldRegion) {
            this.myActiveFoldRegion = activeFoldRegion;
            this.repaint();
        }
    }

    private int getLineCenterY(int line) {
        return this.myEditor.visibleLineToY(line) + this.myEditor.getLineHeight() / 2;
    }

    private int getFoldAnchorY(int line, int width) {
        return this.myEditor.visibleLineToY(line) + this.myEditor.getAscent() - width;
    }

    int getHeadCenterY(FoldRegion foldRange) {
        return this.getLineCenterY(this.myEditor.offsetToVisualLine(foldRange.getStartOffset()));
    }

    private void drawFoldingAnchor(int width, Rectangle clip, Graphics2D g, int anchorX, int visualLine, DisplayedFoldingAnchor.Type type2, boolean active) {
        int off = (int)((float)width / 4.0f);
        int height = width + off;
        int baseHeight = height - width / 2;
        int y = this.getFoldAnchorY(visualLine, width);
        switch (type2) {
            case COLLAPSED: {
                if (y > clip.y + clip.height || y + height < clip.y) break;
                this.drawSquareWithPlus(g, anchorX, y, width, active);
                break;
            }
            case EXPANDED_TOP: {
                if (y > clip.y + clip.height || y + height < clip.y) break;
                this.drawDirectedBox(g, anchorX, y, width, height, baseHeight, active);
                break;
            }
            case EXPANDED_BOTTOM: {
                if ((y += width) - height > clip.y + clip.height || y < clip.y) break;
                this.drawDirectedBox(g, anchorX, y, width, -height, -baseHeight, active);
            }
        }
    }

    private int getEndOffset(FoldRegion foldRange) {
        LOG.assertTrue(foldRange.isValid(), (Object)foldRange);
        FoldingGroup group = foldRange.getGroup();
        return group == null ? foldRange.getEndOffset() : this.myEditor.getFoldingModel().getEndOffset(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawDirectedBox(Graphics2D g, int anchorX, int y, int width, int height, int baseHeight, boolean active) {
        Object antialiasing = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (SystemInfo.isMac && SystemInfo.JAVA_VERSION.startsWith("1.4.1") || UIUtil.isJreHiDPI((Graphics2D)g)) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        try {
            int off = EditorGutterComponentImpl.getSquareInnerOffset(width);
            g.setColor(this.myEditor.getBackgroundColor());
            int[] xPoints = new int[]{anchorX, anchorX + width, anchorX + width, anchorX + width / 2, anchorX};
            int[] yPoints = new int[]{y, y, y + baseHeight, y + height, y + baseHeight};
            g.fillPolygon(xPoints, yPoints, 5);
            g.setColor(this.getOutlineColor(active));
            g.drawPolygon(xPoints, yPoints, 5);
            int minusHeight = y + baseHeight / 2 + (height - baseHeight) / 4;
            UIUtil.drawLine((Graphics)g, (int)(anchorX + off), (int)minusHeight, (int)(anchorX + width - off), (int)minusHeight);
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        }
    }

    private void drawSquareWithPlus(Graphics2D g, int anchorX, int y, int width, boolean active) {
        this.drawSquareWithMinus(g, anchorX, y, width, active);
        int off = EditorGutterComponentImpl.getSquareInnerOffset(width);
        UIUtil.drawLine((Graphics)g, (int)(anchorX + width / 2), (int)(y + off), (int)(anchorX + width / 2), (int)(y + width - off));
    }

    private static int getSquareInnerOffset(int width) {
        return Math.max(width / 5, JBUI.scale((int)2));
    }

    private void drawSquareWithMinus(Graphics2D g, int anchorX, int y, int width, boolean active) {
        g.setColor(this.myEditor.getBackgroundColor());
        g.fillRect(anchorX, y, width, width);
        g.setColor(this.getOutlineColor(active));
        g.drawRect(anchorX, y, width, width);
        int off = EditorGutterComponentImpl.getSquareInnerOffset(width);
        if (!active) {
            g.setColor(this.getOutlineColor(true));
        }
        UIUtil.drawLine((Graphics)g, (int)(anchorX + off), (int)(y + width / 2), (int)(anchorX + width - off), (int)(y + width / 2));
    }

    private int getFoldingAnchorWidth() {
        return EditorGutterComponentImpl.roundToEven(Math.min((float)JBUI.scale((int)4) * this.myEditor.getScale(), (float)(this.myEditor.getLineHeight() / 2 - JBUI.scale((int)2))) * 2.0f);
    }

    private static int roundToEven(float f) {
        int lower = (int)Math.floor(f);
        int upper = (int)Math.ceil(f);
        if (lower % 2 == 0) {
            return lower;
        }
        if (upper % 2 == 0) {
            return upper;
        }
        return lower > 0 ? lower - 1 : 0;
    }

    private int getFoldingAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLineMarkerAreaWidth();
    }

    private int getFoldingAreaWidth() {
        return this.isFoldingOutlineShown() ? this.getFoldingAnchorWidth() + JBUI.scale((int)2) : (this.isRealEditor() ? this.getFoldingAnchorWidth() : 0);
    }

    private boolean isRealEditor() {
        return EditorUtil.isRealFileEditor(this.myEditor);
    }

    private boolean isLineMarkersShown() {
        return this.myEditor.getSettings().isLineMarkerAreaShown();
    }

    private boolean areIconsShown() {
        return this.myEditor.getSettings().areGutterIconsShown();
    }

    private boolean isLineNumbersShown() {
        return this.myEditor.getSettings().isLineNumbersShown();
    }

    public boolean isAnnotationsShown() {
        return !this.myTextAnnotationGutters.isEmpty();
    }

    private boolean isFoldingOutlineShown() {
        return this.myEditor.getSettings().isFoldingOutlineShown() && this.myEditor.getFoldingModel().isFoldingEnabled() && !this.myEditor.isInPresentationMode();
    }

    private static int getAreaWidthWithGap(int width) {
        if (width > 0) {
            return width + GAP_BETWEEN_AREAS;
        }
        return 0;
    }

    private int getLineNumberAreaWidth() {
        return this.isLineNumbersShown() ? this.myLineNumberAreaWidth + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth) : 0;
    }

    private int getLineMarkerAreaWidth() {
        return this.isLineMarkersShown() ? this.getLeftFreePaintersAreaWidth() + this.myIconsAreaWidth + this.getGapAfterIconsArea() + this.getRightFreePaintersAreaWidth() : 0;
    }

    private void calcLineNumberAreaWidth() {
        if (!this.isLineNumbersShown()) {
            return;
        }
        int maxLineNumber = this.getMaxLineNumber(this.myLineNumberConvertor);
        this.myLineNumberAreaWidth = this.calcLineNumbersAreaWidth(maxLineNumber);
        this.myAdditionalLineNumberAreaWidth = 0;
        if (this.myAdditionalLineNumberConvertor != null) {
            int maxAdditionalLineNumber = this.getMaxLineNumber(this.myAdditionalLineNumberConvertor);
            this.myAdditionalLineNumberAreaWidth = this.calcLineNumbersAreaWidth(maxAdditionalLineNumber);
        }
    }

    private int getMaxLineNumber(@NotNull TIntFunction convertor) {
        for (int i = this.endLineNumber(); i >= 0; --i) {
            int number = convertor.execute(i);
            if (number < 0) continue;
            return number;
        }
        return 0;
    }

    @Nullable
    EditorMouseEventArea getEditorMouseAreaByOffset(int offset) {
        if (this.isLineNumbersShown() && offset < this.getLineNumberAreaOffset() + this.getLineNumberAreaWidth()) {
            return EditorMouseEventArea.LINE_NUMBERS_AREA;
        }
        if (this.isAnnotationsShown() && offset < this.getAnnotationsAreaOffset() + this.getAnnotationsAreaWidth()) {
            return EditorMouseEventArea.ANNOTATIONS_AREA;
        }
        if (this.isLineMarkersShown() && offset < this.getFoldingAreaOffset()) {
            return EditorMouseEventArea.LINE_MARKERS_AREA;
        }
        if (this.isFoldingOutlineShown() && offset < this.getFoldingAreaOffset() + this.getFoldingAreaWidth()) {
            return EditorMouseEventArea.FOLDING_OUTLINE_AREA;
        }
        return null;
    }

    private int getLineNumberAreaOffset() {
        if (this.getLineNumberAreaWidth() == 0 && this.getAnnotationsAreaWidthEx() == 0 && this.getLineMarkerAreaWidth() == 0) {
            return this.getFoldingAreaWidth() == 0 ? 0 : 1;
        }
        if (this.getLineNumberAreaWidth() == 0 && this.getAnnotationsAreaWidthEx() > 0) {
            return 0;
        }
        return GAP_BETWEEN_AREAS;
    }

    @Override
    public int getAnnotationsAreaOffset() {
        return this.getLineNumberAreaOffset() + EditorGutterComponentImpl.getAreaWidthWithGap(this.getLineNumberAreaWidth());
    }

    @Override
    public int getAnnotationsAreaWidth() {
        return this.myTextAnnotationGuttersSize;
    }

    private int getAnnotationsAreaWidthEx() {
        return this.myTextAnnotationGuttersSize + this.myTextAnnotationExtraSize;
    }

    @Override
    public int getLineMarkerAreaOffset() {
        return this.getAnnotationsAreaOffset() + EditorGutterComponentImpl.getAreaWidthWithGap(this.getAnnotationsAreaWidthEx());
    }

    @Override
    public int getIconAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLeftFreePaintersAreaWidth();
    }

    private int getLeftFreePaintersAreaOffset() {
        return this.getLineMarkerAreaOffset();
    }

    @Override
    public int getLineMarkerFreePaintersAreaOffset() {
        return this.getIconAreaOffset() + this.myIconsAreaWidth + this.getGapAfterIconsArea();
    }

    private int getLeftFreePaintersAreaWidth() {
        return this.myLeftFreePaintersAreaShown ? FREE_PAINTERS_LEFT_AREA_WIDTH : 0;
    }

    private int getRightFreePaintersAreaWidth() {
        return this.myRightFreePaintersAreaShown ? FREE_PAINTERS_RIGHT_AREA_WIDTH : 0;
    }

    @Override
    public int getIconsAreaWidth() {
        return this.myIconsAreaWidth;
    }

    private int getGapAfterIconsArea() {
        return this.isRealEditor() && this.areIconsShown() ? GAP_BETWEEN_AREAS : 0;
    }

    private boolean isMirrored() {
        return this.myEditor.getVerticalScrollbarOrientation() != 1;
    }

    @Nullable
    private AffineTransform setMirrorTransformIfNeeded(Graphics2D g, int offset, int width) {
        if (this.isMirrored()) {
            AffineTransform old = g.getTransform();
            AffineTransform transform = new AffineTransform(old);
            transform.scale(-1.0, 1.0);
            transform.translate(-offset * 2 - width, 0.0);
            g.setTransform(transform);
            return old;
        }
        return null;
    }

    @Override
    @Nullable
    public FoldRegion findFoldingAnchorAt(int x, int y) {
        if (!this.myEditor.getSettings().isFoldingOutlineShown()) {
            return null;
        }
        int anchorX = this.getFoldingAreaOffset();
        int anchorWidth = this.getFoldingAnchorWidth();
        int visualLine = this.myEditor.yToVisibleLine(y);
        int neighbourhoodStartOffset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, 0)));
        int neighbourhoodEndOffset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, Integer.MAX_VALUE)));
        Collection<DisplayedFoldingAnchor> displayedAnchors = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(neighbourhoodStartOffset, neighbourhoodEndOffset, null);
        for (DisplayedFoldingAnchor anchor : displayedAnchors) {
            if (!this.rectangleByFoldOffset(anchor.visualLine, anchorWidth, anchorX).contains(this.convertX(x), y)) continue;
            return anchor.foldRegion;
        }
        return null;
    }

    private Rectangle rectangleByFoldOffset(int foldStart, int anchorWidth, int anchorX) {
        return new Rectangle(anchorX, this.getFoldAnchorY(foldStart, anchorWidth), anchorWidth, anchorWidth);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TooltipController.getInstance().cancelTooltips();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int line;
        String toolTip = null;
        GutterIconRenderer renderer = this.getGutterRenderer(e);
        TooltipController controller = TooltipController.getInstance();
        if (renderer != null) {
            toolTip = renderer.getTooltipText();
        } else {
            TextAnnotationGutterProvider provider2 = this.getProviderAtPoint(e.getPoint());
            if (provider2 != null) {
                line = this.getLineNumAtPoint(e.getPoint());
                toolTip = provider2.getToolTip(line, (Editor)this.myEditor);
                if (!Comparing.equal((String)toolTip, (String)this.myLastGutterToolTip)) {
                    controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, e, true);
                    this.myLastGutterToolTip = toolTip;
                }
            } else {
                ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
                if (lineRenderer != null) {
                    toolTip = lineRenderer.getTooltipText();
                }
            }
        }
        if (toolTip != null && !toolTip.isEmpty()) {
            Ref t = new Ref((Object)e.getPoint());
            line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, e);
            List<GutterMark> row = this.getGutterRenderers(line);
            Balloon.Position ballPosition = Balloon.Position.atRight;
            if (row != null) {
                TreeMap xPos = new TreeMap();
                int[] currentPos = new int[]{0};
                this.processIconsRow(line, row, (x, y, r) -> {
                    xPos.put(x, r);
                    if (renderer == r) {
                        currentPos[0] = x;
                        Icon icon = this.scaleIcon(r.getIcon());
                        t.set((Object)new Point(x + icon.getIconWidth() / 2, y + icon.getIconHeight() / 2));
                    }
                });
                ArrayList xx = new ArrayList(xPos.keySet());
                int posIndex = xx.indexOf(currentPos[0]);
                if (xPos.size() > 1 && posIndex == 0) {
                    ballPosition = Balloon.Position.below;
                }
            }
            RelativePoint showPoint = new RelativePoint((Component)this, (Point)t.get());
            controller.showTooltipByMouseMove(this.myEditor, showPoint, ((EditorMarkupModel)((Object)this.myEditor.getMarkupModel())).getErrorStripTooltipRendererProvider().calcTooltipRenderer(toolTip), false, GUTTER_TOOLTIP_GROUP, new HintHint(this, (Point)t.get()).setAwtTooltip(true).setPreferredPosition(ballPosition));
        } else {
            controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, e, false);
        }
    }

    void validateMousePointer(@NotNull MouseEvent e) {
        GutterIconRenderer renderer;
        if (IdeGlassPaneImpl.hasPreProcessedCursor(this)) {
            return;
        }
        FoldRegion foldingAtCursor = this.findFoldingAnchorAt(e.getX(), e.getY());
        this.setActiveFoldRegion(foldingAtCursor);
        Cursor cursor = Cursor.getPredefinedCursor(0);
        if (foldingAtCursor != null) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        if ((renderer = this.getGutterRenderer(e)) != null) {
            if (renderer.isNavigateAction()) {
                cursor = Cursor.getPredefinedCursor(12);
            }
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                cursor = Cursor.getPredefinedCursor(12);
            } else {
                EditorGutterAction action;
                TextAnnotationGutterProvider provider2 = this.getProviderAtPoint(e.getPoint());
                if (provider2 != null && this.myProviderToListener.containsKey(provider2) && (action = this.myProviderToListener.get(provider2)) != null) {
                    int line = this.getLineNumAtPoint(e.getPoint());
                    cursor = action.getCursor(line);
                }
            }
        }
        this.setCursor(cursor);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
        }
    }

    private void fireEventToTextAnnotationListeners(MouseEvent e) {
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            int line;
            Point clickPoint = e.getPoint();
            TextAnnotationGutterProvider provider2 = this.getProviderAtPoint(clickPoint);
            if (provider2 == null) {
                return;
            }
            if (this.myProviderToListener.containsKey(provider2) && (line = this.getLineNumAtPoint(clickPoint)) >= 0 && line < this.myEditor.getDocument().getLineCount() && UIUtil.isActionClick((MouseEvent)e, (int)502)) {
                this.myProviderToListener.get(provider2).doAction(line);
            }
        }
    }

    private int getLineNumAtPoint(Point clickPoint) {
        return EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, clickPoint);
    }

    @Nullable
    private TextAnnotationGutterProvider getProviderAtPoint(Point clickPoint) {
        int current = this.getAnnotationsAreaOffset();
        if (clickPoint.x < current) {
            return null;
        }
        for (int i = 0; i < this.myTextAnnotationGutterSizes.size(); ++i) {
            if (clickPoint.x > (current += this.myTextAnnotationGutterSizes.get(i))) continue;
            return this.myTextAnnotationGutters.get(i);
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || this.isPopupAction(e)) {
            this.invokePopup(e);
        } else if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.processClose(e);
        }
    }

    private boolean isPopupAction(MouseEvent e) {
        GutterIconRenderer renderer = this.getGutterRenderer(e);
        return renderer != null && renderer.getClickAction() == null && renderer.getPopupMenuActions() != null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
            return;
        }
        GutterIconRenderer renderer = this.getGutterRenderer(e);
        AnAction clickAction = null;
        if (renderer != null && e.getButton() < 4) {
            AnAction anAction = clickAction = BitUtil.isSet((int)e.getModifiers(), (int)8) ? renderer.getMiddleButtonClickAction() : renderer.getClickAction();
        }
        if (clickAction != null) {
            this.performAction(clickAction, e, "ICON_NAVIGATION", this.myEditor.getDataContext());
            this.repaint();
            e.consume();
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                lineRenderer.doAction((Editor)this.myEditor, e);
            } else {
                this.fireEventToTextAnnotationListeners(e);
            }
        }
    }

    private boolean isDumbMode() {
        Project project2 = this.myEditor.getProject();
        return project2 != null && DumbService.isDumb((Project)project2);
    }

    private boolean checkDumbAware(@NotNull Object possiblyDumbAware) {
        return !this.isDumbMode() || DumbService.isDumbAware((Object)possiblyDumbAware);
    }

    private void notifyNotDumbAware() {
        Project project2 = this.myEditor.getProject();
        if (project2 != null) {
            DumbService.getInstance((Project)project2).showDumbModeNotification("This functionality is not available during indexing");
        }
    }

    private void performAction(@NotNull AnAction action, @NotNull InputEvent e, @NotNull String place, @NotNull DataContext context) {
        if (!this.checkDumbAware(action)) {
            this.notifyNotDumbAware();
            return;
        }
        AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)e, (String)place, (DataContext)context);
        action.update(actionEvent);
        if (actionEvent.getPresentation().isEnabledAndVisible()) {
            ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)actionEvent);
        }
    }

    @Nullable
    private ActiveGutterRenderer getActiveRendererByMouseEvent(MouseEvent e) {
        if (this.findFoldingAnchorAt(e.getX(), e.getY()) != null) {
            return null;
        }
        if (e.isConsumed() || e.getX() > this.getWhitespaceSeparatorOffset()) {
            return null;
        }
        ActiveGutterRenderer[] gutterRenderer = new ActiveGutterRenderer[]{null};
        int[] layer = new int[]{-1};
        Rectangle clip = this.myEditor.getScrollingModel().getVisibleArea();
        int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
        int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
        this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter -> {
            LineMarkerRenderer renderer = highlighter.getLineMarkerRenderer();
            if (renderer == null) {
                return;
            }
            if (gutterRenderer[0] != null && layer[0] >= highlighter.getLayer()) {
                return;
            }
            Rectangle rectangle = this.getLineRendererRectangle(highlighter);
            if (rectangle == null) {
                return;
            }
            int startY = rectangle.y;
            int endY = startY + rectangle.height;
            if (startY == endY) {
                endY += this.myEditor.getLineHeight();
            }
            if (startY < e.getY() && e.getY() <= endY && renderer instanceof ActiveGutterRenderer && ((ActiveGutterRenderer)renderer).canDoAction(e)) {
                gutterRenderer[0] = (ActiveGutterRenderer)renderer;
                layer[0] = highlighter.getLayer();
            }
        });
        return gutterRenderer[0];
    }

    public void closeAllAnnotations() {
        for (TextAnnotationGutterProvider provider2 : this.myTextAnnotationGutters) {
            provider2.gutterClosed();
        }
        this.revalidateSizes();
    }

    private void revalidateSizes() {
        this.myTextAnnotationGutters = new ArrayList();
        this.myTextAnnotationGutterSizes = new TIntArrayList();
        this.updateSize();
    }

    @Override
    @Nullable
    public Point getCenterPoint(GutterIconRenderer renderer) {
        Ref result2 = Ref.create();
        if (!this.areIconsShown()) {
            this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
                if (ContainerUtil.find((Iterable)renderers, (Object)renderer) != null) {
                    result2.set((Object)new Point(this.getIconAreaOffset(), this.getLineCenterY(line)));
                    return false;
                }
                return true;
            }));
        } else {
            this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
                this.processIconsRow(line, (List<GutterMark>)renderers, (x, y, r) -> {
                    if (result2.isNull() && r.equals(renderer)) {
                        Icon icon = this.scaleIcon(r.getIcon());
                        result2.set((Object)new Point(x + icon.getIconWidth() / 2, y + icon.getIconHeight() / 2));
                    }
                });
                return result2.isNull();
            }));
        }
        return (Point)result2.get();
    }

    @Override
    public void setLineNumberConvertor(@NotNull TIntFunction lineNumberConvertor) {
        this.setLineNumberConvertor(lineNumberConvertor, null);
    }

    @Override
    public void setLineNumberConvertor(@NotNull TIntFunction lineNumberConvertor1, @Nullable TIntFunction lineNumberConvertor2) {
        this.myLineNumberConvertor = lineNumberConvertor1;
        this.myAdditionalLineNumberConvertor = lineNumberConvertor2;
    }

    @Override
    public void setShowDefaultGutterPopup(boolean show) {
        this.myShowDefaultGutterPopup = show;
    }

    @Override
    public void setGutterPopupGroup(@Nullable ActionGroup group) {
        this.myCustomGutterPopupGroup = group;
    }

    @Override
    public void setPaintBackground(boolean value2) {
        this.myPaintBackground = value2;
    }

    @Override
    public void setForceShowLeftFreePaintersArea(boolean value2) {
        this.myForceLeftFreePaintersAreaShown = value2;
    }

    @Override
    public void setForceShowRightFreePaintersArea(boolean value2) {
        this.myForceRightFreePaintersAreaShown = value2;
    }

    private void invokePopup(MouseEvent e) {
        ActionManager actionManager = ActionManager.getInstance();
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            DefaultActionGroup actionGroup = new DefaultActionGroup(EditorBundle.message((String)"editor.annotations.action.group.name", (Object[])new Object[0]), true);
            actionGroup.add((AnAction)new CloseAnnotationsAction());
            ArrayList<AnAction> addActions = new ArrayList<AnAction>();
            Point p = e.getPoint();
            int line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p);
            for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
                List list = gutterProvider.getPopupActions(line, (Editor)this.myEditor);
                if (list == null) continue;
                for (AnAction action : list) {
                    if (addActions.contains(action)) continue;
                    addActions.add(action);
                }
            }
            for (AnAction addAction : addActions) {
                actionGroup.add(addAction);
            }
            JPopupMenu menu = actionManager.createActionPopupMenu("", (ActionGroup)actionGroup).getComponent();
            menu.show(this, e.getX(), e.getY());
            e.consume();
        } else {
            GutterIconRenderer renderer = this.getGutterRenderer(e);
            if (renderer != null) {
                ActionGroup actionGroup = renderer.getPopupMenuActions();
                if (actionGroup != null) {
                    if (this.checkDumbAware(actionGroup)) {
                        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", actionGroup);
                        popupMenu.getComponent().show(this, e.getX(), e.getY());
                    } else {
                        this.notifyNotDumbAware();
                    }
                    e.consume();
                } else {
                    AnAction rightButtonAction = renderer.getRightButtonClickAction();
                    if (rightButtonAction != null) {
                        this.performAction(rightButtonAction, e, "ICON_NAVIGATION_SECONDARY_BUTTON", this.myEditor.getDataContext());
                        e.consume();
                    }
                }
            } else {
                ActionGroup group = this.myCustomGutterPopupGroup;
                if (group == null && this.myShowDefaultGutterPopup) {
                    group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorGutterPopupMenu");
                }
                if (group != null) {
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", group);
                    popupMenu.getComponent().show(this, e.getX(), e.getY());
                }
                e.consume();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        TooltipController.getInstance().cancelTooltip(GUTTER_TOOLTIP_GROUP, e, false);
    }

    private int convertPointToLineNumber(Point p) {
        int line;
        DocumentEx document = this.myEditor.getDocument();
        if (!EditorGutterComponentImpl.isValidLine(document, line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p))) {
            return -1;
        }
        int startOffset = document.getLineStartOffset(line);
        FoldRegion region = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (region != null) {
            return document.getLineNumber(region.getEndOffset());
        }
        return line;
    }

    @Nullable
    private GutterMark getGutterRenderer(Point p) {
        int line = this.convertPointToLineNumber(p);
        if (line == -1) {
            return null;
        }
        List<GutterMark> renderers = this.getGutterRenderers(line);
        if (renderers == null) {
            return null;
        }
        GutterMark[] result2 = new GutterMark[]{null};
        this.processIconsRow(line, renderers, (x, y, renderer) -> {
            int ex = this.convertX((int)p.getX());
            Icon icon = this.scaleIcon(renderer.getIcon());
            if (x <= ex && ex <= x + icon.getIconWidth()) {
                result2[0] = renderer;
            }
        });
        return result2[0];
    }

    @Nullable
    private GutterIconRenderer getGutterRenderer(MouseEvent e) {
        return (GutterIconRenderer)this.getGutterRenderer(e.getPoint());
    }

    @NotNull
    private static LineMarkerRendererEx.Position getLineMarkerPosition(@NotNull LineMarkerRenderer renderer) {
        if (renderer instanceof LineMarkerRendererEx) {
            return ((LineMarkerRendererEx)renderer).getPosition();
        }
        return LineMarkerRendererEx.Position.RIGHT;
    }

    int convertX(int x) {
        if (!this.isMirrored()) {
            return x;
        }
        return this.getWidth() - x;
    }

    public void dispose() {
        for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
            gutterProvider.gutterClosed();
        }
        this.myProviderToListener.clear();
    }

    private class CloseAnnotationsAction
    extends DumbAwareAction {
        CloseAnnotationsAction() {
            super(EditorBundle.message((String)"close.editor.annotations.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            EditorGutterComponentImpl.this.closeAllAnnotations();
        }
    }

    @FunctionalInterface
    private static interface LineGutterIconRendererProcessor {
        public void process(int var1, int var2, @NotNull GutterMark var3);
    }

    @FunctionalInterface
    private static interface RangeHighlighterProcessor {
        public void process(@NotNull RangeHighlighter var1);
    }
}

