/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class FoldingAnchorsOverlayStrategy {
    private final EditorImpl myEditor;

    FoldingAnchorsOverlayStrategy(EditorImpl editor) {
        this.myEditor = editor;
    }

    @NotNull
    Collection<DisplayedFoldingAnchor> getAnchorsToDisplay(int firstVisibleOffset, int lastVisibleOffset, FoldRegion activeFoldRegion) {
        FoldRegion[] visibleFoldRegions;
        HashMap result2 = new HashMap();
        for (FoldRegion region : visibleFoldRegions = this.myEditor.getFoldingModel().fetchVisible()) {
            FoldingGroup group;
            int endOffset;
            int startOffset;
            if (!region.isValid() || (startOffset = region.getStartOffset()) > lastVisibleOffset || (endOffset = this.getEndOffset(region)) < firstVisibleOffset || !this.isFoldingPossible(startOffset, endOffset) || (group = region.getGroup()) != null && this.myEditor.getFoldingModel().getFirstRegion(group, region) != region) continue;
            int foldStart = this.myEditor.offsetToVisualLine(startOffset);
            if (!region.isExpanded()) {
                FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldStart, 0, DisplayedFoldingAnchor.Type.COLLAPSED, activeFoldRegion);
                continue;
            }
            int foldEnd = this.myEditor.offsetToVisualLine(endOffset);
            FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldStart, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_TOP, activeFoldRegion);
            FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldEnd, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_BOTTOM, activeFoldRegion);
        }
        return result2.values();
    }

    private static void tryAdding(@NotNull Map<Integer, DisplayedFoldingAnchor> resultsMap, @NotNull FoldRegion region, int visualLine, int visualHeight, @NotNull DisplayedFoldingAnchor.Type type2, FoldRegion activeRegion) {
        DisplayedFoldingAnchor prev = resultsMap.get(visualLine);
        if (prev != null) {
            if (prev.foldRegion == activeRegion) {
                return;
            }
            if (region != activeRegion && prev.foldRegionVisualLines < visualHeight) {
                return;
            }
        }
        resultsMap.put(visualLine, new DisplayedFoldingAnchor(region, visualLine, visualHeight, type2));
    }

    private int getEndOffset(@NotNull FoldRegion foldRange) {
        FoldingGroup group = foldRange.getGroup();
        return group == null ? foldRange.getEndOffset() : this.myEditor.getFoldingModel().getEndOffset(group);
    }

    private boolean isFoldingPossible(int startOffset, int endOffset) {
        DocumentEx document = this.myEditor.getDocument();
        if (startOffset >= document.getTextLength()) {
            return false;
        }
        int endOffsetToUse = Math.min(endOffset, document.getTextLength());
        if (endOffsetToUse <= startOffset) {
            return false;
        }
        if (document.getLineNumber(startOffset) != document.getLineNumber(endOffsetToUse)) {
            return true;
        }
        return this.myEditor.getSettings().isAllowSingleLogicalLineFolding() && !this.myEditor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffsetToUse).isEmpty();
    }
}

