/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Getter;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

class InlayImpl
extends RangeMarkerImpl
implements Inlay,
Getter<InlayImpl> {
    @NotNull
    private final EditorImpl myEditor;
    final int myOriginalOffset;
    int myOffsetBeforeDisposal = -1;
    private int myWidthInPixels;
    @NotNull
    private final EditorCustomElementRenderer myRenderer;

    InlayImpl(@NotNull EditorImpl editor, int offset, @NotNull EditorCustomElementRenderer renderer) {
        super(editor.getDocument(), offset, offset, false);
        this.myEditor = editor;
        this.myOriginalOffset = offset;
        this.myRenderer = renderer;
        this.doUpdateSize();
        this.myEditor.getInlayModel().myInlayTree.addInterval(this, offset, offset, false, false, 0);
    }

    public void updateSize() {
        this.doUpdateSize();
        this.myEditor.getInlayModel().notifyChanged(this);
    }

    private void doUpdateSize() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Editor)this.myEditor);
        if (this.myWidthInPixels <= 0) {
            throw new IllegalArgumentException("Positive width should be defined for an inline element");
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        super.changedUpdateImpl(e);
        if (this.myEditor.getInlayModel().myStickToLargerOffsetsOnUpdate && this.isValid() && e.getOldLength() == 0 && this.getOffset() == e.getOffset()) {
            int newOffset = e.getOffset() + e.getNewLength();
            this.setIntervalStart(newOffset);
            this.setIntervalEnd(newOffset);
        }
        if (this.isValid() && DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.intervalStart())) {
            this.invalidate(e);
        }
    }

    @Override
    protected void onReTarget(int startOffset, int endOffset, int destOffset) {
        if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.getOffset())) {
            this.invalidate("moved inside surrogate pair on retarget");
        }
    }

    @Override
    public void dispose() {
        if (this.isValid()) {
            this.myOffsetBeforeDisposal = this.getOffset();
            this.myEditor.getInlayModel().myInlayTree.removeInterval(this);
            this.myEditor.getInlayModel().notifyRemoved(this);
        }
    }

    public int getOffset() {
        return this.myOffsetBeforeDisposal == -1 ? this.getStartOffset() : this.myOffsetBeforeDisposal;
    }

    @NotNull
    public EditorCustomElementRenderer getRenderer() {
        return this.myRenderer;
    }

    public int getWidthInPixels() {
        return this.myWidthInPixels;
    }

    public InlayImpl get() {
        return this;
    }
}

