/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.impl.Interval;
import com.intellij.openapi.editor.impl.IntervalTree;
import com.intellij.openapi.editor.impl.MutableInterval;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.util.Getter;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.WalkingState;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import gnu.trove.TLongHashSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class IntervalTreeImpl<T extends MutableInterval>
extends RedBlackTree<T>
implements IntervalTree<T> {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.RangeMarkerTree");
    static final boolean DEBUG = LOG.isDebugEnabled() || ApplicationManager.getApplication() != null && (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal());
    private int keySize;
    final ReadWriteLock l = new ReentrantReadWriteLock();
    private final ReferenceQueue<T> myReferenceQueue = new ReferenceQueue();
    private int deadReferenceCount;
    private boolean firingBeforeRemove;
    private static final IntervalTreeGuide INTERVAL_TREE_GUIDE_INSTANCE = new IntervalTreeGuide();

    IntervalTreeImpl() {
    }

    protected abstract int compareEqualStartIntervals(@NotNull IntervalNode<T> var1, @NotNull IntervalNode<T> var2);

    private void assertUnderWriteLock() {
        if (DEBUG) assert (IntervalTreeImpl.isAcquired(this.l.writeLock())) : this.l.writeLock();
    }

    private static boolean isAcquired(@NotNull Lock l) {
        String s = l.toString();
        return s.contains("Locked by thread");
    }

    private void pushDeltaFromRoot(@Nullable IntervalNode<T> node) {
        if (node != null) {
            long packedOffsets = ((IntervalNode)node).cachedDeltaUpToRoot;
            if (IntervalNode.allDeltasUpAreNull(packedOffsets) && node.isValid() && IntervalNode.modCount(packedOffsets) == this.modCount) {
                return;
            }
            this.pushDeltaFromRoot((IntervalNode<T>)node.getParent());
            this.pushDelta(node);
        }
    }

    @NotNull
    protected abstract IntervalNode<T> createNewNode(@NotNull T var1, int var2, int var3, boolean var4, boolean var5, int var6);

    protected abstract IntervalNode<T> lookupNode(@NotNull T var1);

    protected abstract void setNode(@NotNull T var1, @Nullable IntervalNode<T> var2);

    private int compareNodes(@NotNull IntervalNode<T> i1, int delta1, @NotNull IntervalNode<T> i2, int delta2, @NotNull List<IntervalNode<T>> invalid) {
        int start2;
        int start1;
        if (!i2.hasAliveKey(false)) {
            invalid.add(i2);
        }
        if ((start1 = i1.intervalStart() + delta1) != (start2 = i2.intervalStart() + delta2)) {
            return start1 - start2;
        }
        return this.compareEqualStartIntervals(i1, i2);
    }

    protected IntervalNode<T> getRoot() {
        return (IntervalNode)this.root;
    }

    @Override
    public boolean process(@NotNull Processor<? super T> processor2) {
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.process(this.getRoot(), this.modCount, processor2);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean process(@Nullable IntervalNode<T> root, int modCountBefore, @NotNull Processor<? super T> processor2) {
        if (root == null) {
            return true;
        }
        WalkingState.TreeGuide<IntervalNode<T>> guide = IntervalTreeImpl.getGuide();
        return WalkingState.processAll(root, guide, node -> {
            if (!node.processAliveKeys(processor2)) {
                return false;
            }
            if (this.modCount != modCountBefore) {
                throw new ConcurrentModificationException();
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processOverlappingWith(int start, int end, @NotNull Processor<? super T> processor2) {
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processOverlappingWith(this.getRoot(), start, end, this.modCount, 0, processor2);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processOverlappingWith(@Nullable IntervalNode<T> root, int start, int end, int modCountBefore, int deltaUpToRootExclusive, @NotNull Processor<? super T> processor2) {
        boolean overlaps;
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (start > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return true;
        }
        if (!this.processOverlappingWith((IntervalNode<T>)root.getLeft(), start, end, modCountBefore, delta, processor2)) {
            return false;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = Math.max(myStartOffset, start) <= Math.min(myEndOffset, end);
        if (overlaps) {
            if (!root.processAliveKeys((Processor<T>)processor2)) {
                return false;
            }
            if (this.modCount != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (end < myStartOffset) {
            return true;
        }
        return this.processOverlappingWith((IntervalNode<T>)root.getRight(), start, end, modCountBefore, delta, processor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processOverlappingWithOutside(int start, int end, @NotNull Processor<? super T> processor2) {
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processOverlappingWithOutside(this.getRoot(), start, end, this.modCount, 0, processor2);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processOverlappingWithOutside(@Nullable IntervalNode<T> root, int start, int end, int modCountBefore, int deltaUpToRootExclusive, @NotNull Processor<? super T> processor2) {
        boolean toProcess;
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        int rootMaxEnd = this.maxEndOf(root, deltaUpToRootExclusive);
        int rootStartOffset = root.intervalStart() + delta;
        int rootEndOffset = root.intervalEnd() + delta;
        if (!this.processOverlappingWithOutside((IntervalNode<T>)root.getLeft(), start, end, modCountBefore, delta, processor2)) {
            return false;
        }
        boolean bl = toProcess = rootStartOffset < start || rootEndOffset > end;
        if (toProcess) {
            if (!root.processAliveKeys((Processor<T>)processor2)) {
                return false;
            }
            if (this.modCount != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (rootStartOffset >= start && rootMaxEnd <= end) {
            return true;
        }
        return this.processOverlappingWithOutside((IntervalNode<T>)root.getRight(), start, end, modCountBefore, delta, processor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processContaining(int offset, @NotNull Processor<? super T> processor2) {
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processContaining(this.getRoot(), offset, this.modCount, 0, processor2);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processContaining(@Nullable IntervalNode<T> root, int offset, int modCountBefore, int deltaUpToRootExclusive, @NotNull Processor<? super T> processor2) {
        boolean overlaps;
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (offset > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return true;
        }
        if (!this.processContaining((IntervalNode<T>)root.getLeft(), offset, modCountBefore, delta, processor2)) {
            return false;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = myStartOffset <= offset && offset < myEndOffset;
        if (overlaps) {
            if (!root.processAliveKeys((Processor<T>)processor2)) {
                return false;
            }
            if (this.modCount != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (offset < myStartOffset) {
            return true;
        }
        return this.processContaining((IntervalNode<T>)root.getRight(), offset, modCountBefore, delta, processor2);
    }

    @NotNull
    private MarkupIterator<T> overlappingIterator(final @NotNull TextRangeInterval rangeInterval) {
        this.l.readLock().lock();
        try {
            final int startOffset = rangeInterval.getStartOffset();
            final int endOffset = rangeInterval.getEndOffset();
            final IntervalNode<T> firstOverlap = this.findMinOverlappingWith(this.getRoot(), rangeInterval, this.modCount, 0);
            if (firstOverlap == null) {
                this.l.readLock().unlock();
                return MarkupIterator.EMPTY;
            }
            final int firstOverlapDelta = firstOverlap.computeDeltaUpToRoot();
            final int firstOverlapStart = firstOverlap.intervalStart() + firstOverlapDelta;
            final int modCountBefore = this.modCount;
            return new MarkupIterator<T>(){
                private IntervalNode<T> currentNode;
                private int deltaUpToRootExclusive;
                private int indexInCurrentList;
                private T current;
                {
                    this.currentNode = firstOverlap;
                    this.deltaUpToRootExclusive = firstOverlapDelta - firstOverlap.delta;
                }

                public boolean hasNext() {
                    MutableInterval t;
                    if (this.current != null) {
                        return true;
                    }
                    if (this.currentNode == null) {
                        return false;
                    }
                    if (IntervalTreeImpl.this.modCount != modCountBefore) {
                        throw new ConcurrentModificationException();
                    }
                    while (this.indexInCurrentList != this.currentNode.intervals.size()) {
                        if ((t = (MutableInterval)this.currentNode.intervals.get(this.indexInCurrentList++).get()) == null) continue;
                        this.current = t;
                        return true;
                    }
                    this.indexInCurrentList = 0;
                    while (true) {
                        this.currentNode = this.nextNode(this.currentNode);
                        if (this.currentNode == null) {
                            return false;
                        }
                        if (!IntervalTreeImpl.this.overlaps(this.currentNode, rangeInterval, this.deltaUpToRootExclusive)) continue;
                        assert (this.currentNode.intervalStart() + this.deltaUpToRootExclusive + this.currentNode.delta >= firstOverlapStart);
                        this.indexInCurrentList = 0;
                        while (this.indexInCurrentList != this.currentNode.intervals.size()) {
                            if ((t = (MutableInterval)this.currentNode.intervals.get(this.indexInCurrentList++).get()) == null) continue;
                            this.current = t;
                            return true;
                        }
                        this.indexInCurrentList = 0;
                    }
                }

                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object t = this.current;
                    this.current = null;
                    return t;
                }

                public T peek() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.current;
                }

                public void remove() {
                    throw new IncorrectOperationException();
                }

                @Override
                public void dispose() {
                    IntervalTreeImpl.this.l.readLock().unlock();
                }

                private IntervalNode<T> nextNode(@NotNull IntervalNode<T> root) {
                    int rightMaxEnd;
                    assert (root.isValid()) : root;
                    int delta = this.deltaUpToRootExclusive + root.delta;
                    int myMaxEnd = IntervalTreeImpl.this.maxEndOf(root, this.deltaUpToRootExclusive);
                    if (startOffset > myMaxEnd) {
                        return null;
                    }
                    RedBlackTree.Node right = root.getRight();
                    if (right != null && startOffset <= (rightMaxEnd = IntervalTreeImpl.this.maxEndOf((IntervalNode)right, delta))) {
                        int rightDelta = delta + ((IntervalNode)right).delta;
                        while (((IntervalNode)right).getLeft() != null && startOffset <= IntervalTreeImpl.this.maxEndOf((IntervalNode)((IntervalNode)right).getLeft(), rightDelta)) {
                            right = ((IntervalNode)right).getLeft();
                            rightDelta += ((IntervalNode)right).delta;
                        }
                        this.deltaUpToRootExclusive = rightDelta - ((IntervalNode)right).delta;
                        return right;
                    }
                    RedBlackTree.Node parent;
                    while ((parent = root.getParent()) != null) {
                        if (((IntervalNode)parent).intervalStart() + this.deltaUpToRootExclusive > endOffset) {
                            return null;
                        }
                        this.deltaUpToRootExclusive -= ((IntervalNode)parent).delta;
                        if (((IntervalNode)parent).getLeft() == root) {
                            return parent;
                        }
                        root = parent;
                    }
                    return null;
                }
            };
        }
        catch (RuntimeException e) {
            this.l.readLock().unlock();
            throw e;
        }
        catch (Error e) {
            this.l.readLock().unlock();
            throw e;
        }
    }

    private boolean overlaps(@Nullable IntervalNode<T> root, @NotNull TextRangeInterval rangeInterval, int deltaUpToRootExclusive) {
        if (root == null) {
            return false;
        }
        int delta = root.delta + deltaUpToRootExclusive;
        int start = root.intervalStart() + delta;
        int end = root.intervalEnd() + delta;
        return rangeInterval.intersects(start, end);
    }

    @NotNull
    IntervalNode<T> findOrInsert(@NotNull IntervalNode<T> node) {
        this.assertUnderWriteLock();
        node.setRed();
        node.setParent(null);
        node.setValid(true);
        node.maxEnd = 0;
        node.clearDelta();
        node.setLeft(null);
        node.setRight(null);
        SmartList gced = new SmartList();
        if (this.root == null) {
            this.root = node;
        } else {
            RedBlackTree.Node current = this.getRoot();
            while (true) {
                this.pushDelta((IntervalNode<T>)current);
                int compResult = this.compareNodes(node, 0, (IntervalNode<T>)current, 0, (List<IntervalNode<T>>)gced);
                if (compResult == 0) {
                    return current;
                }
                if (compResult < 0) {
                    if (current.getLeft() == null) {
                        current.setLeft(node);
                        break;
                    }
                    current = current.getLeft();
                    continue;
                }
                if (current.getRight() == null) {
                    current.setRight(node);
                    break;
                }
                current = current.getRight();
            }
            node.setParent(current);
        }
        ((IntervalNode)node).setCachedValues(0, true, this.modCount);
        this.correctMaxUp(node);
        this.onInsertNode();
        this.keySize += node.intervals.size();
        this.insertCase1(node);
        ((IntervalNode)node).setAttachedToTree(true);
        this.verifyProperties();
        this.deleteNodes((List<IntervalNode<T>>)gced);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNodes(@NotNull List<IntervalNode<T>> collectedAway) {
        if (collectedAway.isEmpty()) {
            return;
        }
        try {
            this.l.writeLock().lock();
            for (IntervalNode<T> node : collectedAway) {
                this.removeNode(node);
            }
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public IntervalNode<T> addInterval(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        try {
            this.l.writeLock().lock();
            if (this.firingBeforeRemove) {
                throw new IncorrectOperationException("Must not add rangemarker from within beforeRemoved listener");
            }
            this.checkMax(true);
            this.processReferenceQueue();
            ++this.modCount;
            IntervalNode<T> newNode = this.createNewNode(interval, start, end, greedyToLeft, greedyToRight, layer);
            IntervalNode<T> insertedNode = this.findOrInsert(newNode);
            if (insertedNode == newNode) {
                this.setNode(interval, insertedNode);
            } else {
                insertedNode.addInterval(interval);
            }
            this.checkMax(true);
            this.checkBelongsToTheTree(interval, true);
            IntervalNode<T> intervalNode = insertedNode;
            return intervalNode;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    boolean checkMax(boolean assertInvalid) {
        return VERIFY && this.doCheckMax(assertInvalid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckMax(boolean assertInvalid) {
        try {
            this.l.readLock().lock();
            AtomicBoolean allValid = new AtomicBoolean(true);
            int[] keyCounter = new int[1];
            int[] nodeCounter = new int[1];
            TLongHashSet ids = new TLongHashSet(this.keySize);
            this.checkMax(this.getRoot(), 0, assertInvalid, allValid, keyCounter, nodeCounter, ids, true);
            if (assertInvalid) {
                assert (this.nodeSize() == nodeCounter[0]) : "node size: " + this.nodeSize() + "; actual: " + nodeCounter[0];
                assert (this.keySize == keyCounter[0]) : "key size: " + this.keySize + "; actual: " + keyCounter[0];
                assert (this.keySize >= this.nodeSize()) : this.keySize + "; " + this.nodeSize();
            }
            boolean bl = allValid.get();
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private IntTrinity checkMax(@Nullable IntervalNode<T> root, int deltaUpToRootExclusive, boolean assertInvalid, @NotNull AtomicBoolean allValid, @NotNull int[] keyCounter, @NotNull int[] nodeCounter, @NotNull TLongHashSet ids, boolean allDeltasUpAreNull) {
        if (root == null) {
            return new IntTrinity(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        long packedOffsets = ((IntervalNode)root).cachedDeltaUpToRoot;
        if (IntervalNode.modCount(packedOffsets) == this.modCount) {
            assert (IntervalNode.allDeltasUpAreNull(packedOffsets) == (root.delta == 0 && allDeltasUpAreNull));
            assert (IntervalNode.deltaUpToRoot(packedOffsets) == root.delta + deltaUpToRootExclusive);
        }
        MutableInterval liveInterval = null;
        for (int i2 = root.intervals.size() - 1; i2 >= 0; --i2) {
            MutableInterval t = (MutableInterval)root.intervals.get(i2).get();
            if (t == null) continue;
            liveInterval = t;
            this.checkBelongsToTheTree(t, false);
            boolean added = ids.add(((RangeMarkerImpl)t).getId());
            assert (added) : t;
        }
        if (assertInvalid && liveInterval != null) {
            this.checkBelongsToTheTree(liveInterval, true);
        }
        keyCounter[0] = keyCounter[0] + root.intervals.size();
        nodeCounter[0] = nodeCounter[0] + 1;
        int delta = deltaUpToRootExclusive + (root.isValid() ? root.delta : 0);
        IntTrinity l = this.checkMax((IntervalNode<T>)root.getLeft(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int minLeftStart = l.first;
        int maxLeftStart = l.second;
        int maxLeftEnd = l.third;
        IntTrinity r = this.checkMax((IntervalNode<T>)root.getRight(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int maxRightEnd = r.third;
        int minRightStart = r.first;
        int maxRightStart = r.second;
        if (!root.isValid()) {
            allValid.set(false);
            if (assertInvalid) assert (false) : root;
            return new IntTrinity(Math.min(minLeftStart, minRightStart), Math.max(maxLeftStart, maxRightStart), Math.max(maxRightEnd, maxLeftEnd));
        }
        RedBlackTree.Node parent = root.getParent();
        if (parent != null && assertInvalid && root.hasAliveKey(false)) {
            int c = this.compareNodes(root, delta, (IntervalNode<T>)parent, delta - root.delta, (List<IntervalNode<T>>)new SmartList());
            assert (c != 0);
            assert (c < 0 && ((IntervalNode)parent).getLeft() == root || c > 0 && ((IntervalNode)parent).getRight() == root);
        }
        assert (delta + root.maxEnd == Math.max(maxLeftEnd, Math.max(maxRightEnd, delta + root.intervalEnd())));
        int myStartOffset = delta + root.intervalStart();
        assert (maxLeftStart <= myStartOffset);
        assert (minRightStart >= myStartOffset);
        assert (myStartOffset >= 0);
        assert (minLeftStart == Integer.MAX_VALUE || minLeftStart <= myStartOffset);
        assert (maxRightStart == Integer.MIN_VALUE || maxRightStart >= myStartOffset);
        int minStart = Math.min(minLeftStart, myStartOffset);
        int maxStart = Math.max(myStartOffset, Math.max(maxLeftStart, maxRightStart));
        assert (minStart <= maxStart);
        return new IntTrinity(minStart, maxStart, root.maxEnd + delta);
    }

    @Override
    @NotNull
    protected RedBlackTree.Node<T> maximumNode(@NotNull RedBlackTree.Node<T> n) {
        RedBlackTree.Node root = (IntervalNode)n;
        this.pushDelta((IntervalNode<T>)root.getParent());
        this.pushDelta((IntervalNode<T>)root);
        while (root.getRight() != null) {
            root = root.getRight();
            this.pushDelta((IntervalNode<T>)root);
        }
        return root;
    }

    protected void checkBelongsToTheTree(@NotNull T interval, boolean assertInvalid) {
        IntervalNode<T> root = this.lookupNode(interval);
        if (root == null) {
            return;
        }
        assert (root.getTree() == this) : root.getTree() + "; this: " + this;
        if (!VERIFY) {
            return;
        }
        if (assertInvalid) {
            assert (!root.intervals.isEmpty());
            boolean contains = false;
            for (int i2 = root.intervals.size() - 1; i2 >= 0; --i2) {
                MutableInterval key2 = (MutableInterval)root.intervals.get(i2).get();
                if (key2 == null) continue;
                contains |= key2 == interval;
                IntervalNode<MutableInterval> node = this.lookupNode(key2);
                assert (node == root) : node;
                assert (node.getTree() == this) : node;
            }
            assert (contains) : root.intervals + "; " + interval;
        }
        RedBlackTree.Node e = root;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        assert (e == this.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeInterval(@NotNull T interval) {
        if (!interval.isValid()) {
            return false;
        }
        try {
            this.l.writeLock().lock();
            ++this.modCount;
            if (!interval.isValid()) {
                boolean bl = false;
                return bl;
            }
            this.checkBelongsToTheTree(interval, true);
            this.checkMax(true);
            this.processReferenceQueue();
            IntervalNode<T> node = this.lookupNode(interval);
            if (node == null) {
                boolean bl = false;
                return bl;
            }
            this.beforeRemove(interval, "Explicit Dispose");
            ((IntervalNode)node).removeInterval(interval);
            this.setNode(interval, null);
            this.checkMax(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    void removeNode(@NotNull IntervalNode<T> node) {
        this.deleteNode((RedBlackTree.Node<T>)node);
        RedBlackTree.Node parent = node.getParent();
        this.correctMaxUp((IntervalNode<T>)parent);
    }

    @Override
    protected void deleteNode(@NotNull RedBlackTree.Node<T> n) {
        this.assertUnderWriteLock();
        IntervalNode node = (IntervalNode)n;
        this.pushDeltaFromRoot(node);
        this.assertAllDeltasAreNull(node);
        super.deleteNode(n);
        this.keySize -= node.intervals.size();
        assert (this.keySize >= 0) : this.keySize;
        node.setAttachedToTree(false);
    }

    @Override
    public int size() {
        return this.keySize;
    }

    boolean pushDelta(@Nullable IntervalNode<T> root) {
        if (root == null || !root.isValid()) {
            return true;
        }
        RedBlackTree.Node parent = root.getParent();
        this.assertAllDeltasAreNull((IntervalNode<T>)parent);
        int delta = root.delta;
        ((IntervalNode)root).setCachedValues(0, true, 0);
        if (delta != 0) {
            root.setIntervalStart(root.intervalStart() + delta);
            root.setIntervalEnd(root.intervalEnd() + delta);
            root.maxEnd += delta;
            root.delta = 0;
            return this.incDelta((IntervalNode<T>)root.getLeft(), delta) & this.incDelta((IntervalNode<T>)root.getRight(), delta);
        }
        ((IntervalNode)root).setCachedValues(0, true, this.modCount);
        return true;
    }

    private boolean incDelta(@Nullable IntervalNode<T> root, int delta) {
        if (root == null) {
            return true;
        }
        if (root.isValid()) {
            int newDelta = root.changeDelta(delta);
            return newDelta == 0;
        }
        return this.incDelta((IntervalNode<T>)root.getLeft(), delta) & this.incDelta((IntervalNode<T>)root.getRight(), delta);
    }

    @Override
    @NotNull
    protected IntervalNode<T> swapWithMaxPred(@NotNull RedBlackTree.Node<T> root, @NotNull RedBlackTree.Node<T> maxPred) {
        this.checkMax(false);
        IntervalNode a = (IntervalNode)root;
        IntervalNode d = (IntervalNode)maxPred;
        boolean acolor = a.isBlack();
        boolean dcolor = d.isBlack();
        assert (!a.isValid() || a.delta == 0) : a.delta;
        for (RedBlackTree.Node n = a.getLeft(); n != null; n = ((IntervalNode)n).getRight()) {
            assert (!((IntervalNode)n).isValid() || ((IntervalNode)n).delta == 0) : ((IntervalNode)n).delta;
        }
        this.swapNodes(a, d);
        a.setValid(false);
        a.setColor(dcolor);
        d.setColor(acolor);
        this.correctMaxUp(a);
        this.checkMax(false);
        assert (a.delta == 0) : a.delta;
        assert (d.delta == 0) : d.delta;
        return a;
    }

    private void swapNodes(@NotNull IntervalNode<T> n1, @NotNull IntervalNode<T> n2) {
        RedBlackTree.Node l1 = n1.getLeft();
        RedBlackTree.Node r1 = n1.getRight();
        IntervalNode<T> p1 = n1.getParent();
        IntervalNode<T> l2 = n2.getLeft();
        IntervalNode<T> r2 = n2.getRight();
        RedBlackTree.Node p2 = n2.getParent();
        if (p1 != null) {
            if (p1.getLeft() == n1) {
                p1.setLeft(n2);
            } else {
                p1.setRight(n2);
            }
        } else {
            this.root = n2;
        }
        if (p2 != null) {
            if (((IntervalNode)p2).getLeft() == n2) {
                p2.setLeft(p2 == n1 ? l2 : n1);
            } else {
                p2.setRight(p2 == n1 ? r2 : n1);
            }
        } else {
            this.root = n1;
        }
        n1.setParent(p2 == n1 ? n2 : p2);
        n2.setParent(p1);
        n1.setLeft(l2);
        n2.setLeft(l1 == n2 ? n1 : l1);
        if (l1 != null) {
            l1.setParent(n2 == l1 ? p1 : n2);
        }
        if (r1 != null) {
            r1.setParent(n2);
        }
        n1.setRight(r2);
        n2.setRight(r1);
        if (l2 != null) {
            l2.setParent(n1);
        }
        if (r2 != null) {
            r2.setParent(n1);
        }
    }

    private int maxEndOf(@Nullable IntervalNode<T> node, int deltaUpToRootExclusive) {
        if (node == null) {
            return 0;
        }
        if (node.isValid()) {
            return node.maxEnd + node.delta + deltaUpToRootExclusive;
        }
        return Math.max(this.maxEndOf((IntervalNode<T>)node.getLeft(), deltaUpToRootExclusive), this.maxEndOf((IntervalNode<T>)node.getRight(), deltaUpToRootExclusive));
    }

    void correctMax(@NotNull IntervalNode<T> node, int deltaUpToRoot) {
        if (!node.isValid()) {
            return;
        }
        int realMax = Math.max(Math.max(this.maxEndOf((IntervalNode<T>)node.getLeft(), deltaUpToRoot), this.maxEndOf((IntervalNode<T>)node.getRight(), deltaUpToRoot)), deltaUpToRoot + node.intervalEnd());
        node.maxEnd = realMax - deltaUpToRoot;
    }

    private void correctMaxUp(@Nullable IntervalNode<T> node) {
        int delta;
        int n = delta = node == null ? 0 : node.computeDeltaUpToRoot();
        assert (delta == 0) : delta;
        while (node != null) {
            if (node.isValid()) {
                int d = node.delta;
                this.correctMax((IntervalNode<T>)node, delta);
                delta -= d;
            }
            node = node.getParent();
        }
        assert (delta == 0) : delta;
    }

    @Override
    protected void rotateRight(@NotNull RedBlackTree.Node<T> n) {
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        super.rotateRight(node1);
        if (node3 != null) {
            this.correctMax((IntervalNode<T>)node3, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node2, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        this.checkMax(false);
    }

    @Override
    protected void rotateLeft(@NotNull RedBlackTree.Node<T> n) {
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        this.checkMax(false);
        super.rotateLeft(node1);
        if (node2 != null) {
            this.correctMax((IntervalNode<T>)node2, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node3, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        this.checkMax(false);
    }

    @Override
    protected void replaceNode(@NotNull RedBlackTree.Node<T> node, RedBlackTree.Node<T> child) {
        IntervalNode myNode = (IntervalNode)node;
        this.pushDelta(myNode);
        this.pushDelta((IntervalNode)child);
        super.replaceNode(node, child);
        if (child != null && myNode.isValid()) {
            ((IntervalNode)child).changeDelta(myNode.delta);
        }
    }

    private void assertAllDeltasAreNull(@Nullable IntervalNode<T> node) {
        if (node == null) {
            return;
        }
        if (!node.isValid()) {
            return;
        }
        assert (node.delta == 0);
        long packedOffsets = ((IntervalNode)node).cachedDeltaUpToRoot;
        assert (IntervalNode.modCount(packedOffsets) != this.modCount || IntervalNode.allDeltasUpAreNull(packedOffsets));
    }

    private IntervalNode<T> findMinOverlappingWith(@Nullable IntervalNode<T> root, @NotNull Interval interval, int modCountBefore, int deltaUpToRootExclusive) {
        boolean overlaps;
        if (root == null) {
            return null;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (interval.intervalStart() > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return null;
        }
        IntervalNode<T> inLeft = this.findMinOverlappingWith((IntervalNode<T>)root.getLeft(), interval, modCountBefore, delta);
        if (inLeft != null) {
            return inLeft;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = Math.max(myStartOffset, interval.intervalStart()) <= Math.min(myEndOffset, interval.intervalEnd());
        if (overlaps) {
            return root;
        }
        if (this.modCount != modCountBefore) {
            throw new ConcurrentModificationException();
        }
        if (interval.intervalEnd() < myStartOffset) {
            return null;
        }
        return this.findMinOverlappingWith((IntervalNode<T>)root.getRight(), interval, modCountBefore, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeData(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        try {
            this.l.writeLock().lock();
            IntervalNode<T> node = this.lookupNode(interval);
            if (node == null) {
                return;
            }
            int before = this.size();
            boolean nodeRemoved = ((IntervalNode)node).removeInterval(interval);
            assert (nodeRemoved || !node.intervals.isEmpty());
            IntervalNode<T> insertedNode = this.addInterval(interval, start, end, greedyToLeft, greedyToRight, layer);
            assert (node != insertedNode);
            int after2 = this.size();
            assert (before >= after2) : before + ";" + after2;
            this.checkBelongsToTheTree(interval, true);
            this.checkMax(true);
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void processReferenceQueue() {
        int dead = 0;
        while (this.myReferenceQueue.poll() != null) {
            ++dead;
        }
        this.deadReferenceCount += dead;
        if (this.deadReferenceCount > Math.max(1, this.size() / 3)) {
            this.purgeDeadNodes();
            this.deadReferenceCount = 0;
        }
    }

    private void purgeDeadNodes() {
        this.assertUnderWriteLock();
        SmartList gced = new SmartList();
        this.collectGced(this.getRoot(), (List<IntervalNode<T>>)gced);
        this.deleteNodes((List<IntervalNode<T>>)gced);
        this.checkMax(true);
    }

    @Override
    public void clear() {
        this.l.writeLock().lock();
        this.process(t -> {
            this.beforeRemove(t, "Clear all");
            return true;
        });
        try {
            super.clear();
            this.keySize = 0;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void collectGced(@Nullable IntervalNode<T> root, @NotNull List<IntervalNode<T>> gced) {
        if (root == null) {
            return;
        }
        if (!root.hasAliveKey(true)) {
            gced.add(root);
        }
        this.collectGced((IntervalNode<T>)root.getLeft(), gced);
        this.collectGced((IntervalNode<T>)root.getRight(), gced);
    }

    private void printSorted() {
        this.printSorted(this.getRoot());
    }

    private void printSorted(@Nullable IntervalNode<T> root) {
        if (root == null) {
            return;
        }
        this.printSorted((IntervalNode<T>)root.getLeft());
        System.out.println(root);
        this.printSorted((IntervalNode<T>)root.getRight());
    }

    void fireBeforeRemoved(@NotNull T markerEx, @NotNull @NonNls Object reason) {
    }

    void beforeRemove(@NotNull T markerEx, @NonNls @NotNull Object reason) {
        if (this.firingBeforeRemove) {
            throw new IllegalStateException();
        }
        this.firingBeforeRemove = true;
        try {
            this.fireBeforeRemoved(markerEx, reason);
        }
        finally {
            this.firingBeforeRemove = false;
        }
    }

    @NotNull
    private static <T extends MutableInterval> WalkingState.TreeGuide<IntervalNode<T>> getGuide() {
        return INTERVAL_TREE_GUIDE_INSTANCE;
    }

    public int maxHeight() {
        return this.maxHeight(this.root);
    }

    private int maxHeight(@Nullable RedBlackTree.Node<T> root) {
        return root == null ? 0 : 1 + Math.max(this.maxHeight(root.left), this.maxHeight(root.right));
    }

    @NotNull
    static <T extends MutableInterval> MarkupIterator<T> mergingOverlappingIterator(@NotNull IntervalTreeImpl<T> tree1, @NotNull TextRangeInterval tree1Range, @NotNull IntervalTreeImpl<T> tree2, @NotNull TextRangeInterval tree2Range, @NotNull Comparator<? super T> comparator2) {
        MarkupIterator<T> exact = super.overlappingIterator(tree1Range);
        MarkupIterator<T> lines = super.overlappingIterator(tree2Range);
        return IntervalTreeImpl.mergeIterators(exact, lines, comparator2);
    }

    @NotNull
    static <T extends MutableInterval> MarkupIterator<T> mergeIterators(final @NotNull MarkupIterator<T> iterator1, final @NotNull MarkupIterator<T> iterator2, final @NotNull Comparator<? super T> comparator2) {
        return new MarkupIterator<T>(){

            @Override
            public void dispose() {
                iterator1.dispose();
                iterator2.dispose();
            }

            public boolean hasNext() {
                return iterator1.hasNext() || iterator2.hasNext();
            }

            public T next() {
                return (MutableInterval)this.choose().next();
            }

            @NotNull
            private MarkupIterator<T> choose() {
                MutableInterval t2;
                MutableInterval t1 = iterator1.hasNext() ? (MutableInterval)iterator1.peek() : null;
                MutableInterval mutableInterval = t2 = iterator2.hasNext() ? (MutableInterval)iterator2.peek() : null;
                if (t1 == null) {
                    return iterator2;
                }
                if (t2 == null) {
                    return iterator1;
                }
                int compare = comparator2.compare(t1, t2);
                return compare < 0 ? iterator1 : iterator2;
            }

            public void remove() {
                throw new NoSuchElementException();
            }

            public T peek() {
                return (MutableInterval)this.choose().peek();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T findRangeMarkerAfter(@NotNull T marker) {
        this.l.readLock().lock();
        try {
            boolean foundMarker = false;
            for (IntervalNode<T> node = this.lookupNode(marker); node != null; node = node.next()) {
                List intervals = node.intervals;
                for (int i2 = 0; i2 < intervals.size(); ++i2) {
                    Getter interval = intervals.get(i2);
                    MutableInterval m = (MutableInterval)interval.get();
                    if (m == null) continue;
                    if (m == marker) {
                        foundMarker = true;
                        continue;
                    }
                    if (!foundMarker) continue;
                    MutableInterval mutableInterval = m;
                    return (T)mutableInterval;
                }
                foundMarker = true;
            }
            T t = null;
            return t;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T findRangeMarkerBefore(@NotNull T marker) {
        this.l.readLock().lock();
        try {
            boolean foundMarker = false;
            for (IntervalNode<T> node = this.lookupNode(marker); node != null; node = node.previous()) {
                List intervals = node.intervals;
                for (int i2 = intervals.size() - 1; i2 >= 0; --i2) {
                    Getter interval = intervals.get(i2);
                    MutableInterval m = (MutableInterval)interval.get();
                    if (m == null) continue;
                    if (m == marker) {
                        foundMarker = true;
                        continue;
                    }
                    if (!foundMarker) continue;
                    MutableInterval mutableInterval = m;
                    return (T)mutableInterval;
                }
                foundMarker = true;
            }
            T t = null;
            return t;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private static class IntervalTreeGuide<T extends MutableInterval>
    implements WalkingState.TreeGuide<IntervalNode<T>> {
        private IntervalTreeGuide() {
        }

        public IntervalNode<T> getNextSibling(@NotNull IntervalNode<T> element) {
            RedBlackTree.Node parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return ((IntervalNode)parent).getLeft() == element ? ((IntervalNode)parent).getRight() : null;
        }

        public IntervalNode<T> getPrevSibling(@NotNull IntervalNode<T> element) {
            RedBlackTree.Node parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return ((IntervalNode)parent).getRight() == element ? ((IntervalNode)parent).getLeft() : null;
        }

        public IntervalNode<T> getFirstChild(@NotNull IntervalNode<T> element) {
            RedBlackTree.Node left = element.getLeft();
            return left == null ? element.getRight() : left;
        }

        public IntervalNode<T> getParent(@NotNull IntervalNode<T> element) {
            return element.getParent();
        }
    }

    private static class IntTrinity {
        private final int first;
        private final int second;
        private final int third;

        private IntTrinity(int first, int second, int third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }
    }

    static class IntervalNode<E extends MutableInterval>
    extends RedBlackTree.Node<E>
    implements MutableInterval {
        private volatile int myStart;
        private volatile int myEnd;
        private static final byte ATTACHED_TO_TREE_FLAG = 2;
        final List<Getter<E>> intervals;
        int maxEnd;
        int delta;
        private volatile long cachedDeltaUpToRoot;
        @NotNull
        private final IntervalTreeImpl<E> myIntervalTree;
        static final byte VALID_FLAG = 4;
        private static final AtomicFieldUpdater<IntervalNode, Long> cachedDeltaUpdater = AtomicFieldUpdater.forLongFieldIn(IntervalNode.class);

        IntervalNode(@NotNull IntervalTreeImpl<E> intervalTree, @NotNull E key2, int start, int end) {
            this.myIntervalTree = intervalTree;
            this.myStart = start;
            this.myEnd = end;
            this.intervals = new SmartList(this.createGetter(key2));
            this.setValid(true);
        }

        @Override
        public IntervalNode<E> getLeft() {
            return (IntervalNode)this.left;
        }

        @Override
        public IntervalNode<E> getRight() {
            return (IntervalNode)this.right;
        }

        @Override
        public IntervalNode<E> getParent() {
            return (IntervalNode)this.parent;
        }

        @Override
        public boolean processAliveKeys(@NotNull Processor<? super E> processor2) {
            for (int i2 = 0; i2 < this.intervals.size(); ++i2) {
                Getter<E> interval = this.intervals.get(i2);
                MutableInterval key2 = (MutableInterval)interval.get();
                if (key2 == null || processor2.process((Object)key2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean hasAliveKey(boolean purgeDead) {
            boolean hasAliveInterval = false;
            for (int i2 = this.intervals.size() - 1; i2 >= 0; --i2) {
                Getter<E> interval = this.intervals.get(i2);
                if (interval.get() != null) {
                    hasAliveInterval = true;
                    if (!purgeDead) break;
                    continue;
                }
                if (!purgeDead) continue;
                ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
                this.removeIntervalInternal(i2);
            }
            return hasAliveInterval;
        }

        private boolean removeInterval(@NotNull E key2) {
            this.myIntervalTree.checkBelongsToTheTree(key2, true);
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            for (int i2 = this.intervals.size() - 1; i2 >= 0; --i2) {
                Getter<E> interval = this.intervals.get(i2);
                MutableInterval t = (MutableInterval)interval.get();
                if (t != key2) continue;
                this.removeIntervalInternal(i2);
                if (this.intervals.isEmpty()) {
                    this.myIntervalTree.removeNode(this);
                    return true;
                }
                return false;
            }
            assert (false) : "interval not found: " + key2 + "; " + this.intervals + "; isValid=" + key2.isValid();
            return false;
        }

        private boolean isAttachedToTree() {
            return this.isFlagSet((byte)2);
        }

        private void setAttachedToTree(boolean attached) {
            this.setFlag((byte)2, attached);
        }

        void removeIntervalInternal(int i2) {
            this.intervals.remove(i2);
            if (this.isAttachedToTree()) {
                assert (((IntervalTreeImpl)this.myIntervalTree).keySize > 0) : IntervalTreeImpl.access$100(this.myIntervalTree);
                ((IntervalTreeImpl)this.myIntervalTree).keySize--;
            }
        }

        void addInterval(@NotNull E interval) {
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            this.intervals.add(this.createGetter(interval));
            if (this.isAttachedToTree()) {
                ((IntervalTreeImpl)this.myIntervalTree).keySize++;
                this.myIntervalTree.setNode(interval, this);
            }
        }

        protected Getter<E> createGetter(@NotNull E interval) {
            return new WeakReferencedGetter(interval, ((IntervalTreeImpl)this.myIntervalTree).myReferenceQueue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int computeDeltaUpToRoot() {
            block7: while (this.isValid()) {
                int treeModCount = this.myIntervalTree.modCount;
                long packedOffsets = this.cachedDeltaUpToRoot;
                if (IntervalNode.modCount(packedOffsets) == treeModCount) {
                    return IntervalNode.deltaUpToRoot(packedOffsets);
                }
                try {
                    boolean allDeltasAreNull;
                    int deltaUp;
                    block17: {
                        this.myIntervalTree.l.readLock().lock();
                        RedBlackTree.Node node = this;
                        IntervalNode<E> treeRoot = this.myIntervalTree.getRoot();
                        if (treeRoot == null) {
                            int n = this.delta;
                            return n;
                        }
                        deltaUp = 0;
                        allDeltasAreNull = true;
                        int height = 0;
                        long path = 0L;
                        while (node != treeRoot) {
                            long nodePackedOffsets = ((IntervalNode)node).cachedDeltaUpToRoot;
                            if (((IntervalNode)node).isValid() && IntervalNode.modCount(nodePackedOffsets) == treeModCount) {
                                deltaUp = IntervalNode.deltaUpToRoot(nodePackedOffsets) - ((IntervalNode)node).delta;
                                allDeltasAreNull = IntervalNode.allDeltasUpAreNull(nodePackedOffsets);
                                break;
                            }
                            RedBlackTree.Node parent = ((IntervalNode)node).getParent();
                            if (parent == null) {
                                int n = deltaUp;
                                return n;
                            }
                            path = path << 1 | (long)(((IntervalNode)parent).getLeft() == node ? 0 : 1);
                            node = parent;
                            ++height;
                        }
                        assert (height < 63) : height;
                        do {
                            int nodeDelta;
                            if (((IntervalNode)node).isValid() && !((IntervalNode)node).tryToSetCachedValues(deltaUp += (nodeDelta = ((IntervalNode)node).delta), allDeltasAreNull &= nodeDelta == 0, treeModCount)) continue block7;
                            if (node == this) break block17;
                            node = (path & 1L) == 0L ? ((IntervalNode)node).getLeft() : ((IntervalNode)node).getRight();
                            path >>= 1;
                        } while (node != null);
                        int n = deltaUp;
                        return n;
                    }
                    assert (deltaUp == 0 || !allDeltasAreNull);
                    int n = deltaUp;
                    return n;
                }
                finally {
                    this.myIntervalTree.l.readLock().unlock();
                    continue;
                }
                break;
            }
            return 0;
        }

        int changeDelta(int change) {
            if (change != 0) {
                this.setCachedValues(0, false, 0);
                return this.delta += change;
            }
            return this.delta;
        }

        void clearDelta() {
            if (this.delta != 0) {
                this.setCachedValues(0, false, 0);
                this.delta = 0;
            }
        }

        @Override
        public int setIntervalStart(int start) {
            this.myStart = start;
            return this.myStart;
        }

        @Override
        public int setIntervalEnd(int end) {
            this.myEnd = end;
            return this.myEnd;
        }

        @Override
        public boolean isValid() {
            return this.isFlagSet((byte)4);
        }

        @Override
        public boolean setValid(boolean value2) {
            this.setFlag((byte)4, value2);
            return value2;
        }

        @Override
        public int intervalStart() {
            return this.myStart;
        }

        @Override
        public int intervalEnd() {
            return this.myEnd;
        }

        @NotNull
        public IntervalTreeImpl<E> getTree() {
            return this.myIntervalTree;
        }

        private void setCachedValues(int deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            this.cachedDeltaUpToRoot = IntervalNode.packValues(deltaUpToRoot, allDeltaUpToRootAreNull, modCount);
        }

        private static long packValues(long deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            return deltaUpToRoot << 33 | (allDeltaUpToRootAreNull ? 0x100000000L : 0L) | (long)modCount;
        }

        private boolean tryToSetCachedValues(int deltaUpToRoot, boolean allDeltasUpAreNull, int treeModCount) {
            if (this.myIntervalTree.modCount != treeModCount) {
                return false;
            }
            long newValue = IntervalNode.packValues(deltaUpToRoot, allDeltasUpAreNull, treeModCount);
            long oldValue = this.cachedDeltaUpToRoot;
            return cachedDeltaUpdater.compareAndSetLong((Object)this, oldValue, newValue);
        }

        private static boolean allDeltasUpAreNull(long packedOffsets) {
            return (packedOffsets >> 32 & 1L) != 0L;
        }

        private static int modCount(long packedOffsets) {
            return (int)packedOffsets;
        }

        private static int deltaUpToRoot(long packedOffsets) {
            return (int)(packedOffsets >> 33);
        }

        IntervalNode<E> previous() {
            RedBlackTree.Node parent;
            RedBlackTree.Node left = this.getLeft();
            if (left != null) {
                while (((IntervalNode)left).getRight() != null) {
                    left = ((IntervalNode)left).getRight();
                }
                return left;
            }
            RedBlackTree.Node prev = this;
            for (parent = this.getParent(); parent != null && ((IntervalNode)parent).getRight() != prev; parent = ((IntervalNode)parent).getParent()) {
                prev = parent;
            }
            return parent;
        }

        IntervalNode<E> next() {
            RedBlackTree.Node parent;
            RedBlackTree.Node right = this.getRight();
            if (right != null) {
                while (((IntervalNode)right).getLeft() != null) {
                    right = ((IntervalNode)right).getLeft();
                }
                return right;
            }
            RedBlackTree.Node prev = this;
            for (parent = this.getParent(); parent != null && ((IntervalNode)parent).getLeft() != prev; parent = ((IntervalNode)parent).getParent()) {
                prev = parent;
            }
            return parent;
        }

        @NonNls
        public String toString() {
            return "Node: " + this.intervals;
        }

        private static class WeakReferencedGetter<T>
        extends WeakReference<T>
        implements Getter<T> {
            private WeakReferencedGetter(@NotNull T referent, @NotNull ReferenceQueue<? super T> q) {
                super(referent, q);
            }

            @NonNls
            public String toString() {
                return "Ref: " + this.get();
            }
        }
    }
}

