/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.PersistentRangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.BitUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkupModelImpl
extends UserDataHolderBase
implements MarkupModelEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.MarkupModelImpl");
    private final DocumentEx myDocument;
    private RangeHighlighter[] myCachedHighlighters;
    private final List<MarkupModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final RangeHighlighterTree myHighlighterTree;
    private final RangeHighlighterTree myHighlighterTreeForLines;

    MarkupModelImpl(@NotNull DocumentEx document) {
        this.myDocument = document;
        this.myHighlighterTree = new RangeHighlighterTree(document, this);
        this.myHighlighterTreeForLines = new RangeHighlighterTree(document, this);
    }

    @Override
    public void dispose() {
        this.myHighlighterTree.dispose();
        this.myHighlighterTreeForLines.dispose();
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        if (this.isNotValidLine(lineNumber)) {
            throw new IndexOutOfBoundsException("lineNumber:" + lineNumber + ". Must be in [0, " + (this.getDocument().getLineCount() - 1) + "]");
        }
        int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), lineNumber);
        return this.addRangeHighlighter(offset, offset, layer, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        if (this.isNotValidLine(lineNumber)) {
            return null;
        }
        int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), lineNumber);
        return this.addRangeHighlighter(PersistentRangeHighlighterImpl.create(this, offset, layer, HighlighterTargetArea.LINES_IN_RANGE, textAttributes, false), null);
    }

    private boolean isNotValidLine(int lineNumber) {
        return lineNumber >= this.getDocument().getLineCount() || lineNumber < 0;
    }

    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCachedHighlighters == null) {
            int size = this.myHighlighterTree.size() + this.myHighlighterTreeForLines.size();
            if (size == 0) {
                return RangeHighlighter.EMPTY_ARRAY;
            }
            ArrayList list = new ArrayList(size);
            CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor(list);
            this.myHighlighterTree.process((Processor)collectProcessor);
            this.myHighlighterTreeForLines.process((Processor)collectProcessor);
            this.myCachedHighlighters = list.toArray(new RangeHighlighter[list.size()]);
        }
        return this.myCachedHighlighters;
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, @Nullable Consumer<RangeHighlighterEx> changeAttributesAction) {
        return this.addRangeHighlighter(isPersistent ? PersistentRangeHighlighterImpl.create(this, startOffset, layer, targetArea, textAttributes, true) : new RangeHighlighterImpl(this, startOffset, endOffset, layer, targetArea, textAttributes, false, false), changeAttributesAction);
    }

    @NotNull
    private RangeHighlighterEx addRangeHighlighter(@NotNull RangeHighlighterImpl highlighter, @Nullable Consumer<RangeHighlighterEx> changeAttributesAction) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCachedHighlighters = null;
        if (changeAttributesAction != null) {
            highlighter.changeAttributesNoEvents(changeAttributesAction);
        }
        this.fireAfterAdded(highlighter);
        return highlighter;
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<RangeHighlighterEx> changeAttributesAction) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        byte changeStatus = ((RangeHighlighterImpl)highlighter).changeAttributesNoEvents(changeAttributesAction);
        if (BitUtil.isSet((byte)changeStatus, (byte)16)) {
            this.fireAttributesChanged(highlighter, BitUtil.isSet((byte)changeStatus, (byte)32), BitUtil.isSet((byte)changeStatus, (byte)64));
        }
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.treeFor(marker).addInterval(marker, start, end, greedyToLeft, greedyToRight, layer);
    }

    private RangeHighlighterTree treeFor(RangeHighlighter marker) {
        return marker.getTargetArea() == HighlighterTargetArea.EXACT_RANGE ? this.myHighlighterTree : this.myHighlighterTreeForLines;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        return this.addRangeHighlighterAndChangeAttributes(startOffset, endOffset, layer, textAttributes, targetArea, false, null);
    }

    public void removeHighlighter(@NotNull RangeHighlighter segmentHighlighter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCachedHighlighters = null;
        if (!segmentHighlighter.isValid()) {
            return;
        }
        boolean removed = this.treeFor(segmentHighlighter).removeInterval((RangeHighlighterEx)segmentHighlighter);
        LOG.assertTrue(removed);
    }

    public void removeAllHighlighters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (RangeHighlighter highlighter : this.getAllHighlighters()) {
            highlighter.dispose();
        }
        this.myCachedHighlighters = null;
        this.myHighlighterTree.clear();
        this.myHighlighterTreeForLines.clear();
    }

    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener2) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeMarkupModelListener(listener2));
    }

    private void removeMarkupModelListener(@NotNull MarkupModelListener listener2) {
        boolean success = this.myListeners.remove(listener2);
        LOG.assertTrue(success);
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((RangeHighlighterEx)highlighter).setTextAttributes(textAttributes);
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
        for (MarkupModelListener listener2 : this.myListeners) {
            listener2.attributesChanged(segmentHighlighter, renderersChanged, fontStyleOrColorChanged);
        }
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        for (MarkupModelListener listener2 : this.myListeners) {
            listener2.afterAdded(segmentHighlighter);
        }
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        for (MarkupModelListener listener2 : this.myListeners) {
            listener2.beforeRemoved(segmentHighlighter);
        }
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Processor equalId = h -> h.getId() != ((RangeHighlighterEx)highlighter).getId();
        return !this.treeFor(highlighter).processOverlappingWith(highlighter.getStartOffset(), highlighter.getEndOffset(), equalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRangeHighlightersOverlappingWith(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        MarkupIterator<RangeHighlighterEx> iterator = this.overlappingIterator(start, end);
        try {
            while (iterator.hasNext()) {
                if (processor2.process(iterator.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            iterator.dispose();
        }
    }

    @Override
    public boolean processRangeHighlightersOutside(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        return this.myHighlighterTree.processOverlappingWithOutside(start, end, processor2) && this.myHighlighterTreeForLines.processOverlappingWithOutside(start, end, processor2);
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        startOffset = Math.max(0, startOffset);
        endOffset = Math.max(startOffset, endOffset);
        return IntervalTreeImpl.mergingOverlappingIterator(this.myHighlighterTree, new TextRangeInterval(startOffset, endOffset), this.myHighlighterTreeForLines, MarkupModelImpl.roundToLineBoundaries(this.getDocument(), startOffset, endOffset), RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
    }

    @NotNull
    public static TextRangeInterval roundToLineBoundaries(@NotNull Document document, int startOffset, int endOffset) {
        int lineStartOffset;
        int textLength = document.getTextLength();
        int n = startOffset <= 0 ? 0 : (lineStartOffset = startOffset > textLength ? textLength : document.getLineStartOffset(document.getLineNumber(startOffset)));
        int lineEndOffset = endOffset <= 0 ? 0 : (endOffset >= textLength ? textLength : document.getLineEndOffset(document.getLineNumber(endOffset)));
        return new TextRangeInterval(lineStartOffset, lineEndOffset);
    }
}

