/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.Getter;
import org.jetbrains.annotations.NotNull;

class RangeHighlighterTree
extends RangeMarkerTree<RangeHighlighterEx> {
    private final MarkupModelEx myMarkupModel;

    RangeHighlighterTree(@NotNull Document document, @NotNull MarkupModelEx markupModel) {
        super(document);
        this.myMarkupModel = markupModel;
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i1, @NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i2) {
        RHNode o1 = (RHNode)i1;
        RHNode o2 = (RHNode)i2;
        int d = o2.myLayer - o1.myLayer;
        if (d != 0) {
            return d;
        }
        return super.compareEqualStartIntervals(i1, i2);
    }

    @NotNull
    protected RHNode createNewNode(@NotNull RangeHighlighterEx key2, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        return new RHNode(this, key2, start, end, greedyToLeft, greedyToRight, layer);
    }

    @Override
    void fireBeforeRemoved(@NotNull RangeHighlighterEx markerEx, @NotNull Object reason) {
        this.myMarkupModel.fireBeforeRemoved(markerEx);
    }

    static class RHNode
    extends RangeMarkerTree.RMNode<RangeHighlighterEx> {
        final int myLayer;

        public RHNode(@NotNull RangeHighlighterTree rangeMarkerTree, @NotNull RangeHighlighterEx key2, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
            super(rangeMarkerTree, key2, start, end, greedyToLeft, greedyToRight);
            this.myLayer = layer;
        }

        @Override
        protected Getter<RangeHighlighterEx> createGetter(@NotNull RangeHighlighterEx interval) {
            return (Getter)interval;
        }
    }
}

