/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModelImpl
implements SelectionModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.SelectionModelImpl");
    private final List<SelectionListener> mySelectionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final EditorImpl myEditor;
    private TextAttributes myTextAttributes;

    public SelectionModelImpl(EditorImpl editor) {
        this.myEditor = editor;
    }

    public boolean isUnknownDirection() {
        return this.myEditor.getCaretModel().getCurrentCaret().isUnknownDirection();
    }

    public void setUnknownDirection(boolean unknownDirection) {
        this.myEditor.getCaretModel().getCurrentCaret().setUnknownDirection(unknownDirection);
    }

    public int getSelectionStart() {
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectionStart();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectionStartPosition();
    }

    public int getSelectionEnd() {
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectionEnd();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectionEndPosition();
    }

    public boolean hasSelection() {
        return this.hasSelection(false);
    }

    public boolean hasSelection(boolean anyCaret) {
        if (!anyCaret) {
            return this.myEditor.getCaretModel().getCurrentCaret().hasSelection();
        }
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            if (!caret.hasSelection()) continue;
            return true;
        }
        return false;
    }

    public void setSelection(int startOffset, int endOffset) {
        this.myEditor.getCaretModel().getCurrentCaret().setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.myEditor.getCaretModel().getCurrentCaret().setSelection(startOffset, endPosition, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.myEditor.getCaretModel().getCurrentCaret().setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    void fireSelectionChanged(int oldSelectionStart, int oldSelectionEnd, int startOffset, int endOffset) {
        this.repaintBySelectionChange(oldSelectionStart, startOffset, oldSelectionEnd, endOffset);
        SelectionEvent event = new SelectionEvent((Editor)this.myEditor, oldSelectionStart, oldSelectionEnd, startOffset, endOffset);
        this.broadcastSelectionEvent(event);
    }

    private void broadcastSelectionEvent(SelectionEvent event) {
        for (SelectionListener listener2 : this.mySelectionListeners) {
            try {
                listener2.selectionChanged(event);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void repaintBySelectionChange(int oldSelectionStart, int startOffset, int oldSelectionEnd, int endOffset) {
        this.myEditor.repaint(Math.min(oldSelectionStart, startOffset), Math.max(oldSelectionStart, startOffset), false);
        this.myEditor.repaint(Math.min(oldSelectionEnd, endOffset), Math.max(oldSelectionEnd, endOffset), false);
    }

    public void removeSelection() {
        this.removeSelection(false);
    }

    public void removeSelection(boolean allCarets) {
        if (!allCarets) {
            this.myEditor.getCaretModel().getCurrentCaret().removeSelection();
        } else {
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                caret.removeSelection();
            }
        }
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        List caretStates = EditorModificationUtil.calcBlockSelectionState((Editor)this.myEditor, (LogicalPosition)blockStart, (LogicalPosition)blockEnd);
        this.myEditor.getCaretModel().setCaretsAndSelections(caretStates);
    }

    @NotNull
    public int[] getBlockSelectionStarts() {
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        int[] result2 = new int[carets.size()];
        int i = 0;
        for (Caret caret : carets) {
            result2[i++] = caret.getSelectionStart();
        }
        return result2;
    }

    @NotNull
    public int[] getBlockSelectionEnds() {
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        int[] result2 = new int[carets.size()];
        int i = 0;
        for (Caret caret : carets) {
            result2[i++] = caret.getSelectionEnd();
        }
        return result2;
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.mySelectionListeners.add(listener2);
    }

    public void addSelectionListener(final SelectionListener listener2, Disposable parent) {
        this.mySelectionListeners.add(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                SelectionModelImpl.this.mySelectionListeners.remove(listener2);
            }
        });
    }

    public void removeSelectionListener(SelectionListener listener2) {
        boolean success = this.mySelectionListeners.remove(listener2);
        LOG.assertTrue(success);
    }

    public String getSelectedText() {
        return this.getSelectedText(false);
    }

    public String getSelectedText(boolean allCarets) {
        SelectionModelImpl.validateContext(false);
        if (this.myEditor.getCaretModel().supportsMultipleCarets() && allCarets) {
            StringBuilder buf = new StringBuilder();
            String separator = "";
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                buf.append(separator);
                String caretSelectedText = caret.getSelectedText();
                if (caretSelectedText != null) {
                    buf.append(caretSelectedText);
                }
                separator = "\n";
            }
            return buf.toString();
        }
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectedText();
    }

    public static void doSelectLineAtCaret(Caret caret) {
        int lineNumber = caret.getLogicalPosition().line;
        Editor editor = caret.getEditor();
        Document document = editor.getDocument();
        if (lineNumber >= document.getLineCount()) {
            return;
        }
        Pair<LogicalPosition, LogicalPosition> lines = EditorUtil.calcCaretLineRange(caret);
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        caret.removeSelection();
        caret.setSelection(start, end);
    }

    public int getLeadSelectionOffset() {
        return this.myEditor.getCaretModel().getCurrentCaret().getLeadSelectionOffset();
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        return this.myEditor.getCaretModel().getCurrentCaret().getLeadSelectionPosition();
    }

    public void selectLineAtCaret() {
        this.myEditor.getCaretModel().getCurrentCaret().selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myEditor.getCaretModel().getCurrentCaret().selectWordAtCaret(honorCamelWordsSettings);
    }

    public void copySelectionToClipboard() {
        EditorCopyPasteHelper.getInstance().copySelectionToClipboard((Editor)this.myEditor);
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            TextAttributes textAttributes = new TextAttributes();
            EditorColorsScheme scheme2 = this.myEditor.getColorsScheme();
            textAttributes.setForegroundColor(scheme2.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
            textAttributes.setBackgroundColor(scheme2.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
            this.myTextAttributes = textAttributes;
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    private static void validateContext(boolean isWrite) {
        if (isWrite) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        } else {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
    }
}

