/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class TextChangeImpl
implements TextChange {
    private final StringBuilder myText = new StringBuilder();
    private char[] myChars;
    private int myStart;
    private int myEnd;

    public TextChangeImpl(@NotNull CharSequence text, int start) throws IllegalArgumentException {
        this(text, start, start);
    }

    public TextChangeImpl(@NotNull CharSequence text, int start, int end) throws IllegalArgumentException {
        if (start < 0) {
            throw new IllegalArgumentException(String.format("Can't construct new %s object. Reason: given start index (%d) is negative. End index: %d, text: '%s'", this.getClass().getName(), start, end, text));
        }
        if (end < start) {
            throw new IllegalArgumentException(String.format("Can't construct new %s object. Reason: given end index (%d) is less than start index (%d). Text: '%s'", this.getClass().getName(), end, start, text));
        }
        this.myText.append(text);
        this.myStart = start;
        this.myEnd = end;
    }

    public int getStart() {
        return this.myStart;
    }

    public void setStart(int start) {
        assert (start >= 0) : start;
        this.myStart = start;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public void setEnd(int end) {
        this.myEnd = end;
    }

    @NotNull
    public CharSequence getText() {
        return this.myText;
    }

    @NotNull
    public char[] getChars() {
        if (this.myChars == null) {
            this.myChars = CharArrayUtil.fromSequence((CharSequence)this.myText);
        }
        return this.myChars;
    }

    public int getDiff() {
        return this.myText.length() - this.myEnd + this.myStart;
    }

    public void advance(int offset) throws IllegalArgumentException {
        if (offset == 0) {
            return;
        }
        int newStart = this.myStart + offset;
        if (newStart < 0) {
            throw new IllegalArgumentException(String.format("Can't apply given offset (%d) to the current text change object (%s). Reason: new start index becomes negative after that (%d)", offset, this, newStart));
        }
        this.setStart(newStart);
        this.setEnd(this.myEnd + offset);
    }

    public boolean isWithinBounds(int length) {
        return this.isWithinBounds(0, length);
    }

    public boolean isWithinBounds(int start, int end) {
        return this.myStart >= start && this.myEnd <= end && this.myStart <= this.myEnd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextChangeImpl that = (TextChangeImpl)o;
        return this.myStart == that.myStart && this.myEnd == that.myEnd && StringUtil.equals((CharSequence)this.myText, (CharSequence)that.myText);
    }

    public int hashCode() {
        int result2 = StringUtil.hashCode((CharSequence)this.myText);
        result2 = 31 * result2 + this.myStart;
        return 31 * result2 + this.myEnd;
    }

    public String toString() {
        return String.format("%d-%d: '%s'", this.myStart, this.myEnd, this.myText);
    }
}

