/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrailingSpacesStripper
extends FileDocumentManagerAdapter {
    public static final Key<String> OVERRIDE_STRIP_TRAILING_SPACES_KEY = Key.create((String)"OVERRIDE_TRIM_TRAILING_SPACES_KEY");
    public static final Key<Boolean> OVERRIDE_ENSURE_NEWLINE_KEY = Key.create((String)"OVERRIDE_ENSURE_NEWLINE_KEY");
    private static final Key<Boolean> DISABLE_FOR_FILE_KEY = Key.create((String)"DISABLE_TRAILING_SPACE_STRIPPER_FOR_FILE_KEY");
    private final Set<Document> myDocumentsToStripLater = new THashSet();

    public void beforeAllDocumentsSaving() {
        THashSet documentsToStrip = new THashSet(this.myDocumentsToStripLater);
        this.myDocumentsToStripLater.clear();
        for (Document document : documentsToStrip) {
            this.strip(document);
        }
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        this.strip(document);
    }

    private void strip(final @NotNull Document document) {
        int end;
        int start;
        boolean inChangedLinesOnly;
        boolean success;
        boolean ensureEOL;
        if (!document.isWritable()) {
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile file2 = fileDocumentManager.getFile(document);
        if (file2 == null || !file2.isValid() || Boolean.TRUE.equals(DISABLE_FOR_FILE_KEY.get((UserDataHolder)file2))) {
            return;
        }
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (settings == null) {
            return;
        }
        String overrideStripTrailingSpacesData = (String)file2.getUserData(OVERRIDE_STRIP_TRAILING_SPACES_KEY);
        Boolean overrideEnsureNewlineData = (Boolean)file2.getUserData(OVERRIDE_ENSURE_NEWLINE_KEY);
        String stripTrailingSpaces = overrideStripTrailingSpacesData != null ? overrideStripTrailingSpacesData : settings.getStripTrailingSpaces();
        final boolean doStrip = !stripTrailingSpaces.equals("None");
        boolean bl = ensureEOL = overrideEnsureNewlineData != null ? overrideEnsureNewlineData.booleanValue() : settings.isEnsureNewLineAtEOF();
        if (doStrip && !(success = TrailingSpacesStripper.strip(document, inChangedLinesOnly = !stripTrailingSpaces.equals("Whole"), settings.isKeepTrailingSpacesOnCaretLine()))) {
            this.myDocumentsToStripLater.add(document);
        }
        int lines = document.getLineCount();
        if (ensureEOL && lines > 0 && (start = document.getLineStartOffset(lines - 1)) != (end = document.getLineEndOffset(lines - 1))) {
            final CharSequence content = document.getCharsSequence();
            ApplicationManager.getApplication().runWriteAction((Runnable)new DocumentRunnable(document, null){

                public void run() {
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                        if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)content.subSequence(start, end)) && doStrip) {
                            document.deleteString(start, end);
                        } else {
                            document.insertString(end, (CharSequence)"\n");
                        }
                    });
                }
            });
        }
    }

    public void clearLineModificationFlags(@NotNull Document document) {
        int[] caretLines;
        boolean inChangedLinesOnly;
        boolean enabled;
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        if (!(document instanceof DocumentImpl)) {
            return;
        }
        Editor activeEditor = TrailingSpacesStripper.getActiveEditor(document);
        boolean isVirtualSpaceEnabled = activeEditor == null || activeEditor.getSettings().isVirtualSpace();
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (settings == null) {
            return;
        }
        boolean bl = enabled = !Boolean.TRUE.equals(DISABLE_FOR_FILE_KEY.get((UserDataHolder)FileDocumentManager.getInstance().getFile(document)));
        if (!enabled) {
            return;
        }
        String stripTrailingSpaces = settings.getStripTrailingSpaces();
        boolean doStrip = !stripTrailingSpaces.equals("None");
        boolean bl2 = inChangedLinesOnly = !stripTrailingSpaces.equals("Whole");
        if (activeEditor != null && inChangedLinesOnly && doStrip && !isVirtualSpaceEnabled) {
            List carets = activeEditor.getCaretModel().getAllCarets();
            caretLines = new int[carets.size()];
            for (int i2 = 0; i2 < carets.size(); ++i2) {
                Caret caret = (Caret)carets.get(i2);
                caretLines[i2] = caret.getLogicalPosition().line;
            }
        } else {
            caretLines = ArrayUtil.EMPTY_INT_ARRAY;
        }
        ((DocumentImpl)document).clearLineModificationFlagsExcept(caretLines);
    }

    private static Editor getActiveEditor(@NotNull Document document) {
        Editor activeEditor;
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        boolean isDisposeInProgress = ApplicationManager.getApplication().isDisposeInProgress();
        Editor editor = activeEditor = isDisposeInProgress ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (activeEditor != null && activeEditor.getDocument() != document) {
            activeEditor = null;
        }
        return activeEditor;
    }

    public static boolean strip(@NotNull Document document, boolean inChangedLinesOnly, boolean skipCaretLines) {
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        if (!(document instanceof DocumentImpl)) {
            return true;
        }
        Editor activeEditor = TrailingSpacesStripper.getActiveEditor(document);
        List carets = activeEditor == null ? Collections.emptyList() : activeEditor.getCaretModel().getAllCarets();
        ArrayList<VisualPosition> visualCarets = new ArrayList<VisualPosition>(carets.size());
        int[] caretOffsets = new int[carets.size()];
        for (int i2 = 0; i2 < carets.size(); ++i2) {
            Caret caret = (Caret)carets.get(i2);
            visualCarets.add(caret.getVisualPosition());
            caretOffsets[i2] = caret.getOffset();
        }
        boolean markAsNeedsStrippingLater = ((DocumentImpl)document).stripTrailingSpaces(TrailingSpacesStripper.getProject(document, activeEditor), inChangedLinesOnly, skipCaretLines, caretOffsets);
        if (activeEditor != null && !ShutDownTracker.isShutdownHookRunning()) {
            activeEditor.getCaretModel().runBatchCaretOperation(() -> {
                for (int i2 = 0; i2 < carets.size(); ++i2) {
                    Caret caret = (Caret)carets.get(i2);
                    if (!caret.isValid()) continue;
                    caret.moveToVisualPosition((VisualPosition)visualCarets.get(i2));
                }
            });
        }
        return !markAsNeedsStrippingLater;
    }

    @Nullable
    private static Project getProject(@NotNull Document document, @Nullable Editor editor) {
        if (editor != null) {
            return editor.getProject();
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            return ProjectUtil.guessProjectForFile((VirtualFile)file2);
        }
        return null;
    }

    public void documentDeleted(@NotNull Document doc) {
        this.myDocumentsToStripLater.remove(doc);
    }

    public void unsavedDocumentsDropped() {
        this.myDocumentsToStripLater.clear();
    }

    public static void setEnabled(@NotNull VirtualFile file2, boolean enabled) {
        DISABLE_FOR_FILE_KEY.set((UserDataHolder)file2, (Object)(enabled ? null : Boolean.TRUE));
    }

    public static boolean isEnabled(@NotNull VirtualFile file2) {
        return !Boolean.TRUE.equals(DISABLE_FOR_FILE_KEY.get((UserDataHolder)file2));
    }
}

