/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.event;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

public class DocumentEventImpl
extends DocumentEvent {
    private final int myOffset;
    private final CharSequence myOldString;
    private final int myOldLength;
    private final CharSequence myNewString;
    private final int myNewLength;
    private final long myOldTimeStamp;
    private final boolean myIsWholeDocReplaced;
    private Diff.Change myChange;
    private static final Diff.Change TOO_BIG_FILE = new Diff.Change(0, 0, 0, 0, null);
    private final int myInitialStartOffset;
    private final int myInitialOldLength;

    public DocumentEventImpl(@NotNull Document document, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp, boolean wholeTextReplaced) {
        this(document, offset, oldString, newString, oldTimeStamp, wholeTextReplaced, offset, oldString.length());
    }

    public DocumentEventImpl(@NotNull Document document, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp, boolean wholeTextReplaced, int initialStartOffset, int initialOldLength) {
        super(document);
        this.myOffset = offset;
        this.myOldString = oldString;
        this.myOldLength = oldString.length();
        this.myNewString = newString;
        this.myNewLength = newString.length();
        this.myInitialStartOffset = initialStartOffset;
        this.myInitialOldLength = initialOldLength;
        this.myOldTimeStamp = oldTimeStamp;
        boolean bl = this.myIsWholeDocReplaced = this.getDocument().getTextLength() != 0 && wholeTextReplaced;
        assert (initialStartOffset >= 0) : initialStartOffset;
        assert (initialOldLength >= 0) : initialOldLength;
        assert (initialStartOffset + initialOldLength <= document.getTextLength()) : "initialStartOffset = " + initialStartOffset + "; initialOldLength = " + initialOldLength + ";document.getTextLength() = " + document.getTextLength();
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getOldLength() {
        return this.myOldLength;
    }

    public int getNewLength() {
        return this.myNewLength;
    }

    @NotNull
    public CharSequence getOldFragment() {
        return this.myOldString;
    }

    @NotNull
    public CharSequence getNewFragment() {
        return this.myNewString;
    }

    @NotNull
    public Document getDocument() {
        return (Document)this.getSource();
    }

    public int getInitialStartOffset() {
        return this.myInitialStartOffset;
    }

    public int getInitialOldLength() {
        return this.myInitialOldLength;
    }

    public long getOldTimeStamp() {
        return this.myOldTimeStamp;
    }

    public String toString() {
        return "DocumentEventImpl[myOffset=" + this.myOffset + ", myOldLength=" + this.myOldLength + ", myNewLength=" + this.myNewLength + ", myOldString='" + this.myOldString + "', myNewString='" + this.myNewString + "']" + (this.isWholeTextReplaced() ? " Whole." : ".");
    }

    public boolean isWholeTextReplaced() {
        return this.myIsWholeDocReplaced;
    }

    public int translateLineViaDiff(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        int startLine = this.getDocument().getLineNumber(this.getOffset());
        int newLine = line -= startLine;
        while (change != null && line >= change.line0) {
            if (line >= change.line0 + change.deleted) {
                newLine += change.inserted - change.deleted;
            } else {
                int delta = Math.min(change.inserted, line - change.line0);
                newLine = change.line1 + delta;
                break;
            }
            change = change.link;
        }
        return newLine + startLine;
    }

    public int translateLineViaDiffStrict(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        int startLine = this.getDocument().getLineNumber(this.getOffset());
        if (line < startLine) {
            return line;
        }
        int translatedRelative = Diff.translateLine((Diff.Change)change, (int)(line - startLine));
        return translatedRelative < 0 ? -1 : translatedRelative + startLine;
    }

    private Diff.Change reBuildDiffIfNeeded() throws FilesTooBigForDiffException {
        if (this.myChange == TOO_BIG_FILE) {
            throw new FilesTooBigForDiffException(0);
        }
        if (this.myChange == null) {
            try {
                this.myChange = Diff.buildChanges((CharSequence)this.myOldString, (CharSequence)this.myNewString);
            }
            catch (FilesTooBigForDiffException e) {
                this.myChange = TOO_BIG_FILE;
                throw e;
            }
        }
        return this.myChange;
    }
}

