/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftWrapsStorage
implements Dumpable {
    private final List<SoftWrapImpl> myWraps = new ArrayList<SoftWrapImpl>();
    private final List<SoftWrapImpl> myWrapsView = Collections.unmodifiableList(this.myWraps);
    private final List<SoftWrapChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public boolean isEmpty() {
        return this.myWraps.isEmpty();
    }

    @Nullable
    public SoftWrap getSoftWrap(int offset) {
        int i2 = this.getSoftWrapIndex(offset);
        return i2 >= 0 ? (SoftWrap)this.myWraps.get(i2) : null;
    }

    @NotNull
    public List<SoftWrapImpl> getSoftWraps() {
        return this.myWrapsView;
    }

    public int getSoftWrapIndex(int offset) {
        int start = 0;
        int end = this.myWraps.size() - 1;
        while (start <= end) {
            int i2 = start + end >>> 1;
            SoftWrap softWrap = this.myWraps.get(i2);
            int softWrapOffset = softWrap.getStart();
            if (softWrapOffset > offset) {
                end = i2 - 1;
                continue;
            }
            if (softWrapOffset < offset) {
                start = i2 + 1;
                continue;
            }
            return i2;
        }
        return -(start + 1);
    }

    public int getNumberOfSoftWrapsInRange(int startOffset, int endOffset) {
        SoftWrap softWrap;
        int startIndex = this.getSoftWrapIndex(startOffset);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (startIndex >= this.myWraps.size()) {
            return 0;
        }
        int result2 = 0;
        for (int endIndex = startIndex; endIndex < this.myWraps.size() && (softWrap = (SoftWrap)this.myWraps.get(endIndex)).getStart() <= endOffset; ++endIndex) {
            ++result2;
        }
        return result2;
    }

    public void storeOrReplace(SoftWrapImpl softWrap) {
        int i2 = this.getSoftWrapIndex(softWrap.getStart());
        if (i2 >= 0) {
            this.myWraps.set(i2, softWrap);
            return;
        }
        i2 = -i2 - 1;
        this.myWraps.add(i2, softWrap);
    }

    public void remove(SoftWrapImpl softWrap) {
        if (this.myWraps.isEmpty()) {
            return;
        }
        int i2 = this.myWraps.size() - 1;
        if (this.myWraps.get(i2).getStart() != softWrap.getStart()) {
            i2 = this.getSoftWrapIndex(softWrap.getStart());
        }
        if (i2 >= 0) {
            this.myWraps.remove(i2);
        }
    }

    public List<SoftWrapImpl> removeStartingFrom(int offset) {
        int startIndex = this.getSoftWrapIndex(offset);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (startIndex >= this.myWraps.size()) {
            return Collections.emptyList();
        }
        List<SoftWrapImpl> tail = this.myWraps.subList(startIndex, this.myWraps.size());
        ArrayList<SoftWrapImpl> result2 = new ArrayList<SoftWrapImpl>(tail);
        tail.clear();
        return result2;
    }

    public void addAll(List<SoftWrapImpl> softWraps) {
        this.myWraps.addAll(softWraps);
    }

    public void removeAll() {
        this.myWraps.clear();
        this.notifyListenersAboutChange();
    }

    public boolean addSoftWrapChangeListener(@NotNull SoftWrapChangeListener listener2) {
        return this.myListeners.add(listener2);
    }

    public void notifyListenersAboutChange() {
        for (SoftWrapChangeListener listener2 : this.myListeners) {
            listener2.softWrapsChanged();
        }
    }

    @NotNull
    public String dumpState() {
        return this.myWraps.toString();
    }
}

