/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.util.DocumentUtil;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class EditorCoordinateMapper {
    private static final Logger LOG = Logger.getInstance(EditorCoordinateMapper.class);
    private final EditorView myView;
    private final Document myDocument;
    private final FoldingModelImpl myFoldingModel;

    EditorCoordinateMapper(EditorView view) {
        this.myView = view;
        this.myDocument = this.myView.getEditor().getDocument();
        this.myFoldingModel = this.myView.getEditor().getFoldingModel();
    }

    int visualLineToY(int line) {
        return this.myView.getInsets().top + Math.max(0, line) * this.myView.getLineHeight();
    }

    int yToVisualLine(int y) {
        return Math.max(0, y - this.myView.getInsets().top) / this.myView.getLineHeight();
    }

    @NotNull
    LogicalPosition offsetToLogicalPosition(int offset) {
        return this.myView.getLogicalPositionCache().offsetToLogicalPosition(offset);
    }

    int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        return this.myView.getLogicalPositionCache().logicalPositionToOffset(pos);
    }

    @NotNull
    VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos, boolean beforeSoftWrap) {
        int line = pos.line;
        int column = pos.column;
        int logicalLineCount = this.myDocument.getLineCount();
        if (line >= logicalLineCount) {
            return new VisualPosition(line - logicalLineCount + this.myView.getEditor().getVisibleLineCount(), column, pos.leansForward);
        }
        int offset = this.logicalPositionToOffset(pos);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap)) {
            if (!pos.leansForward && offset == fragment.getVisualLineStartOffset()) {
                return new VisualPosition(visualLine, fragment.getStartVisualColumn());
            }
            if (fragment.isCollapsedFoldRegion()) {
                int startLogicalLine = fragment.getStartLogicalLine();
                int endLogicalLine = fragment.getEndLogicalLine();
                int startLogicalColumn = fragment.getStartLogicalColumn();
                int endLogicalColumn = fragment.getEndLogicalColumn();
                if ((line > startLogicalLine || line == startLogicalLine && (column > startLogicalColumn || column == startLogicalColumn && pos.leansForward)) && (line < endLogicalLine || line == endLogicalLine && column < endLogicalColumn)) {
                    return new VisualPosition(visualLine, fragment.getStartVisualColumn(), true);
                }
                if (line == endLogicalLine && column == endLogicalColumn && !pos.leansForward) {
                    return new VisualPosition(visualLine, fragment.getEndVisualColumn());
                }
                maxLogicalColumn = startLogicalLine == endLogicalLine ? Math.max(maxLogicalColumn, endLogicalColumn) : endLogicalColumn;
            } else if (fragment.getCurrentInlays() == null) {
                int minColumn = fragment.getMinLogicalColumn();
                int maxColumn = fragment.getMaxLogicalColumn();
                if (line == fragment.getStartLogicalLine() && (column > minColumn && column < maxColumn || column == minColumn && pos.leansForward || column == maxColumn && !pos.leansForward)) {
                    return new VisualPosition(visualLine, fragment.logicalToVisualColumn(column), fragment.isRtl() ^ pos.leansForward);
                }
                maxLogicalColumn = Math.max(maxLogicalColumn, maxColumn);
            }
            maxVisualColumn = fragment.getEndVisualColumn();
        }
        int resultColumn = column - maxLogicalColumn + maxVisualColumn;
        if (resultColumn < 0) {
            if (maxVisualColumn > maxLogicalColumn) {
                resultColumn = Integer.MAX_VALUE;
            } else {
                LOG.error("Error converting " + pos + " to visual position", new Attachment[]{new Attachment("details.txt", String.format("offset: %d, visual line: %d, max logical column: %d, max visual column: %d", offset, visualLine, maxLogicalColumn, maxVisualColumn)), new Attachment("dump.txt", this.myView.getEditor().dumpState())});
                resultColumn = 0;
            }
        }
        return new VisualPosition(visualLine, resultColumn, pos.leansForward);
    }

    @NotNull
    LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        int line = pos.line;
        int column = pos.column;
        int visualLineCount = this.myView.getEditor().getVisibleLineCount();
        if (line >= visualLineCount) {
            return new LogicalPosition(line - visualLineCount + this.myDocument.getLineCount(), column, pos.leansRight);
        }
        int offset = this.visualLineToOffset(line);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        int maxOffset = offset;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, false)) {
            int minColumn = fragment.getStartVisualColumn();
            int maxColumn = fragment.getEndVisualColumn();
            if (column < minColumn || column == minColumn && !pos.leansRight) {
                return this.offsetToLogicalPosition(offset);
            }
            if (column > minColumn && column < maxColumn || column == minColumn || column == maxColumn && !pos.leansRight) {
                return new LogicalPosition(column == maxColumn ? fragment.getEndLogicalLine() : fragment.getStartLogicalLine(), fragment.visualToLogicalColumn(column), fragment.isCollapsedFoldRegion() ? column < maxColumn : (fragment.getCurrentInlays() != null ? column == maxColumn : fragment.isRtl() ^ pos.leansRight));
            }
            maxLogicalColumn = logicalLine == fragment.getEndLogicalLine() ? Math.max(maxLogicalColumn, fragment.getMaxLogicalColumn()) : fragment.getMaxLogicalColumn();
            maxVisualColumn = maxColumn;
            logicalLine = fragment.getEndLogicalLine();
            maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
        }
        if (this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) == null) {
            int resultColumn = column - maxVisualColumn + maxLogicalColumn;
            if (resultColumn < 0 && maxLogicalColumn > maxVisualColumn) {
                resultColumn = Integer.MAX_VALUE;
            }
            return new LogicalPosition(logicalLine, resultColumn, true);
        }
        return this.offsetToLogicalPosition(maxOffset).leanForward(true);
    }

    @NotNull
    VisualPosition offsetToVisualPosition(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        return this.logicalToVisualPosition(this.offsetToLogicalPosition(offset).leanForward(leanTowardsLargerOffsets), beforeSoftWrap);
    }

    int visualPositionToOffset(VisualPosition visualPosition) {
        return this.logicalPositionToOffset(this.visualToLogicalPosition(visualPosition));
    }

    int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        int wrapIndex;
        int textLength = this.myDocument.getTextLength();
        if (offset < 0 || textLength == 0) {
            return 0;
        }
        offset = Math.min(offset, textLength);
        FoldRegion outermostCollapsed = this.myFoldingModel.getCollapsedRegionAtOffset(offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset));
        if (outermostCollapsed != null && offset > outermostCollapsed.getStartOffset()) {
            assert (outermostCollapsed.isValid());
            offset = outermostCollapsed.getStartOffset();
            beforeSoftWrap = false;
        }
        int softWrapsBeforeOrAtOffset = (wrapIndex = this.myView.getEditor().getSoftWrapModel().getSoftWrapIndex(offset)) < 0 ? -wrapIndex - 1 : wrapIndex + (beforeSoftWrap ? 0 : 1);
        return this.myDocument.getLineNumber(offset) - this.myFoldingModel.getFoldedLinesCountBefore(offset) + softWrapsBeforeOrAtOffset;
    }

    int visualLineToOffset(int visualLine) {
        int start = 0;
        int end = this.myDocument.getTextLength();
        if (visualLine <= 0) {
            return start;
        }
        if (visualLine >= this.myView.getEditor().getVisibleLineCount()) {
            return end;
        }
        int current = 0;
        while (start <= end) {
            current = (start + end) / 2;
            int line = this.offsetToVisualLine(current, false);
            if (line < visualLine) {
                start = current + 1;
                continue;
            }
            if (line <= visualLine) break;
            end = current - 1;
        }
        return this.visualLineStartOffset(current, true);
    }

    private int visualLineStartOffset(int offset, boolean leanForward) {
        SoftWrap currentOrPrevWrap;
        EditorImpl editor = this.myView.getEditor();
        offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset);
        int result2 = EditorUtil.getNotFoldedLineStartOffset(editor, offset);
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        List<? extends SoftWrap> softWraps = softWrapModel.getRegisteredSoftWraps();
        int currentOrPrevWrapIndex = softWrapModel.getSoftWrapIndex(offset);
        if (currentOrPrevWrapIndex < 0) {
            currentOrPrevWrap = (currentOrPrevWrapIndex = -currentOrPrevWrapIndex - 2) < 0 || currentOrPrevWrapIndex >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex);
        } else {
            SoftWrap softWrap = currentOrPrevWrap = leanForward ? softWraps.get(currentOrPrevWrapIndex) : null;
        }
        if (currentOrPrevWrap != null && currentOrPrevWrap.getStart() > result2) {
            result2 = currentOrPrevWrap.getStart();
        }
        return result2;
    }

    private float getStartX(int line) {
        return (float)this.myView.getInsets().left + (line == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f);
    }

    @NotNull
    VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        int visualLine = this.yToVisualLine((int)p.getY());
        int lastColumn = 0;
        float x = this.getStartX(visualLine);
        float px = (float)p.getX();
        if (visualLine < this.myView.getEditor().getVisibleLineCount()) {
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false)) {
                if (px <= fragment.getStartX()) {
                    if (fragment.getStartVisualColumn() == 0) {
                        return new VisualPosition(visualLine, 0);
                    }
                    int markerWidth = this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
                    float indent = fragment.getStartX() - (float)markerWidth;
                    if (px <= indent) break;
                    boolean after2 = px >= indent + (float)(markerWidth / 2);
                    return new VisualPosition(visualLine, fragment.getStartVisualColumn() - (after2 ? 0 : 1), !after2);
                }
                float nextX = fragment.getEndX();
                if (px <= nextX) {
                    int[] column = fragment.xToVisualColumn(px);
                    return new VisualPosition(visualLine, column[0], column[1] > 0);
                }
                x = nextX;
                lastColumn = fragment.getEndVisualColumn();
                maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
            }
            if (this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) != null) {
                int markerWidth = this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
                if (px <= x + (float)markerWidth) {
                    boolean after3 = px >= x + (float)(markerWidth / 2);
                    return new VisualPosition(visualLine, lastColumn + (after3 ? 1 : 0), !after3);
                }
                px -= (float)markerWidth;
                ++lastColumn;
            }
        }
        int plainSpaceWidth = this.myView.getPlainSpaceWidth();
        int remainingShift = (int)(px - x);
        int additionalColumns = remainingShift <= 0 ? 0 : (remainingShift + plainSpaceWidth / 2) / plainSpaceWidth;
        return new VisualPosition(visualLine, lastColumn + additionalColumns, remainingShift > 0 && additionalColumns == (remainingShift - 1) / plainSpaceWidth);
    }

    @NotNull
    Point2D visualPositionToXY(@NotNull VisualPosition pos) {
        int visualLine = pos.line;
        int column = pos.column;
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(visualLine);
        int lastColumn = 0;
        if (visualLine < this.myView.getEditor().getVisibleLineCount()) {
            VisualLineFragmentsIterator.Fragment fragment;
            int startVisualColumn;
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            Iterator<VisualLineFragmentsIterator.Fragment> iterator = VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false).iterator();
            while (iterator.hasNext() && column >= (startVisualColumn = (fragment = iterator.next()).getStartVisualColumn()) && (column != startVisualColumn || pos.leansRight)) {
                int endColumn = fragment.getEndVisualColumn();
                if (column < endColumn || column == endColumn && !pos.leansRight) {
                    return new Point2D.Float(fragment.visualColumnToX(column), y);
                }
                x = fragment.getEndX();
                lastColumn = endColumn;
                maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
            }
            if (column > lastColumn && this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) != null) {
                --column;
                x += (float)this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
            }
        }
        int additionalShift = column <= lastColumn ? 0 : (column - lastColumn) * this.myView.getPlainSpaceWidth();
        return new Point2D.Float(x + (float)additionalShift, y);
    }

    @NotNull
    Point2D offsetToXY(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        offset = Math.max(0, Math.min(this.myDocument.getTextLength(), offset));
        offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int visualLineStartOffset = this.visualLineToOffset(visualLine);
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(logicalLine);
        if (this.myDocument.getTextLength() > 0) {
            boolean firstFragment = true;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap)) {
                if (firstFragment && offset == visualLineStartOffset && !leanTowardsLargerOffsets) {
                    x = fragment.getStartX();
                    break;
                }
                firstFragment = false;
                int minOffset = fragment.getMinOffset();
                int maxOffset = fragment.getMaxOffset();
                if (fragment.getCurrentInlays() == null && (offset > minOffset && offset < maxOffset || offset == minOffset && leanTowardsLargerOffsets || offset == maxOffset && !leanTowardsLargerOffsets)) {
                    x = fragment.offsetToX(offset);
                    break;
                }
                x = fragment.getEndX();
            }
        }
        return new Point2D.Float(x, y);
    }
}

