/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.view.EditorCoordinateMapper;
import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.impl.view.EditorSizeManager;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.editor.impl.view.LogicalPositionCache;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextLayoutCache;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;

public class EditorView
implements TextDrawingCallback,
Disposable,
Dumpable,
HierarchyListener,
VisibleAreaListener {
    private static Key<LineLayout> FOLD_REGION_TEXT_LAYOUT = Key.create((String)"text.layout");
    private final EditorImpl myEditor;
    private final DocumentEx myDocument;
    private final EditorPainter myPainter;
    private final EditorCoordinateMapper myMapper;
    private final EditorSizeManager mySizeManager;
    private final TextLayoutCache myTextLayoutCache;
    private final LogicalPositionCache myLogicalPositionCache;
    private final TabFragment myTabFragment;
    private FontRenderContext myFontRenderContext;
    private String myPrefixText;
    private LineLayout myPrefixLayout;
    private TextAttributes myPrefixAttributes;
    private int myBidiFlags;
    private int myPlainSpaceWidth;
    private int myLineHeight;
    private int myDescent;
    private int myCharHeight;
    private int myMaxCharWidth;
    private int myTabSize;
    private int myTopOverhang;
    private int myBottomOverhang;
    private final Object myLock = new Object();

    public EditorView(EditorImpl editor) {
        this.myEditor = editor;
        this.myDocument = editor.getDocument();
        this.myPainter = new EditorPainter(this);
        this.myMapper = new EditorCoordinateMapper(this);
        this.mySizeManager = new EditorSizeManager(this);
        this.myTextLayoutCache = new TextLayoutCache(this);
        this.myLogicalPositionCache = new LogicalPositionCache(this);
        this.myTabFragment = new TabFragment(this);
        this.myEditor.getContentComponent().addHierarchyListener(this);
        this.myEditor.getScrollingModel().addVisibleAreaListener(this);
        Disposer.register((Disposable)this, (Disposable)this.myLogicalPositionCache);
        Disposer.register((Disposable)this, (Disposable)this.myTextLayoutCache);
        Disposer.register((Disposable)this, (Disposable)this.mySizeManager);
    }

    EditorImpl getEditor() {
        return this.myEditor;
    }

    FontRenderContext getFontRenderContext() {
        return this.myFontRenderContext;
    }

    EditorSizeManager getSizeManager() {
        return this.mySizeManager;
    }

    TextLayoutCache getTextLayoutCache() {
        return this.myTextLayoutCache;
    }

    EditorPainter getPainter() {
        return this.myPainter;
    }

    TabFragment getTabFragment() {
        return this.myTabFragment;
    }

    LogicalPositionCache getLogicalPositionCache() {
        return this.myLogicalPositionCache;
    }

    public void dispose() {
        this.myEditor.getScrollingModel().removeVisibleAreaListener(this);
        this.myEditor.getContentComponent().removeHierarchyListener(this);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L && e.getComponent().isShowing()) {
            this.checkFontRenderContext(null);
        }
    }

    public void visibleAreaChanged(VisibleAreaEvent e) {
        this.checkFontRenderContext(null);
    }

    public int yToVisualLine(int y) {
        return this.myMapper.yToVisualLine(y);
    }

    public int visualLineToY(int line) {
        return this.myMapper.visualLineToY(line);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        EditorView.assertIsReadAccess();
        return this.myMapper.offsetToLogicalPosition(offset);
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        EditorView.assertIsReadAccess();
        return this.myMapper.logicalPositionToOffset(pos);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.logicalToVisualPosition(pos, beforeSoftWrap);
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualToLogicalPosition(pos);
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.offsetToVisualPosition(offset, leanTowardsLargerOffsets, beforeSoftWrap);
    }

    public int visualPositionToOffset(VisualPosition visualPosition) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualPositionToOffset(visualPosition);
    }

    public int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.offsetToVisualLine(offset, beforeSoftWrap);
    }

    public int visualLineToOffset(int visualLine) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualLineToOffset(visualLine);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.xyToVisualPosition(p);
    }

    @NotNull
    public Point2D visualPositionToXY(@NotNull VisualPosition pos) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualPositionToXY(pos);
    }

    @NotNull
    public Point2D offsetToXY(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.offsetToXY(offset, leanTowardsLargerOffsets, beforeSoftWrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefix(String prefixText, TextAttributes attributes) {
        EditorView.assertIsDispatchThread();
        this.myPrefixText = prefixText;
        Object object = this.myLock;
        synchronized (object) {
            this.myPrefixLayout = prefixText == null || prefixText.isEmpty() ? null : LineLayout.create(this, prefixText, attributes.getFontType());
        }
        this.myPrefixAttributes = attributes;
        this.mySizeManager.invalidateRange(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getPrefixTextWidthInPixels() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myPrefixLayout == null ? 0.0f : this.myPrefixLayout.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LineLayout getPrefixLayout() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myPrefixLayout;
        }
    }

    TextAttributes getPrefixAttributes() {
        return this.myPrefixAttributes;
    }

    public void paint(Graphics2D g) {
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        this.checkFontRenderContext(g.getFontRenderContext());
        this.myPainter.paint(g);
    }

    public void repaintCarets() {
        EditorView.assertIsDispatchThread();
        this.myPainter.repaintCarets();
    }

    public Dimension getPreferredSize() {
        EditorView.assertIsDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.mySizeManager.getPreferredSize();
    }

    public int getPreferredWidth(int beginLine, int endLine) {
        EditorView.assertIsDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.mySizeManager.getPreferredWidth(beginLine, endLine);
    }

    public int getPreferredHeight() {
        EditorView.assertIsDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.mySizeManager.getPreferredHeight();
    }

    public int getMaxWidthInRange(int startOffset, int endOffset) {
        EditorView.assertIsDispatchThread();
        return this.getMaxWidthInLineRange(this.offsetToVisualLine(startOffset, false), this.offsetToVisualLine(endOffset, true));
    }

    int getMaxWidthInLineRange(int startVisualLine, int endVisualLine) {
        this.myEditor.getSoftWrapModel().prepareToMapping();
        int maxWidth = 0;
        VisualLinesIterator iterator = new VisualLinesIterator(this.myEditor, startVisualLine);
        while (!iterator.atEnd() && iterator.getVisualLine() <= endVisualLine) {
            int width = this.mySizeManager.getVisualLineWidth(iterator, null);
            maxWidth = Math.max(maxWidth, width);
            iterator.advance();
        }
        return maxWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitSettings() {
        EditorView.assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            this.myPlainSpaceWidth = -1;
            this.myTabSize = -1;
        }
        switch (EditorSettingsExternalizable.getInstance().getBidiTextDirection()) {
            case LTR: {
                this.myBidiFlags = 0;
                break;
            }
            case RTL: {
                this.myBidiFlags = 1;
                break;
            }
            default: {
                this.myBidiFlags = -2;
            }
        }
        this.setFontRenderContext(null);
        this.myLogicalPositionCache.reset(false);
        this.myTextLayoutCache.resetToDocumentSize(false);
        this.invalidateFoldRegionLayouts();
        this.setPrefix(this.myPrefixText, this.myPrefixAttributes);
        this.mySizeManager.reset();
    }

    public void invalidateRange(int startOffset, int endOffset) {
        EditorView.assertIsDispatchThread();
        int textLength = this.myDocument.getTextLength();
        if (startOffset > endOffset || startOffset >= textLength || endOffset < 0) {
            return;
        }
        int startLine = this.myDocument.getLineNumber(Math.max(0, startOffset));
        int endLine = this.myDocument.getLineNumber(Math.min(textLength, endOffset));
        this.myTextLayoutCache.invalidateLines(startLine, endLine);
        this.mySizeManager.invalidateRange(startOffset, endOffset);
    }

    public void reset() {
        EditorView.assertIsDispatchThread();
        this.myLogicalPositionCache.reset(true);
        this.myTextLayoutCache.resetToDocumentSize(true);
        this.mySizeManager.reset();
    }

    public boolean isRtlLocation(@NotNull VisualPosition visualPosition) {
        EditorView.assertIsDispatchThread();
        if (this.myDocument.getTextLength() == 0) {
            return false;
        }
        LogicalPosition logicalPosition = this.visualToLogicalPosition(visualPosition);
        int offset = this.logicalPositionToOffset(logicalPosition);
        if (this.myEditor.getSoftWrapModel().getSoftWrap(offset) != null) {
            VisualPosition beforeWrapPosition = this.offsetToVisualPosition(offset, true, true);
            if (visualPosition.line == beforeWrapPosition.line && (visualPosition.column > beforeWrapPosition.column || visualPosition.column == beforeWrapPosition.column && visualPosition.leansRight)) {
                return false;
            }
            VisualPosition afterWrapPosition = this.offsetToVisualPosition(offset, false, false);
            if (visualPosition.line == afterWrapPosition.line && (visualPosition.column < afterWrapPosition.column || visualPosition.column == afterWrapPosition.column && !visualPosition.leansRight)) {
                return false;
            }
        }
        int line = this.myDocument.getLineNumber(offset);
        LineLayout layout = this.myTextLayoutCache.getLineLayout(line);
        return layout.isRtlLocation(offset - this.myDocument.getLineStartOffset(line), logicalPosition.leansForward);
    }

    public boolean isAtBidiRunBoundary(@NotNull VisualPosition visualPosition) {
        EditorView.assertIsDispatchThread();
        int offset = this.visualPositionToOffset(visualPosition);
        int otherSideOffset = this.visualPositionToOffset(visualPosition.leanRight(!visualPosition.leansRight));
        return offset != otherSideOffset;
    }

    public int findNearestDirectionBoundary(int offset, boolean lookForward) {
        int lineStartOffset;
        EditorView.assertIsDispatchThread();
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0 || offset < 0 || offset > textLength) {
            return -1;
        }
        int line = this.myDocument.getLineNumber(offset);
        LineLayout layout = this.myTextLayoutCache.getLineLayout(line);
        int relativeOffset = layout.findNearestDirectionBoundary(offset - (lineStartOffset = this.myDocument.getLineStartOffset(line)), lookForward);
        return relativeOffset < 0 ? -1 : lineStartOffset + relativeOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlainSpaceWidth() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myPlainSpaceWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNominalLineHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myLineHeight + this.myTopOverhang + this.myBottomOverhang;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myLineHeight;
        }
    }

    private float getVerticalScalingFactor() {
        if (this.myEditor.isOneLineMode()) {
            return 1.0f;
        }
        float lineSpacing = this.myEditor.getColorsScheme().getLineSpacing();
        return lineSpacing > 0.0f ? lineSpacing : 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDescent() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDescent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCharHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myCharHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMaxCharWidth() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myMaxCharWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAscent() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myLineHeight - this.myDescent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTopOverhang() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myTopOverhang;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBottomOverhang() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myBottomOverhang;
        }
    }

    private void initMetricsIfNeeded() {
        if (this.myPlainSpaceWidth >= 0) {
            return;
        }
        FontMetrics fm = this.myEditor.getContentComponent().getFontMetrics(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        int width = FontLayoutService.getInstance().charWidth(fm, ' ');
        this.myPlainSpaceWidth = width > 0 ? width : 1;
        this.myCharHeight = FontLayoutService.getInstance().charWidth(fm, 'a');
        float verticalScalingFactor = this.getVerticalScalingFactor();
        int fontMetricsHeight = FontLayoutService.getInstance().getHeight(fm);
        this.myLineHeight = (int)Math.ceil((float)fontMetricsHeight * verticalScalingFactor);
        int descent = FontLayoutService.getInstance().getDescent(fm);
        this.myDescent = (int)Math.floor((float)descent * verticalScalingFactor);
        this.myTopOverhang = fontMetricsHeight - this.myLineHeight + this.myDescent - descent;
        this.myBottomOverhang = descent - this.myDescent;
        FontMetrics fmBI = this.myEditor.getContentComponent().getFontMetrics(this.myEditor.getColorsScheme().getFont(EditorFontType.BOLD_ITALIC));
        this.myMaxCharWidth = FontLayoutService.getInstance().charWidth(fmBI, 'W');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTabSize() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTabSize < 0) {
                this.myTabSize = EditorUtil.getTabSize(this.myEditor);
            }
            return this.myTabSize;
        }
    }

    private void setFontRenderContext(FontRenderContext context) {
        this.myFontRenderContext = context == null ? FontInfo.getFontRenderContext(this.myEditor.getContentComponent()) : context;
    }

    private void checkFontRenderContext(FontRenderContext context) {
        FontRenderContext oldContext = this.myFontRenderContext;
        this.setFontRenderContext(context);
        if (!this.myFontRenderContext.equals(oldContext)) {
            this.myTextLayoutCache.resetToDocumentSize(false);
            this.invalidateFoldRegionLayouts();
        }
    }

    LineLayout getFoldRegionLayout(FoldRegion foldRegion) {
        LineLayout layout = (LineLayout)foldRegion.getUserData(FOLD_REGION_TEXT_LAYOUT);
        if (layout == null) {
            TextAttributes placeholderAttributes = this.myEditor.getFoldingModel().getPlaceholderAttributes();
            layout = LineLayout.create(this, StringUtil.replace((String)foldRegion.getPlaceholderText(), (String)"\n", (String)" "), placeholderAttributes == null ? 0 : placeholderAttributes.getFontType());
            foldRegion.putUserData(FOLD_REGION_TEXT_LAYOUT, (Object)layout);
        }
        return layout;
    }

    void invalidateFoldRegionLayouts() {
        for (FoldRegion region : this.myEditor.getFoldingModel().getAllFoldRegions()) {
            region.putUserData(FOLD_REGION_TEXT_LAYOUT, null);
        }
    }

    Insets getInsets() {
        return this.myEditor.getContentComponent().getInsets();
    }

    int getBidiFlags() {
        return this.myBidiFlags;
    }

    private static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertIsReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    @Override
    public void drawChars(@NotNull Graphics g, @NotNull char[] data, int start, int end, int x, int y, Color color, FontInfo fontInfo) {
        this.myPainter.drawChars(g, data, start, end, x, y, color, fontInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String dumpState() {
        String prefixText = this.myPrefixText;
        TextAttributes prefixAttributes = this.myPrefixAttributes;
        Object object = this.myLock;
        synchronized (object) {
            return "[prefix text: " + prefixText + ", prefix attributes: " + prefixAttributes + ", space width: " + this.myPlainSpaceWidth + ", line height: " + this.myLineHeight + ", descent: " + this.myDescent + ", char height: " + this.myCharHeight + ", max char width: " + this.myMaxCharWidth + ", tab size: " + this.myTabSize + " ,size manager: " + this.mySizeManager.dumpState() + " ,logical position cache: " + this.myLogicalPositionCache.dumpState() + "]";
        }
    }

    public void validateState() {
        this.myLogicalPositionCache.validateState();
        this.mySizeManager.validateState();
    }

    private void assertNotInBulkMode() {
        if (this.myDocument instanceof DocumentImpl) {
            ((DocumentImpl)this.myDocument).assertNotInBulkUpdate();
        } else if (this.myDocument.isInBulkUpdate()) {
            throw new IllegalStateException("Current operation is not available in bulk mode");
        }
    }
}

