/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.ComplexTextFragment;
import com.intellij.openapi.editor.impl.view.SimpleTextFragment;
import com.intellij.openapi.editor.impl.view.TextFragment;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

class TextFragmentFactory {
    TextFragmentFactory() {
    }

    public static TextFragment createTextFragment(@NotNull char[] lineChars, int start, int end, boolean isRtl, @NotNull FontInfo fontInfo) {
        if (isRtl || fontInfo.getFont().hasLayoutAttributes() || TextFragmentFactory.isComplexText(lineChars, start, end)) {
            return new ComplexTextFragment(lineChars, start, end, isRtl, fontInfo);
        }
        return new SimpleTextFragment(lineChars, start, end, fontInfo);
    }

    private static boolean isComplexText(char[] chars, int start, int end) {
        return SwingUtilities2.isComplexLayout(chars, start, end);
    }
}

