/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizer;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectStructureCustomizerImpl
extends ExternalProjectStructureCustomizer {
    private final Set<? extends Key<? extends AbstractNamedData>> myKeys = ContainerUtil.set((Object[])new Key[]{ProjectKeys.PROJECT, ProjectKeys.MODULE});

    @Override
    @NotNull
    public Set<? extends Key<?>> getIgnorableDataKeys() {
        return this.myKeys;
    }

    @Override
    @NotNull
    public Set<? extends Key<?>> getPublicDataKeys() {
        return this.myKeys;
    }

    @Override
    @Nullable
    public Icon suggestIcon(@NotNull DataNode node, @NotNull ExternalSystemUiAware uiAware) {
        if (ProjectKeys.PROJECT.equals((Object)node.getKey())) {
            return uiAware.getProjectIcon();
        }
        if (ProjectKeys.MODULE.equals((Object)node.getKey())) {
            return uiAware.getProjectIcon();
        }
        return null;
    }

    @Override
    @NotNull
    public Couple<String> getRepresentationName(@NotNull DataNode node) {
        if (ProjectKeys.PROJECT.equals((Object)node.getKey())) {
            ProjectData projectData = (ProjectData)node.getData();
            return Couple.of((Object)("Project: " + projectData.getExternalName()), (Object)projectData.getDescription());
        }
        if (ProjectKeys.MODULE.equals((Object)node.getKey())) {
            ModuleData moduleData = (ModuleData)node.getData();
            return Couple.of((Object)moduleData.getId(), (Object)moduleData.getDescription());
        }
        return super.getRepresentationName(node);
    }
}

