/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSpec {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private ProgressExecutionMode myProgressExecutionMode;
    private boolean forceWhenUptodate;
    private boolean whenAutoImportEnabled;
    @Nullable
    private ExternalProjectRefreshCallback myCallback;

    public ImportSpec(@NotNull Project project2, @NotNull ProjectSystemId id) {
        this.myProject = project2;
        this.myExternalSystemId = id;
        this.myProgressExecutionMode = ProgressExecutionMode.MODAL_SYNC;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return this.myExternalSystemId;
    }

    @NotNull
    public ProgressExecutionMode getProgressExecutionMode() {
        return this.myProgressExecutionMode;
    }

    public void setProgressExecutionMode(@NotNull ProgressExecutionMode progressExecutionMode) {
        this.myProgressExecutionMode = progressExecutionMode;
    }

    public boolean isForceWhenUptodate() {
        return this.forceWhenUptodate;
    }

    public void setForceWhenUptodate(boolean forceWhenUptodate) {
        this.forceWhenUptodate = forceWhenUptodate;
    }

    public boolean isWhenAutoImportEnabled() {
        return this.whenAutoImportEnabled;
    }

    public void setWhenAutoImportEnabled(boolean whenAutoImportEnabled) {
        this.whenAutoImportEnabled = whenAutoImportEnabled;
    }

    public void setCallback(@Nullable ExternalProjectRefreshCallback callback) {
        this.myCallback = callback;
    }

    @Nullable
    public ExternalProjectRefreshCallback getCallback() {
        return this.myCallback;
    }
}

