/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.IntegrationKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemFacadeManager {
    private static final int REMOTE_FAIL_RECOVERY_ATTEMPTS_NUMBER = 3;
    private final ConcurrentMap<IntegrationKey, RemoteExternalSystemFacade> myFacadeWrappers = ContainerUtil.newConcurrentMap();
    private final Map<IntegrationKey, Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>> myRemoteFacades = ContainerUtil.newConcurrentMap();
    @NotNull
    private final Lock myLock = new ReentrantLock();
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager myProgressManager;
    @NotNull
    private final RemoteExternalSystemCommunicationManager myRemoteCommunicationManager;
    @NotNull
    private final InProcessExternalSystemCommunicationManager myInProcessCommunicationManager;

    public ExternalSystemFacadeManager(@NotNull ExternalSystemProgressNotificationManager notificationManager2, @NotNull RemoteExternalSystemCommunicationManager remoteCommunicationManager, @NotNull InProcessExternalSystemCommunicationManager inProcessCommunicationManager) {
        this.myProgressManager = (RemoteExternalSystemProgressNotificationManager)((Object)notificationManager2);
        this.myRemoteCommunicationManager = remoteCommunicationManager;
        this.myInProcessCommunicationManager = inProcessCommunicationManager;
    }

    @NotNull
    private static Project findProject(@NotNull IntegrationKey key2) {
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project2 : projectManager.getOpenProjects()) {
            if (!key2.getIdeProjectName().equals(project2.getName()) || !key2.getIdeProjectLocationHash().equals(project2.getLocationHash())) continue;
            return project2;
        }
        return projectManager.getDefaultProject();
    }

    public void onProjectRename(@NotNull String oldName, @NotNull String newName) {
        ExternalSystemFacadeManager.onProjectRename(this.myFacadeWrappers, oldName, newName);
        ExternalSystemFacadeManager.onProjectRename(this.myRemoteFacades, oldName, newName);
    }

    private static <V> void onProjectRename(@NotNull Map<IntegrationKey, V> data, @NotNull String oldName, @NotNull String newName) {
        HashSet keys = ContainerUtilRt.newHashSet(data.keySet());
        for (IntegrationKey key2 : keys) {
            if (!key2.getIdeProjectName().equals(oldName)) continue;
            IntegrationKey newKey = new IntegrationKey(newName, key2.getIdeProjectLocationHash(), key2.getExternalSystemId(), key2.getExternalProjectConfigPath());
            V value2 = data.get(key2);
            data.put(newKey, value2);
            data.remove(key2);
            if (!(value2 instanceof Consumer)) continue;
            ((Consumer)value2).consume((Object)newKey);
        }
    }

    @NotNull
    public RemoteExternalSystemFacade getFacade(@Nullable Project project2, @NotNull String externalProjectPath, @NotNull ProjectSystemId externalSystemId) throws Exception {
        IntegrationKey key2;
        RemoteExternalSystemFacade facade;
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        if ((facade = (RemoteExternalSystemFacade)this.myFacadeWrappers.get(key2 = new IntegrationKey(project2, externalSystemId, externalProjectPath))) == null) {
            RemoteExternalSystemFacade newFacade = (RemoteExternalSystemFacade)Proxy.newProxyInstance(ExternalSystemFacadeManager.class.getClassLoader(), new Class[]{RemoteExternalSystemFacade.class, Consumer.class}, (InvocationHandler)new MyHandler(key2));
            this.myFacadeWrappers.putIfAbsent(key2, newFacade);
        }
        return (RemoteExternalSystemFacade)this.myFacadeWrappers.get(key2);
    }

    public Object doInvoke(@NotNull IntegrationKey key2, @NotNull Project project2, Method method2, Object[] args, int invocationNumber) throws Throwable {
        RemoteExternalSystemFacade facade = this.doGetFacade(key2, project2);
        try {
            return method2.invoke((Object)facade, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RemoteException && invocationNumber > 0) {
                Thread.sleep(1000L);
                return this.doInvoke(key2, project2, method2, args, invocationNumber - 1);
            }
            throw e;
        }
    }

    public ExternalSystemCommunicationManager getCommunicationManager(@NotNull ProjectSystemId externalSystemId) {
        boolean currentInProcess = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)externalSystemId);
        return currentInProcess ? this.myInProcessCommunicationManager : this.myRemoteCommunicationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private RemoteExternalSystemFacade doGetFacade(@NotNull IntegrationKey key2, @NotNull Project project2) throws Exception {
        boolean currentInProcess = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)key2.getExternalSystemId());
        ExternalSystemCommunicationManager myCommunicationManager = currentInProcess ? this.myInProcessCommunicationManager : this.myRemoteCommunicationManager;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)key2.getExternalSystemId());
        if (project2.isDisposed() || manager == null) {
            return RemoteExternalSystemFacade.NULL_OBJECT;
        }
        Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair = this.myRemoteFacades.get(key2);
        if (pair != null && this.prepare(myCommunicationManager, project2, key2, pair)) {
            return (RemoteExternalSystemFacade)pair.first;
        }
        this.myLock.lock();
        try {
            pair = this.myRemoteFacades.get(key2);
            if (pair != null && this.prepare(myCommunicationManager, project2, key2, pair)) {
                RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)pair.first;
                return remoteExternalSystemFacade;
            }
            if (pair != null) {
                this.myFacadeWrappers.clear();
                this.myRemoteFacades.clear();
            }
            RemoteExternalSystemFacade remoteExternalSystemFacade = this.doCreateFacade(key2, project2, myCommunicationManager);
            return remoteExternalSystemFacade;
        }
        finally {
            this.myLock.unlock();
        }
    }

    @NotNull
    private RemoteExternalSystemFacade doCreateFacade(@NotNull IntegrationKey key2, @NotNull Project project2, @NotNull ExternalSystemCommunicationManager communicationManager) throws Exception {
        RemoteExternalSystemFacade facade = communicationManager.acquire(key2.getExternalProjectConfigPath(), key2.getExternalSystemId());
        if (facade == null) {
            throw new IllegalStateException("Can't obtain facade to working with external api at the remote process. Project: " + project2);
        }
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                ExternalSystemFacadeManager.this.myFacadeWrappers.clear();
                ExternalSystemFacadeManager.this.myRemoteFacades.clear();
            }
        });
        ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings> result2 = new ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings>(facade, this.myProgressManager);
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)project2, (String)key2.getExternalProjectConfigPath(), (ProjectSystemId)key2.getExternalSystemId());
        Pair newPair = Pair.create(result2, (Object)settings);
        this.myRemoteFacades.put(key2, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)newPair);
        result2.applySettings((ExternalSystemExecutionSettings)newPair.second);
        return result2;
    }

    private boolean prepare(@NotNull ExternalSystemCommunicationManager communicationManager, @NotNull Project project2, @NotNull IntegrationKey key2, @NotNull Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair) {
        if (!communicationManager.isAlive((RemoteExternalSystemFacade)pair.first)) {
            return false;
        }
        try {
            ExternalSystemExecutionSettings currentSettings = ExternalSystemApiUtil.getExecutionSettings((Project)project2, (String)key2.getExternalProjectConfigPath(), (ProjectSystemId)key2.getExternalSystemId());
            if (!currentSettings.equals(pair.second)) {
                ((RemoteExternalSystemFacade)pair.first).applySettings(currentSettings);
                this.myRemoteFacades.put(key2, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)Pair.create((Object)pair.first, (Object)currentSettings));
            }
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskActive(@NotNull ExternalSystemTaskId id) {
        HashMap copy = ContainerUtilRt.newHashMap(this.myRemoteFacades);
        for (Map.Entry entry : copy.entrySet()) {
            try {
                if (!((RemoteExternalSystemFacade)((Pair)entry.getValue()).first).isTaskInProgress(id)) continue;
                return true;
            }
            catch (RemoteException e) {
                this.myLock.lock();
                try {
                    this.myRemoteFacades.remove(entry.getKey());
                    this.myFacadeWrappers.remove(entry.getKey());
                }
                finally {
                    this.myLock.unlock();
                }
            }
        }
        return false;
    }

    private class MyHandler
    implements InvocationHandler {
        @NotNull
        private final AtomicReference<IntegrationKey> myKey = new AtomicReference();

        MyHandler(IntegrationKey key2) {
            this.myKey.set(key2);
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
            if ("consume".equals(method2.getName())) {
                this.myKey.set((IntegrationKey)args[0]);
                return null;
            }
            Project project2 = ExternalSystemFacadeManager.findProject(this.myKey.get());
            return ExternalSystemFacadeManager.this.doInvoke(this.myKey.get(), project2, method2, args, 3);
        }
    }
}

