/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemRuntimeConfigurationProducer
extends RuntimeConfigurationProducer {
    private PsiElement mySourceElement;

    public AbstractExternalSystemRuntimeConfigurationProducer(@NotNull AbstractExternalSystemTaskConfigurationType type2) {
        super((ConfigurationType)type2);
    }

    public PsiElement getSourceElement() {
        return this.mySourceElement;
    }

    @Nullable
    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        if (!(location instanceof ExternalSystemTaskLocation)) {
            return null;
        }
        ExternalSystemTaskLocation taskLocation = (ExternalSystemTaskLocation)location;
        this.mySourceElement = taskLocation.getPsiElement();
        RunManagerEx runManager = RunManagerEx.getInstanceEx(taskLocation.getProject());
        RunnerAndConfigurationSettings settings = runManager.createConfiguration("", this.getConfigurationFactory());
        ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)settings.getConfiguration();
        ExternalSystemTaskExecutionSettings taskExecutionSettings = configuration.getSettings();
        ExternalTaskExecutionInfo task = taskLocation.getTaskInfo();
        taskExecutionSettings.setExternalProjectPath(task.getSettings().getExternalProjectPath());
        taskExecutionSettings.setTaskNames(task.getSettings().getTaskNames());
        configuration.setName(AbstractExternalSystemTaskConfigurationType.generateName(location.getProject(), taskExecutionSettings));
        return settings;
    }

    @Nullable
    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurationsSettings, ConfigurationContext context) {
        if (!(location instanceof ExternalSystemTaskLocation)) {
            return null;
        }
        ExternalTaskExecutionInfo taskInfo = ((ExternalSystemTaskLocation)location).getTaskInfo();
        for (RunnerAndConfigurationSettings settings : existingConfigurationsSettings) {
            RunConfiguration runConfiguration = settings.getConfiguration();
            if (!(runConfiguration instanceof ExternalSystemRunConfiguration) || !AbstractExternalSystemRuntimeConfigurationProducer.match(taskInfo, ((ExternalSystemRunConfiguration)runConfiguration).getSettings())) continue;
            return settings;
        }
        return null;
    }

    private static boolean match(@NotNull ExternalTaskExecutionInfo task, @NotNull ExternalSystemTaskExecutionSettings settings) {
        if (!task.getSettings().getExternalProjectPath().equals(settings.getExternalProjectPath())) {
            return false;
        }
        List taskNames = settings.getTaskNames();
        return task.getSettings().getTaskNames().equals(taskNames);
    }

    public int compareTo(@NotNull Object o) {
        return -1;
    }
}

