/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemTaskConfigurationType
implements ConfigurationType {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final ConfigurationFactory[] myFactories = new ConfigurationFactory[1];
    @NotNull
    private final NotNullLazyValue<Icon> myIcon = new NotNullLazyValue<Icon>(){

        @NotNull
        protected Icon compute() {
            ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId);
            Icon result2 = null;
            if (manager instanceof ExternalSystemUiAware) {
                result2 = ((ExternalSystemUiAware)manager).getProjectIcon();
            }
            return result2 == null ? DefaultExternalSystemUiAware.INSTANCE.getTaskIcon() : result2;
        }
    };

    protected AbstractExternalSystemTaskConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        this.myExternalSystemId = externalSystemId;
        this.myFactories[0] = new ConfigurationFactory(this){

            @NotNull
            public RunConfiguration createTemplateConfiguration(@NotNull Project project2) {
                return AbstractExternalSystemTaskConfigurationType.this.doCreateConfiguration(AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId, project2, this, "");
            }
        };
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return this.myExternalSystemId;
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        return this.myFactories[0];
    }

    @NotNull
    protected ExternalSystemRunConfiguration doCreateConfiguration(@NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull ConfigurationFactory factory, @NotNull String name) {
        return new ExternalSystemRunConfiguration(externalSystemId, project2, factory, name);
    }

    public String getDisplayName() {
        return this.myExternalSystemId.getReadableName();
    }

    public String getConfigurationTypeDescription() {
        return ExternalSystemBundle.message((String)"run.configuration.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @NotNull
    public String getId() {
        return this.myExternalSystemId.getReadableName() + "RunConfiguration";
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return this.myFactories;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ExternalSystemTaskExecutionSettings settings) {
        return AbstractExternalSystemTaskConfigurationType.generateName(project2, settings.getExternalSystemId(), settings.getExternalProjectPath(), settings.getTaskNames(), settings.getExecutionName());
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ExternalTaskPojo task, @NotNull ProjectSystemId externalSystemId) {
        return AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemId, task.getLinkedExternalProjectPath(), Collections.singletonList(task.getName()));
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames) {
        return AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemId, externalProjectPath, taskNames, null);
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable String executionName) {
        String projectName;
        ExternalProjectInfo projectInfo;
        String rootProjectPath = null;
        if (externalProjectPath != null && (projectInfo = ExternalSystemUtil.getExternalProjectInfo(project2, externalSystemId, externalProjectPath)) != null) {
            rootProjectPath = projectInfo.getExternalProjectPath();
        }
        StringBuilder buffer = new StringBuilder();
        if (rootProjectPath == null) {
            projectName = null;
        } else {
            ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
            projectName = uiAware.getProjectRepresentationName(project2, externalProjectPath, rootProjectPath);
        }
        if (!StringUtil.isEmptyOrSpaces(projectName)) {
            buffer.append(projectName);
            buffer.append(' ');
        } else {
            buffer.append(externalProjectPath);
            buffer.append(' ');
        }
        buffer.append('[');
        if (!StringUtil.isEmpty((String)executionName)) {
            buffer.append(executionName);
        } else if (!taskNames.isEmpty()) {
            for (String taskName : taskNames) {
                buffer.append(taskName).append(' ');
            }
            buffer.setLength(buffer.length() - 1);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

