/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.callback.OpenProjectJdkSettingsCallback;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemNotificationExtensionImpl
implements ExternalSystemNotificationExtension {
    @Override
    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        return ProjectSystemId.IDE;
    }

    @Override
    public void customize(@NotNull NotificationData notification, @NotNull Project project2, @Nullable Throwable error) {
        if (error == null) {
            return;
        }
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof ExternalSystemException) {
            ExternalSystemNotificationExtensionImpl.updateNotification(notification, project2, (ExternalSystemException)unwrapped);
        }
    }

    private static void updateNotification(@NotNull NotificationData notificationData, @NotNull Project project2, @NotNull ExternalSystemException e) {
        for (String fix : e.getQuickFixes()) {
            if (!"#open_project_jdk_settings".equals(fix)) continue;
            notificationData.setListener("#open_project_jdk_settings", (NotificationListener)new OpenProjectJdkSettingsCallback(project2));
        }
    }
}

