/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification.callback;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalSystemConfigurable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenExternalSystemSettingsCallback
extends NotificationListener.Adapter {
    public static final String ID = "#open_external_system_settings";
    private final Project myProject;
    @NotNull
    private final ProjectSystemId mySystemId;
    @Nullable
    private final String myLinkedProjectPath;

    public OpenExternalSystemSettingsCallback(Project project2, @NotNull ProjectSystemId systemId) {
        this(project2, systemId, null);
    }

    public OpenExternalSystemSettingsCallback(Project project2, @NotNull ProjectSystemId systemId, @Nullable String linkedProjectPath) {
        this.myProject = project2;
        this.mySystemId = systemId;
        this.myLinkedProjectPath = linkedProjectPath;
    }

    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
        ExternalSystemManager manager;
        if (this.myLinkedProjectPath == null || !((manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.mySystemId)) instanceof ExternalSystemConfigurableAware)) {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.mySystemId.getReadableName());
            return;
        }
        Configurable configurable = ((ExternalSystemConfigurableAware)manager).getConfigurable(this.myProject);
        if (configurable instanceof AbstractExternalSystemConfigurable) {
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, configurable, () -> ((AbstractExternalSystemConfigurable)configurable).selectProject(this.myLinkedProjectPath));
        }
    }
}

