/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModelsProviderImpl
implements IdeModelsProvider {
    @NotNull
    protected final Project myProject;

    public IdeModelsProviderImpl(@NotNull Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public Module[] getModules() {
        return ModuleManager.getInstance((Project)this.myProject).getModules();
    }

    @NotNull
    public Module[] getModules(@NotNull ProjectData projectData) {
        List modules = ContainerUtil.filter((Object[])this.getModules(), module2 -> ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module2) && StringUtil.equals((CharSequence)projectData.getLinkedExternalProjectPath(), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2)));
        return (Module[])ContainerUtil.toArray((List)modules, (Object[])new Module[modules.size()]);
    }

    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module2) {
        return ModuleRootManager.getInstance((Module)module2).getOrderEntries();
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module2) {
        for (String candidate : this.suggestModuleNameCandidates(module2)) {
            Module ideModule = this.findIdeModule(candidate);
            if (ideModule == null || !IdeModelsProviderImpl.isApplicableIdeModule(module2, ideModule)) continue;
            return ideModule;
        }
        return null;
    }

    protected String[] suggestModuleNameCandidates(@NotNull ModuleData module2) {
        String prefix = module2.getGroup();
        File modulePath = new File(module2.getLinkedExternalProjectPath());
        if (modulePath.isFile()) {
            modulePath = modulePath.getParentFile();
        }
        if (modulePath.getParentFile() != null) {
            prefix = modulePath.getParentFile().getName();
        }
        return new String[]{module2.getInternalName(), prefix + '-' + module2.getInternalName(), prefix + '-' + module2.getInternalName() + "~1"};
    }

    private static boolean isApplicableIdeModule(@NotNull ModuleData moduleData, @NotNull Module ideModule) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)ideModule).getContentRoots()) {
            if (!FileUtil.pathsEqual((String)root.getPath(), (String)moduleData.getLinkedExternalProjectPath())) continue;
            return true;
        }
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)moduleData.getOwner(), (Module)ideModule) && FileUtil.pathsEqual((String)ExternalSystemApiUtil.getExternalProjectPath((Module)ideModule), (String)moduleData.getLinkedExternalProjectPath());
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(ideModuleName);
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull Module module2) {
        for (OrderEntry entry : this.getOrderEntries(module2)) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry candidate = (ModuleOrderEntry)entry;
            if (!dependency.getInternalName().equals(candidate.getModuleName()) || !dependency.getScope().equals((Object)candidate.getScope())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(@NotNull DependencyData data) {
        Module ownerIdeModule = this.findIdeModule(data.getOwnerModule());
        if (ownerIdeModule == null) {
            return null;
        }
        LibraryDependencyData libraryDependencyData = null;
        ModuleDependencyData moduleDependencyData = null;
        if (data instanceof LibraryDependencyData) {
            libraryDependencyData = (LibraryDependencyData)data;
        } else if (data instanceof ModuleDependencyData) {
            moduleDependencyData = (ModuleDependencyData)data;
        } else {
            return null;
        }
        for (OrderEntry entry : this.getOrderEntries(ownerIdeModule)) {
            String entryName;
            if (entry instanceof LibraryOrderEntry && libraryDependencyData != null) {
                if (((LibraryOrderEntry)entry).isModuleLevel() && libraryDependencyData.getLevel() != LibraryLevel.MODULE) continue;
                if (StringUtil.isEmpty((String)((LibraryOrderEntry)entry).getLibraryName())) {
                    Set paths = ContainerUtil.map2Set((Collection)((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), path -> PathUtil.getLocalPath((String)path));
                    Set entryPaths = ContainerUtil.map2Set((Object[])entry.getUrls(OrderRootType.CLASSES), s -> PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)s)));
                    if (!entryPaths.equals(paths) || ((LibraryOrderEntry)entry).getScope() != data.getScope()) continue;
                    return entry;
                }
            }
            String string = entryName = libraryDependencyData != null ? libraryDependencyData.getInternalName() : moduleDependencyData.getInternalName();
            if (!entryName.equals(entry.getPresentableName()) || entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).getScope() != data.getScope()) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public VirtualFile[] getContentRoots(Module module2) {
        return ModuleRootManager.getInstance((Module)module2).getContentRoots();
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2) {
        return ModuleRootManager.getInstance((Module)module2).getSourceRoots();
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2, boolean includingTests) {
        return ModuleRootManager.getInstance((Module)module2).getSourceRoots(includingTests);
    }

    @NotNull
    public Library[] getAllLibraries() {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraries();
    }

    @Nullable
    public Library getLibraryByName(String name) {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraryByName(name);
    }

    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type2) {
        return library.getUrls(type2);
    }

    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module2) {
        return ModuleUtilCore.getAllDependentModules((Module)module2);
    }
}

