/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.autoimport.FileChangeListenerBase;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.zip.CRC32;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProjectsWatcher
extends ExternalSystemTaskNotificationListenerAdapter {
    private static final Key<Long> CRC_WITHOUT_SPACES_CURRENT = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_CURRENT");
    private static final Key<Long> CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT");
    private static final int DOCUMENT_SAVE_DELAY = 1000;
    private final Project myProject;
    private final Set<Document> myChangedDocuments = new THashSet();
    private final MergingUpdateQueue myChangedDocumentsQueue;
    private final List<ExternalSystemAutoImportAware> myImportAwareManagers;
    private final MergingUpdateQueue myUpdatesQueue;
    private final Map<ProjectSystemId, MyNotification> myNotificationMap;
    private final MultiMap<String, String> myKnownAffectedFiles = MultiMap.createConcurrentSet();
    private final MultiMap<VirtualFilePointer, String> myFilesPointers = MultiMap.createConcurrentSet();
    private final List<LocalFileSystem.WatchRequest> myWatchedRoots = new ArrayList<LocalFileSystem.WatchRequest>();

    public ExternalSystemProjectsWatcher(Project project2) {
        this.myProject = project2;
        this.myChangedDocumentsQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Document changes queue", 1000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myImportAwareManagers = ContainerUtil.newArrayList();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(manager instanceof ExternalSystemAutoImportAware)) continue;
            this.myImportAwareManagers.add((ExternalSystemAutoImportAware)manager);
            NotificationsConfiguration.getNotificationsConfiguration().register(manager.getSystemId().getReadableName() + " Import", NotificationDisplayType.STICKY_BALLOON, false);
        }
        this.myUpdatesQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Notifier queue", 500, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myNotificationMap = ContainerUtil.newConcurrentMap();
    }

    public synchronized void start() {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        this.myUpdatesQueue.activate();
        MessageBusConnection myBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myChangedDocumentsQueue);
        myBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyFileChangeListener(this));
        ExternalSystemProjectsWatcher.makeUserAware(this.myChangedDocumentsQueue, this.myProject);
        this.myChangedDocumentsQueue.activate();
        DocumentAdapter myDocumentListener = new DocumentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(DocumentEvent event) {
                Document doc = event.getDocument();
                VirtualFile file2 = FileDocumentManager.getInstance().getFile(doc);
                if (file2 == null) {
                    return;
                }
                String externalProjectPath = ExternalSystemProjectsWatcher.this.getRelatedExternalProjectPath(file2);
                if (externalProjectPath == null) {
                    return;
                }
                Set set2 = ExternalSystemProjectsWatcher.this.myChangedDocuments;
                synchronized (set2) {
                    ExternalSystemProjectsWatcher.this.myChangedDocuments.add(doc);
                }
                ExternalSystemProjectsWatcher.this.myChangedDocumentsQueue.queue(new Update((Object)ExternalSystemProjectsWatcher.this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Document[] copy;
                        Set set2 = ExternalSystemProjectsWatcher.this.myChangedDocuments;
                        synchronized (set2) {
                            copy = ExternalSystemProjectsWatcher.this.myChangedDocuments.toArray(new Document[ExternalSystemProjectsWatcher.this.myChangedDocuments.size()]);
                            ExternalSystemProjectsWatcher.this.myChangedDocuments.clear();
                        }
                        ExternalSystemUtil.invokeLater(ExternalSystemProjectsWatcher.this.myProject, () -> new WriteAction(){

                            protected void run(@NotNull Result result2) throws Throwable {
                                for (Document each : copy) {
                                    PsiDocumentManager.getInstance((Project)ExternalSystemProjectsWatcher.this.myProject).commitDocument(each);
                                    ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveDocument(each, false);
                                }
                            }
                        }.execute());
                    }
                });
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)myDocumentListener, (Disposable)myBusConnection);
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).addNotificationListener((ExternalSystemTaskNotificationListener)this);
        this.updateWatchedRoots(true);
        Disposer.register((Disposable)this.myChangedDocumentsQueue, () -> this.myFilesPointers.clear());
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myChangedDocumentsQueue);
        Disposer.dispose((Disposable)this.myUpdatesQueue);
        this.myNotificationMap.clear();
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).removeNotificationListener((ExternalSystemTaskNotificationListener)this);
    }

    public void onQueued(@NotNull ExternalSystemTaskId id, final String workingDir) {
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            final ProjectSystemId systemId = id.getProjectSystemId();
            for (String filePath : ContainerUtil.newArrayList((Iterable)this.myKnownAffectedFiles.get((Object)workingDir))) {
                VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(filePath), (boolean)false);
                if (file2 == null || file2.isDirectory()) continue;
                file2.putUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT, file2.getUserData(CRC_WITHOUT_SPACES_CURRENT));
            }
            this.myUpdatesQueue.queue(new Update(Pair.create((Object)systemId, (Object)workingDir)){

                public void run() {
                    ExternalSystemProjectsWatcher.this.doUpdateNotifications(true, systemId, workingDir);
                }
            });
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id) {
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            this.updateWatchedRoots(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scheduleUpdate(final String projectPath) {
        Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject = this.findLinkedProjectSettings(projectPath);
        if (linkedProject == null) {
            return;
        }
        ExternalSystemManager manager = (ExternalSystemManager)linkedProject.first;
        final ProjectSystemId systemId = manager.getSystemId();
        boolean useAutoImport = ((ExternalProjectSettings)linkedProject.second).isUseAutoImport();
        if (useAutoImport) {
            ExternalSystemTaskState taskState;
            ExternalSystemTask resolveTask = ((ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, systemId, projectPath);
            ExternalSystemTaskState externalSystemTaskState = taskState = resolveTask == null ? null : resolveTask.getState();
            if (taskState == null || taskState.isStopped()) {
                ExternalSystemProjectsWatcher.scheduleRefresh(this.myProject, projectPath, systemId, false);
                return;
            }
            if (taskState == ExternalSystemTaskState.NOT_STARTED) return;
            return;
        } else {
            this.myUpdatesQueue.queue(new Update(Pair.create((Object)systemId, (Object)projectPath)){

                public void run() {
                    ExternalSystemProjectsWatcher.this.doUpdateNotifications(false, systemId, projectPath);
                }
            });
        }
    }

    private void updateWatchedRoots(boolean isProjectOpen) {
        SmartList pathsToWatch = new SmartList();
        this.myFilesPointers.clear();
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchedRoots);
        HashMap pointerMap = ContainerUtil.newHashMap();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(manager instanceof ExternalSystemAutoImportAware)) continue;
            ExternalSystemAutoImportAware importAware = (ExternalSystemAutoImportAware)manager;
            for (ExternalProjectSettings settings : ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings()) {
                List files = importAware.getAffectedExternalProjectFiles(settings.getExternalProjectPath(), this.myProject);
                long timeStamp = 0L;
                for (File file2 : files) {
                    timeStamp += file2.lastModified();
                }
                Map modificationStamps = ((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject)).getExternalConfigModificationStamps();
                if (isProjectOpen && this.myProject.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) != Boolean.TRUE) {
                    Long affectedFilesTimestamp = (Long)modificationStamps.get(settings.getExternalProjectPath());
                    affectedFilesTimestamp = affectedFilesTimestamp == null ? -1L : affectedFilesTimestamp;
                    if (timeStamp != affectedFilesTimestamp) {
                        this.scheduleUpdate(settings.getExternalProjectPath());
                    }
                } else {
                    modificationStamps.put(settings.getExternalProjectPath(), timeStamp);
                }
                for (File file3 : files) {
                    String path;
                    if (file3 == null || (path = ExternalSystemProjectsWatcher.getNormalizedPath(file3)) == null) continue;
                    pathsToWatch.add(path);
                    String url = VfsUtilCore.pathToUrl((String)path);
                    VirtualFilePointer pointer = (VirtualFilePointer)pointerMap.get(url);
                    if (pointer == null) {
                        Long crc;
                        pointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this.myChangedDocumentsQueue, null);
                        pointerMap.put(url, pointer);
                        VirtualFile virtualFile = pointer.getFile();
                        if (virtualFile != null && (crc = (Long)virtualFile.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT)) != null) {
                            modificationStamps.put(path, crc);
                        }
                    }
                    this.myFilesPointers.putValue((Object)pointer, (Object)settings.getExternalProjectPath());
                }
            }
        }
        this.myWatchedRoots.addAll(LocalFileSystem.getInstance().addRootsToWatch((Collection)pathsToWatch, false));
    }

    @Nullable
    private String getRelatedExternalProjectPath(VirtualFile file2) {
        String path = file2.getPath();
        return this.getRelatedExternalProjectPath(path);
    }

    @Nullable
    private String getRelatedExternalProjectPath(String path) {
        ExternalSystemAutoImportAware importAware;
        String externalProjectPath = null;
        Iterator<ExternalSystemAutoImportAware> iterator = this.myImportAwareManagers.iterator();
        while (iterator.hasNext() && (externalProjectPath = (importAware = iterator.next()).getAffectedExternalProjectPath(path, this.myProject)) == null) {
        }
        if (externalProjectPath != null) {
            this.myKnownAffectedFiles.putValue(externalProjectPath, (Object)path);
        }
        return externalProjectPath;
    }

    private void doUpdateNotifications(boolean close, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        MyNotification notification = this.myNotificationMap.get(systemId);
        if (close) {
            if (notification == null) {
                return;
            }
            notification.projectPaths.remove(projectPath);
            if (notification.projectPaths.isEmpty()) {
                notification.expire();
            }
        } else {
            if (notification != null && !notification.isExpired()) {
                notification.projectPaths.add(projectPath);
                return;
            }
            notification = new MyNotification(this.myProject, this.myNotificationMap, systemId, projectPath);
            this.myNotificationMap.put(systemId, notification);
            Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        }
    }

    private static void scheduleRefresh(final @NotNull Project project2, String projectPath, ProjectSystemId systemId, boolean reportRefreshError) {
        ExternalSystemUtil.refreshProject(project2, systemId, projectPath, new ExternalProjectRefreshCallback(){

            @Override
            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject != null) {
                    ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, true);
                }
            }

            @Override
            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
            }
        }, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, reportRefreshError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeUserAware(final MergingUpdateQueue mergingUpdateQueue, Project project2) {
        AccessToken accessToken = ReadAction.start();
        try {
            EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
            multicaster.addCaretListener((CaretListener)new CaretAdapter(){

                public void caretPositionChanged(CaretEvent e) {
                    mergingUpdateQueue.restartTimer();
                }
            }, (Disposable)mergingUpdateQueue);
            multicaster.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void documentChanged(DocumentEvent event) {
                    mergingUpdateQueue.restartTimer();
                }
            }, (Disposable)mergingUpdateQueue);
            project2.getMessageBus().connect((Disposable)mergingUpdateQueue).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
                int beforeCalled;

                public void beforeRootsChange(ModuleRootEvent event) {
                    if (this.beforeCalled++ == 0) {
                        mergingUpdateQueue.suspend();
                    }
                }

                public void rootsChanged(ModuleRootEvent event) {
                    if (this.beforeCalled == 0) {
                        return;
                    }
                    if (--this.beforeCalled == 0) {
                        mergingUpdateQueue.resume();
                        mergingUpdateQueue.restartTimer();
                    }
                }
            });
        }
        finally {
            accessToken.finish();
        }
    }

    @Nullable
    private Pair<ExternalSystemManager, ExternalProjectSettings> findLinkedProjectSettings(String projectPath) {
        ExternalProjectSettings[] linkedProjectSettings = new ExternalProjectSettings[1];
        Optional<ExternalSystemManager> systemManager = ExternalSystemApiUtil.getAllManagers().stream().filter(m -> {
            linkedProjectSettings[0] = ((AbstractExternalSystemSettings)m.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectSettings(projectPath);
            return linkedProjectSettings[0] != null;
        }).findAny();
        if (!systemManager.isPresent()) {
            return null;
        }
        ExternalSystemManager manager = systemManager.get();
        return Pair.create((Object)manager, (Object)linkedProjectSettings[0]);
    }

    @Nullable
    private static String getNormalizedPath(@NotNull File file2) {
        String canonized = PathUtil.getCanonicalPath((String)file2.getAbsolutePath());
        return canonized == null ? null : FileUtil.toSystemIndependentName((String)canonized);
    }

    @NotNull
    private Long calculateCrc(VirtualFile file2) {
        Long newCrc;
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile != null) {
            final CRC32 crc32 = new CRC32();
            ApplicationManager.getApplication().runReadAction(() -> psiFile.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    String text;
                    if (element instanceof LeafElement && !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment) && !(text = element.getText()).trim().isEmpty()) {
                        int end = text.length();
                        for (int i2 = 0; i2 < end; ++i2) {
                            crc32.update(text.charAt(i2));
                        }
                    }
                    super.visitElement(element);
                }
            }));
            newCrc = crc32.getValue();
        } else {
            newCrc = file2.getModificationStamp();
        }
        return newCrc;
    }

    private class MyFileChangeListener
    extends FileChangeListenerBase {
        private final ExternalSystemProjectsWatcher myWatcher;
        private MultiMap<String, String> myKnownFiles = MultiMap.createSet();
        private List<VirtualFile> filesToUpdate;
        private List<VirtualFile> filesToRemove;

        public MyFileChangeListener(ExternalSystemProjectsWatcher watcher) {
            this.myWatcher = watcher;
        }

        @Override
        protected boolean isRelevant(String path) {
            if (!this.myKnownFiles.get((Object)path).isEmpty()) {
                return true;
            }
            for (VirtualFilePointer pointer : ExternalSystemProjectsWatcher.this.myFilesPointers.keySet()) {
                VirtualFile f = pointer.getFile();
                if (f == null || !FileUtil.pathsEqual((String)path, (String)f.getPath())) continue;
                for (String projectPath : ExternalSystemProjectsWatcher.this.myFilesPointers.get((Object)pointer)) {
                    this.myKnownFiles.putValue((Object)path, (Object)projectPath);
                    ExternalSystemProjectsWatcher.this.myKnownAffectedFiles.putValue((Object)projectPath, (Object)path);
                }
                return true;
            }
            String affectedProjectPath = ExternalSystemProjectsWatcher.this.getRelatedExternalProjectPath(path);
            if (affectedProjectPath != null) {
                this.myKnownFiles.putValue((Object)path, (Object)affectedProjectPath);
            }
            return affectedProjectPath != null;
        }

        @Override
        protected void updateFile(VirtualFile file2, VFileEvent event) {
            this.doUpdateFile(file2, event, false);
        }

        @Override
        protected void deleteFile(VirtualFile file2, VFileEvent event) {
            this.doUpdateFile(file2, event, true);
        }

        private void doUpdateFile(VirtualFile file2, VFileEvent event, boolean remove) {
            this.init();
            if (remove) {
                this.filesToRemove.add(file2);
            } else if (this.fileWasChanged(file2, event)) {
                this.filesToUpdate.add(file2);
            } else {
                for (String externalProjectPath : this.myKnownFiles.get((Object)file2.getPath())) {
                    this.handleRevertedChanges(externalProjectPath);
                }
            }
        }

        private void handleRevertedChanges(final String externalProjectPath) {
            for (Object filePath : ContainerUtil.newArrayList((Iterable)ExternalSystemProjectsWatcher.this.myKnownAffectedFiles.get((Object)externalProjectPath))) {
                VirtualFile f = VfsUtil.findFileByIoFile((File)new File((String)filePath), (boolean)false);
                if (f != null && Objects.equals(f.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT), f.getUserData(CRC_WITHOUT_SPACES_CURRENT))) continue;
                return;
            }
            ProjectSystemId systemId = null;
            for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
                if (((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)ExternalSystemProjectsWatcher.this.myProject)).getLinkedProjectSettings(externalProjectPath) == null) continue;
                systemId = manager.getSystemId();
            }
            if (systemId != null) {
                final ProjectSystemId finalSystemId = systemId;
                ExternalSystemProjectsWatcher.this.myUpdatesQueue.queue(new Update(Pair.create(finalSystemId, (Object)externalProjectPath)){

                    public void run() {
                        ExternalSystemProjectsWatcher.this.doUpdateNotifications(true, finalSystemId, externalProjectPath);
                    }
                });
            }
        }

        private boolean fileWasChanged(VirtualFile file2, VFileEvent event) {
            if (!file2.isValid() || !(event instanceof VFileContentChangeEvent)) {
                return true;
            }
            Long newCrc = ExternalSystemProjectsWatcher.this.calculateCrc(file2);
            file2.putUserData(CRC_WITHOUT_SPACES_CURRENT, (Object)newCrc);
            Long crc = (Long)file2.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT);
            if (crc == null) {
                file2.putUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT, (Object)newCrc);
                return true;
            }
            return !newCrc.equals(crc);
        }

        @Override
        protected void apply() {
            if (this.areFileSetsInitialised()) {
                this.filesToUpdate.removeAll(this.filesToRemove);
                this.scheduleUpdate(ContainerUtil.concat(this.filesToUpdate, this.filesToRemove));
            }
            this.clear();
        }

        private boolean areFileSetsInitialised() {
            return this.filesToUpdate != null;
        }

        private void scheduleUpdate(List<VirtualFile> filesToUpdate) {
            filesToUpdate.stream().flatMap(f -> this.myKnownFiles.get((Object)f.getPath()).stream()).distinct().forEach(path -> this.myWatcher.scheduleUpdate(path));
        }

        private void init() {
            if (this.areFileSetsInitialised()) {
                return;
            }
            this.filesToUpdate = new ArrayList<VirtualFile>();
            this.filesToRemove = new ArrayList<VirtualFile>();
        }

        private void clear() {
            this.filesToUpdate = null;
            this.filesToRemove = null;
            this.myKnownFiles.clear();
        }
    }

    private static class MyNotification
    extends Notification {
        private final ProjectSystemId mySystemId;
        private final Map<ProjectSystemId, MyNotification> myNotificationMap;
        private final Set<String> projectPaths;

        public MyNotification(final Project project2, Map<ProjectSystemId, MyNotification> notificationMap, final ProjectSystemId systemId, String projectPath) {
            super(systemId.getReadableName() + " Import", ExternalSystemBundle.message((String)"import.needed", (Object[])new Object[]{systemId.getReadableName()}), "<a href='reimport'>" + ExternalSystemBundle.message((String)"import.importChanged", (Object[])new Object[0]) + "</a> &nbsp;&nbsp;<a href='autoImport'>" + ExternalSystemBundle.message((String)"import.enableAutoImport", (Object[])new Object[0]) + "</a>", NotificationType.INFORMATION, null);
            this.mySystemId = systemId;
            this.myNotificationMap = notificationMap;
            this.projectPaths = ContainerUtil.newHashSet((Object[])new String[]{projectPath});
            this.setListener((NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    boolean isReimport = event.getDescription().equals("reimport");
                    boolean isAutoImport = event.getDescription().equals("autoImport");
                    projectPaths.stream().map(path -> ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)systemId).getLinkedProjectSettings(path)).distinct().filter(Objects::nonNull).forEach(settings -> {
                        if (isReimport) {
                            ExternalSystemProjectsWatcher.scheduleRefresh(project2, settings.getExternalProjectPath(), systemId, true);
                        }
                        if (isAutoImport) {
                            settings.setUseAutoImport(true);
                            ExternalSystemProjectsWatcher.scheduleRefresh(project2, settings.getExternalProjectPath(), systemId, false);
                        }
                    });
                    notification.expire();
                }
            });
        }

        public void expire() {
            super.expire();
            this.projectPaths.clear();
            this.myNotificationMap.remove(this.mySystemId);
        }
    }
}

