/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleDataService<E extends ModuleData>
extends AbstractProjectDataService<E, Module> {
    public static final Key<ModuleData> MODULE_DATA_KEY = Key.create((String)"MODULE_DATA_KEY");
    public static final Key<Module> MODULE_KEY = Key.create((String)"LINKED_MODULE");
    public static final Key<Map<OrderEntry, OrderAware>> ORDERED_DATA_MAP_KEY = Key.create((String)"ORDER_ENTRY_DATA_MAP");
    public static final Key<Set<String>> ORPHAN_MODULE_FILES = Key.create((String)"ORPHAN_FILES");
    private static final Logger LOG = Logger.getInstance(AbstractModuleDataService.class);

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module module2;
        if (toImport.isEmpty()) {
            return;
        }
        Collection<DataNode<E>> toCreate = this.filterExistingModules(toImport, modelsProvider, project2);
        if (!toCreate.isEmpty()) {
            this.createModules(toCreate, modelsProvider, project2);
        }
        for (DataNode<E> node : toImport) {
            module2 = (Module)node.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            String productionModuleId = ((ModuleData)node.getData()).getProductionModuleId();
            modelsProvider.setTestModuleProperties(module2, productionModuleId);
            this.setModuleOptions(module2, node);
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
            AbstractModuleDataService.syncPaths(module2, modifiableRootModel, (ModuleData)node.getData());
            this.setLanguageLevel(modifiableRootModel, (ModuleData)node.getData());
        }
        for (DataNode<E> node : toImport) {
            module2 = (Module)node.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            String[] groupPath = ((ModuleData)node.getData()).getIdeModuleGroup();
            ModifiableModuleModel modifiableModel = modelsProvider.getModifiableModuleModel();
            modifiableModel.setModuleGroupPath(module2, groupPath);
        }
    }

    private void createModules(@NotNull Collection<DataNode<E>> toCreate, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2) {
        for (DataNode<E> module2 : toCreate) {
            ModuleData data = (ModuleData)module2.getData();
            Module created = modelsProvider.newModule(data);
            module2.putUserData(MODULE_KEY, (Object)created);
            Set orphanFiles = (Set)project2.getUserData(ORPHAN_MODULE_FILES);
            if (orphanFiles != null) {
                orphanFiles.remove(created.getModuleFilePath());
            }
            final ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(created);
            modifiableRootModel.inheritSdk();
            RootPolicy<Object> visitor = new RootPolicy<Object>(){

                public Object visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Object value2) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                    return value2;
                }

                public Object visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Object value2) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                    return value2;
                }
            };
            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                orderEntry.accept((RootPolicy)visitor, null);
            }
        }
    }

    @NotNull
    private Collection<DataNode<E>> filterExistingModules(@NotNull Collection<DataNode<E>> modules, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2) {
        ArrayList result2 = ContainerUtilRt.newArrayList();
        for (DataNode<E> node : modules) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module2 = modelsProvider.findIdeModule(moduleData);
            if (module2 == null) {
                result2.add(node);
                continue;
            }
            node.putUserData(MODULE_KEY, (Object)module2);
        }
        return result2;
    }

    private static void syncPaths(@NotNull Module module2, @NotNull ModifiableRootModel modifiableModel, @NotNull ModuleData data) {
        CompilerModuleExtension extension = (CompilerModuleExtension)modifiableModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            LOG.warn(String.format("Can't sync paths for module '%s'. Reason: no compiler extension is found for it", module2.getName()));
            return;
        }
        String compileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
        extension.setCompilerOutputPath(compileOutputPath != null ? VfsUtilCore.pathToUrl((String)compileOutputPath) : null);
        String testCompileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.TEST);
        extension.setCompilerOutputPathForTests(testCompileOutputPath != null ? VfsUtilCore.pathToUrl((String)testCompileOutputPath) : null);
        extension.inheritCompilerOutputPath(data.isInheritProjectCompileOutputPath());
    }

    public void removeData(@NotNull Computable<Collection<Module>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Collection toRemove = (Collection)toRemoveComputable.compute();
        SmartList modules = new SmartList(toRemove);
        for (DataNode<E> moduleDataNode : toIgnore) {
            Module module2 = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            ContainerUtil.addIfNotNull((Collection)modules, (Object)module2);
        }
        if (modules.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates((Collection)modules);
        for (Module module3 : modules) {
            if (module3.isDisposed()) continue;
            AbstractModuleDataService.unlinkModuleFromExternalSystem(module3);
        }
        AbstractModuleDataService.ruleOrphanModules((List<Module>)modules, project2, projectData.getOwner(), (Consumer<List<Module>>)((Consumer)modules1 -> {
            for (Module module2 : modules1) {
                if (module2.isDisposed()) continue;
                String path = module2.getModuleFilePath();
                ModifiableModuleModel moduleModel = modelsProvider.getModifiableModuleModel();
                moduleModel.disposeModule(module2);
                ModuleBuilder.deleteModuleFile((String)path);
            }
        }));
    }

    private static void ruleOrphanModules(@NotNull List<Module> orphanModules, @NotNull Project project2, final @NotNull ProjectSystemId externalSystemId, @NotNull Consumer<List<Module>> result2) {
        ExternalSystemApiUtil.executeOnEdt((boolean)true, () -> {
            List toRemove = ContainerUtil.newSmartList();
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                toRemove.addAll(orphanModules);
            } else {
                final JPanel content = new JPanel(new GridBagLayout());
                content.add((Component)new JLabel(ExternalSystemBundle.message((String)"orphan.modules.text", (Object[])new Object[]{externalSystemId.getReadableName()})), ExternalSystemUiUtil.getFillLineConstraints(0));
                CheckBoxList orphanModulesList = new CheckBoxList();
                orphanModulesList.setSelectionMode(2);
                orphanModulesList.setItems(orphanModules, module2 -> module2.getName());
                for (Module module3 : orphanModules) {
                    orphanModulesList.setItemSelected((Object)module3, true);
                }
                orphanModulesList.setBorder(IdeBorderFactory.createEmptyBorder((int)8));
                content.add((Component)orphanModulesList, ExternalSystemUiUtil.getFillLineConstraints(0));
                content.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)8, (int)0));
                DialogWrapper dialog2 = new DialogWrapper(project2){
                    {
                        super(arg0);
                        this.setTitle(ExternalSystemBundle.message((String)"import.title", (Object[])new Object[]{externalSystemId.getReadableName()}));
                        this.init();
                    }

                    @Nullable
                    protected JComponent createCenterPanel() {
                        return new JBScrollPane((Component)content);
                    }

                    @NotNull
                    protected Action[] createActions() {
                        return new Action[]{this.getOKAction()};
                    }
                };
                dialog2.showAndGet();
                for (int i2 = 0; i2 < orphanModules.size(); ++i2) {
                    Module module4 = (Module)orphanModules.get(i2);
                    if (!orphanModulesList.isItemSelected(i2)) continue;
                    toRemove.add(module4);
                }
            }
            result2.consume((Object)toRemove);
        });
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module2) {
        module2.clearOption("external.system.id");
        module2.clearOption("external.linked.project.id");
        module2.clearOption("external.linked.project.path");
        module2.clearOption("external.root.project.path");
        module2.clearOption("external.system.module.group");
        module2.clearOption("external.system.module.version");
    }

    protected void setModuleOptions(Module module2, DataNode<E> moduleDataNode) {
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        module2.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        module2.setOption("external.system.id", moduleData.getOwner().toString());
        module2.setOption("external.linked.project.id", moduleData.getId());
        module2.setOption("external.linked.project.path", moduleData.getLinkedExternalProjectPath());
        ProjectData projectData = (ProjectData)moduleDataNode.getData(ProjectKeys.PROJECT);
        module2.setOption("external.root.project.path", projectData != null ? projectData.getLinkedExternalProjectPath() : "");
        if (moduleData.getGroup() != null) {
            module2.setOption("external.system.module.group", moduleData.getGroup());
        }
        if (moduleData.getVersion() != null) {
            module2.setOption("external.system.module.version", moduleData.getVersion());
        }
        module2.clearOption("org.jetbrains.idea.maven.project.MavenProjectsManager.isMavenModule");
    }

    public void postProcess(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (DataNode<E> moduleDataNode : toImport) {
            Module module2 = (Module)moduleDataNode.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            Map orderAwareMap = (Map)moduleDataNode.getUserData(ORDERED_DATA_MAP_KEY);
            if (orderAwareMap != null) {
                this.rearrangeOrderEntries(orderAwareMap, modelsProvider.getModifiableRootModel(module2));
            }
            this.setBytecodeTargetLevel(project2, module2, (ModuleData)moduleDataNode.getData());
        }
        for (Module module3 : modelsProvider.getModules()) {
            module3.putUserData(MODULE_DATA_KEY, null);
        }
    }

    public void onSuccessImport(@NotNull Project project2) {
        Set orphanFiles = (Set)project2.getUserData(ORPHAN_MODULE_FILES);
        if (orphanFiles != null && !orphanFiles.isEmpty()) {
            ExternalSystemApiUtil.executeOnEdt((boolean)false, () -> {
                for (String orphanFile : orphanFiles) {
                    ModuleBuilder.deleteModuleFile((String)orphanFile);
                }
            });
            project2.putUserData(ORPHAN_MODULE_FILES, null);
        }
    }

    protected void rearrangeOrderEntries(@NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel modifiableRootModel) {
        Pair pair;
        OrderAware orderAware;
        OrderEntry orderEntry;
        Object[] orderEntries = modifiableRootModel.getOrderEntries();
        int length = orderEntries.length;
        Object[] newOrder = new OrderEntry[length];
        PriorityQueue<Pair> priorityQueue = new PriorityQueue<Pair>(11, (o1, o2) -> {
            int order2;
            int order1 = ((OrderAware)o1.second).getOrder();
            return order1 != (order2 = ((OrderAware)o2.second).getOrder()) ? (order1 < order2 ? -1 : 1) : 0;
        });
        int shift = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            orderEntry = orderEntries[i2];
            orderAware = orderEntryDataMap.get(orderEntry);
            if (orderAware == null) {
                newOrder[i2] = orderEntry;
                ++shift;
                continue;
            }
            priorityQueue.add(Pair.create((Object)orderEntry, (Object)orderAware));
        }
        while ((pair = (Pair)priorityQueue.poll()) != null) {
            orderEntry = (OrderEntry)pair.first;
            orderAware = (OrderAware)pair.second;
            int order = orderAware.getOrder() != -1 ? orderAware.getOrder() : length - 1;
            int newPlace = AbstractModuleDataService.findNewPlace((OrderEntry[])newOrder, order - shift);
            assert (newPlace != -1);
            newOrder[newPlace] = orderEntry;
        }
        if (LOG.isDebugEnabled()) {
            boolean changed = !ArrayUtil.equals((Object[])orderEntries, (Object[])newOrder, (Comparator)new Comparator<OrderEntry>(){

                @Override
                public int compare(OrderEntry o1, OrderEntry o2) {
                    return o1.compareTo((Object)o2);
                }
            });
            LOG.debug(String.format("rearrange status (%s): %s", modifiableRootModel.getModule(), changed ? "modified" : "not modified"));
        }
        modifiableRootModel.rearrangeOrderEntries((OrderEntry[])newOrder);
    }

    private static int findNewPlace(OrderEntry[] newOrder, int newIndex) {
        int idx;
        for (idx = newIndex; idx < 0 || idx < newOrder.length && newOrder[idx] != null; ++idx) {
        }
        if (idx >= newOrder.length) {
            for (idx = newIndex - 1; idx >= 0 && (idx >= newOrder.length || newOrder[idx] != null); --idx) {
            }
        }
        return idx == -1 ? -1 : idx;
    }

    private void setLanguageLevel(@NotNull ModifiableRootModel modifiableRootModel, E data) {
        LanguageLevel level = LanguageLevel.parse((String)data.getSourceCompatibility());
        if (level != null) {
            try {
                ((LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    private void setBytecodeTargetLevel(@NotNull Project project2, @NotNull Module module2, @NotNull E data) {
        String targetLevel = data.getTargetCompatibility();
        if (targetLevel != null) {
            CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)project2);
            configuration.setBytecodeTargetLevel(module2, targetLevel);
        }
    }
}

