/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.ui.SelectExternalTaskDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import icons.ExternalSystemIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemKeymapExtension
implements KeymapExtension {
    public KeymapGroup createGroup(Condition<AnAction> condition2, final Project project2) {
        AnAction[] externalSystemActions;
        KeymapGroup result2 = KeymapGroupFactory.getInstance().createGroup(ExternalSystemBundle.message((String)"external.system.keymap.group", (Object[])new Object[0]), ExternalSystemIcons.TaskGroup);
        for (AnAction action : externalSystemActions = ActionsTreeUtil.getActions("ExternalSystem.Actions")) {
            ActionsTreeUtil.addAction(result2, action, condition2);
        }
        if (project2 == null) {
            return result2;
        }
        MultiMap projectToActionsMapping = MultiMap.create();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            projectToActionsMapping.putValues((Object)manager.getSystemId(), (Collection)ContainerUtil.emptyList());
        }
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager != null) {
            for (String eachId : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, null))) {
                AnAction anAction = actionManager.getAction(eachId);
                if (!(anAction instanceof MyExternalSystemAction) || condition2 != null && !condition2.value((Object)actionManager.getActionOrStub(eachId))) continue;
                MyExternalSystemAction taskAction = (MyExternalSystemAction)anAction;
                projectToActionsMapping.putValue((Object)taskAction.getSystemId(), (Object)eachId);
            }
        }
        HashMap keymapGroupMap = ContainerUtil.newHashMap();
        for (ProjectSystemId systemId : projectToActionsMapping.keySet()) {
            if (keymapGroupMap.containsKey(systemId)) continue;
            Icon projectIcon = ExternalSystemUiUtil.getUiAware(systemId).getProjectIcon();
            KeymapGroup keymapGroup = KeymapGroupFactory.getInstance().createGroup(systemId.getReadableName(), projectIcon);
            keymapGroupMap.put(systemId, keymapGroup);
        }
        for (Map.Entry each : projectToActionsMapping.entrySet()) {
            Collection tasks = (Collection)each.getValue();
            final ProjectSystemId projectSystemId = (ProjectSystemId)each.getKey();
            KeymapGroup systemGroup = (KeymapGroup)keymapGroupMap.get(projectSystemId);
            if (systemGroup == null) continue;
            for (String actionId : tasks) {
                systemGroup.addActionId(actionId);
            }
            if (!(systemGroup instanceof Group)) continue;
            Icon icon = SystemInfoRt.isMac ? AllIcons.ToolbarDecorator.Mac.Add : AllIcons.ToolbarDecorator.Add;
            ((Group)systemGroup).addHyperlink(new Hyperlink(icon, "Choose a task to assign a shortcut"){

                @Override
                public void onClick(MouseEvent e) {
                    SelectExternalTaskDialog dialog2 = new SelectExternalTaskDialog(projectSystemId, project2);
                    if (dialog2.showAndGet() && dialog2.getResult() != null) {
                        KeymapPanel keymapPanel;
                        TaskData taskData = (TaskData)dialog2.getResult().second;
                        String ownerModuleName = (String)dialog2.getResult().first;
                        ExternalSystemTaskAction externalSystemAction = (ExternalSystemTaskAction)ExternalSystemKeymapExtension.getOrRegisterAction(project2, ownerModuleName, taskData);
                        ((KeymapListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(KeymapListener.CHANGE_TOPIC)).processCurrentKeymapChanged();
                        Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext(e.getComponent()));
                        KeymapPanel keymapPanel2 = keymapPanel = allSettings != null ? allSettings.find(KeymapPanel.class) : null;
                        if (keymapPanel != null) {
                            keymapPanel.showOption("");
                            keymapPanel.selectAction(externalSystemAction.myId);
                        }
                    }
                }
            });
        }
        for (KeymapGroup keymapGroup : keymapGroupMap.values()) {
            if (!ExternalSystemKeymapExtension.isGroupFiltered(condition2, keymapGroup)) continue;
            result2.addGroup(keymapGroup);
        }
        for (Iterator<Object> iterator : (ActionsProvider[])ActionsProvider.EP_NAME.getExtensions()) {
            KeymapGroup keymapGroup = iterator.createGroup(condition2, project2);
            if (!ExternalSystemKeymapExtension.isGroupFiltered(condition2, keymapGroup)) continue;
            result2.addGroup(keymapGroup);
        }
        return result2;
    }

    public static void updateActions(Project project2, Collection<DataNode<TaskData>> taskData) {
        ExternalSystemKeymapExtension.clearActions(project2, taskData);
        ExternalSystemKeymapExtension.createActions(project2, taskData);
    }

    public static ExternalSystemAction getOrRegisterAction(Project project2, String group, TaskData taskData) {
        ExternalSystemTaskAction action = new ExternalSystemTaskAction(project2, group, taskData);
        ActionManager manager = ActionManager.getInstance();
        AnAction anAction = manager.getAction(action.getId());
        if (anAction instanceof ExternalSystemTaskAction && action.equals(anAction)) {
            return (ExternalSystemAction)anAction;
        }
        manager.unregisterAction(action.getId());
        manager.registerAction(action.getId(), (AnAction)action);
        return action;
    }

    private static boolean isGroupFiltered(Condition<AnAction> condition2, KeymapGroup keymapGroup) {
        Group group;
        EmptyAction emptyAction = new EmptyAction();
        return condition2 == null || condition2.value((Object)emptyAction) || !(keymapGroup instanceof Group) || (group = (Group)keymapGroup).getSize() > 1 || condition2.value((Object)new EmptyAction(group.getName(), null, null));
    }

    private static void createActions(Project project2, Collection<DataNode<TaskData>> taskNodes) {
        ActionManager actionManager = ActionManager.getInstance();
        ExternalSystemShortcutsManager shortcutsManager = ExternalProjectsManager.getInstance(project2).getShortcutsManager();
        if (actionManager != null) {
            for (DataNode<TaskData> each : taskNodes) {
                DataNode moduleData = ExternalSystemApiUtil.findParent(each, (Key)ProjectKeys.MODULE);
                if (moduleData == null || moduleData.isIgnored()) continue;
                TaskData taskData = (TaskData)each.getData();
                ExternalSystemTaskAction eachAction = new ExternalSystemTaskAction(project2, ((ModuleData)moduleData.getData()).getInternalName(), taskData);
                actionManager.unregisterAction(eachAction.getId());
                if (!shortcutsManager.hasShortcuts(taskData.getLinkedExternalProjectPath(), taskData.getName())) continue;
                actionManager.registerAction(eachAction.getId(), (AnAction)eachAction);
            }
        }
    }

    public static void clearActions(Project project2) {
        ActionManager manager = ActionManager.getInstance();
        if (manager != null) {
            for (String each : manager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, null))) {
                manager.unregisterAction(each);
            }
        }
    }

    public static void clearActions(Project project2, Collection<DataNode<TaskData>> taskData) {
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager != null) {
            for (DataNode<TaskData> each : taskData) {
                for (String eachAction : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, ((TaskData)each.getData()).getLinkedExternalProjectPath()))) {
                    AnAction action = actionManager.getAction(eachAction);
                    if (action instanceof ExternalSystemRunConfigurationAction) continue;
                    actionManager.unregisterAction(eachAction);
                }
            }
        }
    }

    public static String getActionPrefix(@NotNull Project project2, @Nullable String path) {
        return ExternalProjectsManager.getInstance(project2).getShortcutsManager().getActionId(path, null);
    }

    public static void updateRunConfigurationActions(Project project2, ProjectSystemId systemId) {
        AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(systemId);
        if (configurationType == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (String eachAction : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, null))) {
            AnAction action = actionManager.getAction(eachAction);
            if (!(action instanceof ExternalSystemRunConfigurationAction)) continue;
            actionManager.unregisterAction(eachAction);
        }
        THashSet settings = new THashSet((Collection)RunManager.getInstance((Project)project2).getConfigurationSettingsList((ConfigurationType)configurationType));
        ExternalSystemShortcutsManager shortcutsManager = ExternalProjectsManager.getInstance(project2).getShortcutsManager();
        for (RunnerAndConfigurationSettings configurationSettings : settings) {
            ExternalSystemRunConfigurationAction runConfigurationAction = new ExternalSystemRunConfigurationAction(project2, configurationSettings);
            String id = runConfigurationAction.getId();
            actionManager.unregisterAction(id);
            if (!shortcutsManager.hasShortcuts(id)) continue;
            actionManager.registerAction(id, (AnAction)runConfigurationAction);
        }
    }

    public static ExternalSystemAction getOrRegisterAction(Project project2, RunnerAndConfigurationSettings configurationSettings) {
        ActionManager manager = ActionManager.getInstance();
        ExternalSystemRunConfigurationAction runConfigurationAction = new ExternalSystemRunConfigurationAction(project2, configurationSettings);
        String id = runConfigurationAction.getId();
        manager.unregisterAction(id);
        manager.registerAction(id, (AnAction)runConfigurationAction);
        return runConfigurationAction;
    }

    private static class ExternalSystemRunConfigurationAction
    extends MyExternalSystemAction {
        private final String myId;
        private final String myGroup;
        private final RunnerAndConfigurationSettings myConfigurationSettings;
        private final ProjectSystemId systemId;

        public ExternalSystemRunConfigurationAction(Project project2, RunnerAndConfigurationSettings configurationSettings) {
            this.myConfigurationSettings = configurationSettings;
            ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)configurationSettings.getConfiguration();
            this.systemId = runConfiguration.getSettings().getExternalSystemId();
            ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(this.systemId);
            this.myGroup = uiAware.getProjectRepresentationName(runConfiguration.getSettings().getExternalProjectPath(), null);
            String actionIdPrefix = ExternalSystemKeymapExtension.getActionPrefix(project2, runConfiguration.getSettings().getExternalProjectPath());
            this.myId = actionIdPrefix + configurationSettings.getName();
            Presentation template = this.getTemplatePresentation();
            template.setText(this.myConfigurationSettings.getName(), false);
            template.setIcon(runConfiguration.getIcon());
        }

        @Override
        protected boolean isEnabled(AnActionEvent e) {
            return this.hasProject(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ProgramRunnerUtil.executeConfiguration(this.getProject(e), this.myConfigurationSettings, DefaultRunExecutor.getRunExecutorInstance());
        }

        public String toString() {
            return this.myConfigurationSettings.toString();
        }

        @Override
        public String getGroup() {
            return this.myGroup;
        }

        @Override
        public ProjectSystemId getSystemId() {
            return this.systemId;
        }

        @Override
        public String getId() {
            return this.myId;
        }
    }

    private static class ExternalSystemTaskAction
    extends MyExternalSystemAction {
        private final String myId;
        private final String myGroup;
        private final TaskData myTaskData;

        public ExternalSystemTaskAction(Project project2, String group, TaskData taskData) {
            this.myGroup = group;
            this.myTaskData = taskData;
            this.myId = ExternalSystemKeymapExtension.getActionPrefix(project2, taskData.getLinkedExternalProjectPath()) + taskData.getName();
            Presentation template = this.getTemplatePresentation();
            template.setText(this.myTaskData.getName() + " (" + group + ")", false);
            template.setDescription(this.myTaskData.getOwner().getReadableName() + " task action");
            template.setIcon(ExternalSystemIcons.Task);
        }

        @Override
        protected boolean isEnabled(AnActionEvent e) {
            return this.hasProject(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ExternalTaskExecutionInfo taskExecutionInfo = ExternalSystemActionUtil.buildTaskInfo(this.myTaskData);
            ExternalSystemUtil.runTask(taskExecutionInfo.getSettings(), taskExecutionInfo.getExecutorId(), this.getProject(e), this.myTaskData.getOwner());
        }

        public TaskData getTaskData() {
            return this.myTaskData;
        }

        public String toString() {
            return this.myTaskData.toString();
        }

        @Override
        public String getGroup() {
            return this.myGroup;
        }

        @Override
        public ProjectSystemId getSystemId() {
            return this.myTaskData.getOwner();
        }

        @Override
        public String getId() {
            return this.myId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExternalSystemTaskAction)) {
                return false;
            }
            ExternalSystemTaskAction action = (ExternalSystemTaskAction)((Object)o);
            if (this.myId != null ? !this.myId.equals(action.myId) : action.myId != null) {
                return false;
            }
            if (this.myGroup != null ? !this.myGroup.equals(action.myGroup) : action.myGroup != null) {
                return false;
            }
            return this.myTaskData.equals((Object)action.myTaskData);
        }

        public int hashCode() {
            int result2 = this.myId != null ? this.myId.hashCode() : 0;
            result2 = 31 * result2 + (this.myGroup != null ? this.myGroup.hashCode() : 0);
            result2 = 31 * result2 + this.myTaskData.hashCode();
            return result2;
        }
    }

    private static abstract class MyExternalSystemAction
    extends ExternalSystemAction {
        private MyExternalSystemAction() {
        }

        public abstract String getId();

        public abstract String getGroup();

        public abstract ProjectSystemId getSystemId();
    }

    public static interface ActionsProvider {
        public static final ExtensionPointName<ActionsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalSystemKeymapProvider");

        public KeymapGroup createGroup(Condition<AnAction> var1, Project var2);
    }
}

