/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class ExternalSystemRunManagerListener
implements RunManagerListener {
    private ExternalProjectsManager myManager;
    private final Map<Integer, Pair<String, RunnerAndConfigurationSettings>> myMap;

    public ExternalSystemRunManagerListener(ExternalProjectsManager manager) {
        this.myManager = manager;
        this.myMap = ContainerUtil.newConcurrentMap();
    }

    @Override
    public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
        ExternalSystemRunManagerListener.add(this.myMap, settings);
    }

    @Override
    public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings.getConfiguration() instanceof ExternalSystemRunConfiguration) {
            Pair<String, RunnerAndConfigurationSettings> pair = this.myMap.remove(System.identityHashCode(settings));
            if (pair == null) {
                return;
            }
            ExternalProjectsManager.ExternalProjectsStateProvider stateProvider = this.myManager.getStateProvider();
            ExternalSystemTaskExecutionSettings taskExecutionSettings = ((ExternalSystemRunConfiguration)settings.getConfiguration()).getSettings();
            if (taskExecutionSettings.getExternalProjectPath() == null) {
                return;
            }
            TaskActivationState activation = stateProvider.getTasksActivation(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath());
            block0: for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
                Iterator<String> iterator = activation.getTasks(phase).iterator();
                while (iterator.hasNext()) {
                    String task = iterator.next();
                    if (!((String)pair.first).equals(task)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }
    }

    @Override
    public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
        Pair<String, RunnerAndConfigurationSettings> pair;
        if (settings.getConfiguration() instanceof ExternalSystemRunConfiguration && (pair = this.myMap.get(System.identityHashCode(settings))) != null) {
            ExternalProjectsManager.ExternalProjectsStateProvider stateProvider = this.myManager.getStateProvider();
            ExternalSystemTaskExecutionSettings taskExecutionSettings = ((ExternalSystemRunConfiguration)settings.getConfiguration()).getSettings();
            if (taskExecutionSettings.getExternalProjectPath() == null) {
                return;
            }
            TaskActivationState activation = stateProvider.getTasksActivation(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath());
            block0: for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
                List<String> modifiableActivationTasks = activation.getTasks(phase);
                for (String task : ContainerUtil.newArrayList(modifiableActivationTasks)) {
                    if (!((String)pair.first).equals(task)) continue;
                    modifiableActivationTasks.remove(task);
                    String runConfigurationActivationTaskName = ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(settings);
                    modifiableActivationTasks.add(runConfigurationActivationTaskName);
                    this.myMap.put(System.identityHashCode(settings), (Pair<String, RunnerAndConfigurationSettings>)Pair.create((Object)runConfigurationActivationTaskName, (Object)settings));
                    continue block0;
                }
            }
        }
    }

    public void attach() {
        this.myMap.clear();
        for (ExternalSystemManager systemManager : ExternalSystemApiUtil.getAllManagers()) {
            AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(systemManager.getSystemId());
            if (configurationType == null) continue;
            List configurationSettingsList = RunManager.getInstance((Project)this.myManager.getProject()).getConfigurationSettingsList((ConfigurationType)configurationType);
            for (RunnerAndConfigurationSettings configurationSettings : configurationSettingsList) {
                ExternalSystemRunManagerListener.add(this.myMap, configurationSettings);
            }
        }
        ((RunManagerEx)RunManager.getInstance((Project)this.myManager.getProject())).addRunManagerListener(this);
    }

    public void detach() {
        this.myMap.clear();
        ((RunManagerEx)RunManager.getInstance((Project)this.myManager.getProject())).removeRunManagerListener(this);
    }

    private static void add(@NotNull Map<Integer, Pair<String, RunnerAndConfigurationSettings>> map2, @NotNull RunnerAndConfigurationSettings settings) {
        if (settings.getConfiguration() instanceof ExternalSystemRunConfiguration) {
            map2.put(System.identityHashCode(settings), (Pair<String, RunnerAndConfigurationSettings>)Pair.create((Object)ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(settings), (Object)settings));
        }
    }
}

