/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483647)
public class ModuleDataService
extends AbstractModuleDataService<ModuleData> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        return ProjectKeys.MODULE;
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<DataNode<ModuleData>> toImport, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        return () -> {
            List orphanIdeModules = ContainerUtil.newSmartList();
            for (Module module2 : modelsProvider.getModules()) {
                if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module2) || ExternalSystemApiUtil.getExternalModuleType((Module)module2) != null) continue;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
                if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath) || module2.getUserData(AbstractModuleDataService.MODULE_DATA_KEY) != null) continue;
                orphanIdeModules.add(module2);
            }
            return orphanIdeModules;
        };
    }
}

